/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import fitters.Perturbation;
import java.util.Random;

public class FixedSTD_GaussianPerturbation
extends Perturbation {
    private double stdGaussianDistribution;

    public FixedSTD_GaussianPerturbation() {
        this.setStd(0.1);
    }

    public FixedSTD_GaussianPerturbation(double d) {
        this.setStd(d);
    }

    @Override
    public double[] perturb(double[] dArray, double[] dArray2, Random random) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = random.nextGaussian();
            dArray3[i] = dArray2[i] != 0.0 ? dArray[i] + d * this.getStd() * dArray2[i] : dArray[i] + d * this.getStd();
        }
        return dArray3;
    }

    private void setStd(double d) {
        this.stdGaussianDistribution = d;
    }

    private double getStd() {
        return this.stdGaussianDistribution;
    }
}

