/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.FitModel;
import fitters.MCMC_Fitter;
import fitters.MMWMD_FixedMultiRunLM_DirectFitter;
import fitters.Perturbation;
import fitters.Prior;
import imaging.DW_Scheme;
import java.util.Random;
import java.util.logging.Logger;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class MMWMD_FixedMCMC_Fitter
extends MCMC_Fitter {
    private static Logger logger = Logger.getLogger("camino.fitters.MMWMD_InVivoMCMC_Fitter");
    protected MMWMD_FixedMultiRunLM_DirectFitter gdfitter;
    protected int GDRUNS = 1;
    private final int numModelParams = 14;
    private final int numOptParams = 7;
    protected double WMDIFF = 6.0E-10;
    protected double CSFDIFF = 2.0E-9;

    public MMWMD_FixedMCMC_Fitter() {
    }

    public MMWMD_FixedMCMC_Fitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public MMWMD_FixedMCMC_Fitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        super(dW_Scheme, stringArray, dArray);
        if (CL_Initializer.mmwmddiff > 0.0) {
            this.WMDIFF = CL_Initializer.mmwmddiff;
        }
        this.gdfitter = new MMWMD_FixedMultiRunLM_DirectFitter(dW_Scheme, this.GDRUNS, CL_Initializer.seed);
    }

    @Override
    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[6], dArray[7], dArray[8]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2;
                dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[3], 1.0 - dArray2[1] - dArray2[2] - dArray2[3], MMWMD_FixedMCMC_Fitter.this.WMDIFF, dArray[4], dArray[5], dArray[6], MMWMD_FixedMCMC_Fitter.this.WMDIFF, dArray[4], dArray[5], MMWMD_FixedMCMC_Fitter.this.WMDIFF * dArray2[2] / (dArray2[1] + dArray2[2]), MMWMD_FixedMCMC_Fitter.this.CSFDIFF};
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 7;
            }

            @Override
            public int getNumModelParams() {
                return 14;
            }

            @Override
            public int getDirectionIndex() {
                return 6;
            }
        };
    }

    @Override
    protected void makePrior() {
        this.prior = new Prior(){
            private double minR = 1.0E-7;
            private double maxR = 2.0E-5;

            @Override
            public double prior(double[] dArray) {
                double d = dArray[0] < 0.0 ? 0.0 : 1.0;
                double d2 = dArray[1] < 0.0 || dArray[1] > 1.0 ? 0.0 : 1.0;
                double d3 = dArray[2] < 0.0 || dArray[2] > 1.0 - dArray[1] ? 0.0 : 1.0;
                double d4 = dArray[3] < 0.0 || dArray[3] > 1.0 - dArray[1] - dArray[2] ? 0.0 : 1.0;
                double d5 = Math.abs(Math.sin(dArray[4]));
                double d6 = dArray[6] < this.minR || dArray[6] > this.maxR ? 0.0 : 1.0;
                return d * d2 * d3 * d4 * d5 * d6;
            }
        };
    }

    @Override
    protected void makePerturbation() {
        this.perturbation = new Perturbation(){

            @Override
            public double[] perturb(double[] dArray, double[] dArray2, Random random) {
                double[] dArray3 = new double[dArray.length];
                double d = 0.2;
                double d2 = 0.001;
                dArray3[0] = dArray[0];
                dArray3[1] = dArray[1] + d * random.nextGaussian();
                dArray3[2] = dArray[1] + dArray[2] - dArray3[1];
                dArray3[3] = dArray[3];
                dArray3[4] = dArray[4];
                dArray3[5] = dArray[5];
                dArray3[6] = dArray[6] + dArray2[6] * d * random.nextGaussian();
                return dArray3;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double[] dArray2 = new double[14];
        try {
            double[] dArray3 = MultiRunMinimizer.getBestSolution(this.gdfitter.fit(dArray));
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray3[i + 1];
            }
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.gdfitter.getStartPoint(dArray);
            logger.warning(minimizerException.toString());
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        MMWMD_FixedMCMC_Fitter mMWMD_FixedMCMC_Fitter = new MMWMD_FixedMCMC_Fitter(CL_Initializer.imPars);
        int n = 1;
        while (CL_Initializer.data.more()) {
            try {
                long l = System.currentTimeMillis();
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = mMWMD_FixedMCMC_Fitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
                long l2 = System.currentTimeMillis();
                logger.info(" current step is " + n + ", time of minimization is " + (l2 - l) + " ms.");
                ++n;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

