/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.FixedSTD_GaussianPerturbation;
import fitters.MMWMD_FixedLM_DirectFitter;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.MultiRunLM_Minimizer;
import tools.CL_Initializer;

public class MMWMD_FixedMultiRunLM_DirectFitter
extends MMWMD_FixedLM_DirectFitter {
    public MMWMD_FixedMultiRunLM_DirectFitter(DW_Scheme dW_Scheme, int n, int n2) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("cylindergpd"), new String("zeppelin"), new String("dot"), new String("ball")};
        double[] dArray = new double[14];
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initMultiRunLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel), new FixedSTD_GaussianPerturbation(), n, n2);
            ((MultiRunLM_Minimizer)this.minimizer).setCONVERGETHRESH(1.0E-8);
            ((MultiRunLM_Minimizer)this.minimizer).setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        MMWMD_FixedMultiRunLM_DirectFitter mMWMD_FixedMultiRunLM_DirectFitter = new MMWMD_FixedMultiRunLM_DirectFitter(CL_Initializer.imPars, 3, 0);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = mMWMD_FixedMultiRunLM_DirectFitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

