/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.FitModel;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.DT;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import numerics.RealMatrix;
import numerics.Vector3D;
import optimizers.LM_Minimizer;
import tools.CL_Initializer;

public class MMWMD_InVivoLM_DirectFitter
extends CompartmentFitter {
    protected LinearDT_Inversion dtfitter;
    private final int numModelParams = 13;
    private final int numOptParams = 6;
    protected double WMDIFF = 1.7E-9;
    protected double CSFDIFF = 3.0E-9;

    public MMWMD_InVivoLM_DirectFitter() {
    }

    public MMWMD_InVivoLM_DirectFitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public MMWMD_InVivoLM_DirectFitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        if (CL_Initializer.mmwmddiff > 0.0) {
            this.WMDIFF = CL_Initializer.mmwmddiff;
        }
        this.scheme = dW_Scheme;
        this.makeCodec();
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    protected void makeCodec() {
        this.cod = new Codec(){
            private double minR = 1.0E-7;
            private double maxR = 2.0E-5;

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.acos(Math.sqrt(dArray[2] / (1.0 - dArray[1]))), dArray[5], dArray[6], Math.acos(Math.sqrt((dArray[7] - this.minR) / this.maxR))};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[13];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                dArray2[1] = d * d;
                double d2 = Math.cos(dArray[2]);
                dArray2[2] = (1.0 - dArray2[1]) * d2 * d2;
                dArray2[3] = 1.0 - dArray2[1] - dArray2[2];
                dArray2[4] = MMWMD_InVivoLM_DirectFitter.this.WMDIFF;
                dArray2[5] = dArray[3];
                dArray2[6] = dArray[4];
                dArray2[7] = this.minR + Math.cos(dArray[5]) * Math.cos(dArray[5]) * this.maxR;
                dArray2[8] = MMWMD_InVivoLM_DirectFitter.this.WMDIFF;
                dArray2[9] = dArray[3];
                dArray2[10] = dArray[4];
                dArray2[11] = MMWMD_InVivoLM_DirectFitter.this.WMDIFF * dArray2[2] / (dArray2[1] + dArray2[2]);
                dArray2[12] = MMWMD_InVivoLM_DirectFitter.this.CSFDIFF;
                return dArray2;
            }

            @Override
            public RealMatrix getJacobian(double[] dArray) {
                RealMatrix realMatrix = new RealMatrix(13, 6);
                realMatrix.entries[0][0] = 2.0 * dArray[0];
                double d = Math.sin(dArray[1]) * Math.cos(dArray[1]);
                double d2 = Math.cos(dArray[1]) * Math.cos(dArray[1]);
                double d3 = Math.sin(dArray[2]) * Math.cos(dArray[2]);
                double d4 = Math.cos(dArray[2]) * Math.cos(dArray[2]);
                realMatrix.entries[1][1] = -2.0 * d;
                realMatrix.entries[2][1] = 2.0 * d * d4;
                realMatrix.entries[3][1] = 2.0 * d * (1.0 - d4);
                realMatrix.entries[2][2] = -2.0 * (1.0 - d2) * d3;
                realMatrix.entries[3][2] = 2.0 * d3 * (1.0 - d2);
                realMatrix.entries[5][3] = 1.0;
                realMatrix.entries[6][4] = 1.0;
                realMatrix.entries[7][5] = -2.0 * this.maxR * Math.sin(dArray[5]) * Math.cos(dArray[5]);
                realMatrix.entries[9][3] = 1.0;
                realMatrix.entries[10][4] = 1.0;
                double d5 = d2;
                double d6 = (1.0 - d2) * d4;
                double d7 = d5 + d6;
                realMatrix.entries[11][1] = -MMWMD_InVivoLM_DirectFitter.this.WMDIFF * (d7 * realMatrix.entries[1][1] - d5 * (realMatrix.entries[1][1] + realMatrix.entries[2][1])) / (d7 * d7);
                realMatrix.entries[11][2] = MMWMD_InVivoLM_DirectFitter.this.WMDIFF * realMatrix.entries[2][2] * d5 / (d7 * d7);
                return realMatrix;
            }

            @Override
            public int getNumOptParams() {
                return 6;
            }

            @Override
            public int getNumModelParams() {
                return 13;
            }

            @Override
            public int getDirectionIndex() {
                return 5;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double[] dArray2 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double d = dArray2[1];
        double[][] dArray3 = dT.sortedEigenSystem();
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        double[] dArray4 = Vector3D.thetaPhi(vector3D);
        double d2 = dArray4[0];
        double d3 = -dArray4[1];
        double d4 = dT.fa();
        double[] dArray5 = new double[13];
        dArray5[0] = Math.exp(d);
        dArray5[1] = d4;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        double d5 = 0.01;
        dArray5[2] = 1.0 - dArray5[1] - d5;
        dArray5[3] = d5;
        dArray5[4] = this.WMDIFF;
        dArray5[5] = d2;
        dArray5[6] = d3;
        dArray5[7] = 1.0E-6;
        dArray5[8] = this.WMDIFF;
        dArray5[9] = d2;
        dArray5[10] = d3;
        dArray5[11] = dArray5[2] * this.WMDIFF;
        dArray5[12] = this.CSFDIFF;
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        MMWMD_InVivoLM_DirectFitter mMWMD_InVivoLM_DirectFitter = new MMWMD_InVivoLM_DirectFitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = mMWMD_InVivoLM_DirectFitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

