/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.NoiseModel;
import fitters.ZeppelinCylinderLM_Fitter;
import fitters.ZeppelinCylinderMultiRunLM_Fitter;
import imaging.DW_Scheme;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class ZeppelinCylinderAstrosticksLM_Fitter
extends CompartmentFitter {
    protected ZeppelinCylinderLM_Fitter zcfitter;
    private final int numModelParams = 13;
    private final int numOptParams = 8;

    public ZeppelinCylinderAstrosticksLM_Fitter() {
    }

    public ZeppelinCylinderAstrosticksLM_Fitter(DW_Scheme dW_Scheme) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("cylindergpd"), new String("zeppelin"), new String("astrosticks")};
        double[] dArray = new double[]{1.0, 0.7, 0.2, 0.1, 1.7E-9, 1.570796326794897, 1.570796326794897, 2.0E-6, 1.7E-9, 1.570796326794897, 1.570796326794897, 1.7E-10, 1.7E-9};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.zcfitter = new ZeppelinCylinderMultiRunLM_Fitter(dW_Scheme, 3, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.acos(Math.sqrt(dArray[2] / (1.0 - dArray[1]))), Math.sqrt(dArray[4]), dArray[5], dArray[6], Math.acos(Math.sqrt((dArray[7] - 1.0E-7) / 2.0E-5)), Math.asin(Math.sqrt(dArray[11] / dArray[4]))};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double d;
                double[] dArray2 = new double[13];
                dArray2[0] = dArray[0] * dArray[0];
                double d2 = Math.cos(dArray[1]);
                d2 *= d2;
                dArray2[1] = d2;
                dArray2[2] = d = Math.cos(dArray[2]) * Math.cos(dArray[2]) * (1.0 - d2);
                dArray2[3] = 1.0 - d2 - d;
                dArray2[4] = dArray[3] * dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = dArray[5];
                dArray2[7] = 1.0E-7 + Math.cos(dArray[6]) * Math.cos(dArray[6]) * 2.0E-5;
                dArray2[8] = dArray2[4];
                dArray2[9] = dArray2[5];
                dArray2[10] = dArray2[6];
                dArray2[11] = Math.sin(dArray[7]) * Math.sin(dArray[7]);
                dArray2[11] = dArray2[11] * dArray2[4];
                dArray2[12] = dArray2[4];
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 8;
            }

            @Override
            public int getNumModelParams() {
                return 13;
            }

            @Override
            public int getDirectionIndex() {
                return 5;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray3 = MultiRunMinimizer.getBestSolution(this.zcfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray3 = this.zcfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray3[1];
        double d2 = dArray3[2] - 5.0E-5;
        double d3 = dArray3[3] - 5.0E-5;
        double d4 = 1.0E-4;
        double d5 = dArray3[4];
        double d6 = dArray3[5];
        double d7 = dArray3[6];
        double d8 = dArray3[7];
        double d9 = dArray3[11];
        dArray2 = new double[]{d, d2, d3, d4, d5, d6, d7, d8, dArray2[4], dArray2[5], dArray2[6], d9, dArray2[4]};
        return dArray2;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinCylinderAstrosticksLM_Fitter zeppelinCylinderAstrosticksLM_Fitter = new ZeppelinCylinderAstrosticksLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinCylinderAstrosticksLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

