/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.FitModel;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.DT;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import numerics.RealMatrix;
import numerics.Vector3D;
import optimizers.LM_Minimizer;
import tools.CL_Initializer;

public class ZeppelinCylinderDotLM_DirectFitter
extends CompartmentFitter {
    protected LinearDT_Inversion dtfitter;
    private final int numModelParams = 12;
    private final int numOptParams = 8;

    public ZeppelinCylinderDotLM_DirectFitter() {
    }

    public ZeppelinCylinderDotLM_DirectFitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public ZeppelinCylinderDotLM_DirectFitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    protected void makeCodec() {
        this.cod = new Codec(){
            private double minR = 1.0E-7;
            private double maxR = 2.0E-5;

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.acos(Math.sqrt(dArray[2] / (1.0 - dArray[1]))), Math.sqrt(dArray[4]), dArray[5], dArray[6], Math.acos(Math.sqrt((dArray[7] - this.minR) / this.maxR)), Math.asin(Math.sqrt(dArray[11] / dArray[4]))};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double d;
                double[] dArray2 = new double[12];
                dArray2[0] = dArray[0] * dArray[0];
                double d2 = Math.cos(dArray[1]);
                d2 *= d2;
                dArray2[1] = d2;
                dArray2[2] = d = Math.cos(dArray[2]) * Math.cos(dArray[2]) * (1.0 - d2);
                dArray2[3] = 1.0 - d2 - d;
                dArray2[4] = dArray[3] * dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = dArray[5];
                dArray2[7] = this.minR + Math.cos(dArray[6]) * Math.cos(dArray[6]) * this.maxR;
                dArray2[8] = dArray2[4];
                dArray2[9] = dArray2[5];
                dArray2[10] = dArray2[6];
                dArray2[11] = Math.sin(dArray[7]) * Math.sin(dArray[7]);
                dArray2[11] = dArray2[11] * dArray2[4];
                return dArray2;
            }

            @Override
            public RealMatrix getJacobian(double[] dArray) {
                RealMatrix realMatrix = new RealMatrix(12, 8);
                realMatrix.entries[0][0] = 2.0 * dArray[0];
                double d = Math.sin(dArray[1]) * Math.cos(dArray[1]);
                double d2 = Math.cos(dArray[1]) * Math.cos(dArray[1]);
                double d3 = Math.sin(dArray[2]) * Math.cos(dArray[2]);
                double d4 = Math.cos(dArray[2]) * Math.cos(dArray[2]);
                realMatrix.entries[1][1] = -2.0 * d;
                realMatrix.entries[2][1] = 2.0 * d * d4;
                realMatrix.entries[3][1] = 2.0 * d * (1.0 - d4);
                realMatrix.entries[2][2] = -2.0 * (1.0 - d2) * d3;
                realMatrix.entries[3][2] = 2.0 * d3 * (1.0 - d2);
                realMatrix.entries[4][3] = 2.0 * dArray[3];
                realMatrix.entries[5][4] = 1.0;
                realMatrix.entries[6][5] = 1.0;
                realMatrix.entries[7][6] = -2.0 * this.maxR * Math.sin(dArray[6]) * Math.cos(dArray[6]);
                realMatrix.entries[8][3] = 2.0 * dArray[3];
                realMatrix.entries[9][4] = 1.0;
                realMatrix.entries[10][5] = 1.0;
                realMatrix.entries[11][3] = 2.0 * dArray[3] * Math.sin(dArray[7]) * Math.sin(dArray[7]);
                realMatrix.entries[11][7] = 2.0 * dArray[3] * dArray[3] * Math.sin(dArray[7]) * Math.cos(dArray[7]);
                return realMatrix;
            }

            @Override
            public int getNumOptParams() {
                return 8;
            }

            @Override
            public int getNumModelParams() {
                return 12;
            }

            @Override
            public int getDirectionIndex() {
                return 5;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double d = this.scheme.geoMeanZeroMeas(dArray);
        double[] dArray2 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double d2 = dArray2[1];
        double[][] dArray3 = dT.sortedEigenSystem();
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        double[] dArray4 = Vector3D.thetaPhi(vector3D);
        double d3 = dArray4[0];
        double d4 = -dArray4[1];
        double d5 = dT.fa();
        double d6 = Math.abs(dArray3[0][0]);
        double d7 = Math.abs(dArray3[0][1]);
        double[] dArray5 = new double[12];
        dArray5[0] = Math.exp(d2);
        dArray5[1] = d5;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        double d8 = 0.01;
        dArray5[2] = 1.0 - dArray5[1] - d8;
        dArray5[3] = d8;
        dArray5[4] = d6;
        dArray5[5] = d3;
        dArray5[6] = d4;
        dArray5[7] = 1.0E-6;
        dArray5[8] = dArray5[4];
        dArray5[9] = d3;
        dArray5[10] = d4;
        dArray5[11] = d7;
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinCylinderDotLM_DirectFitter zeppelinCylinderDotLM_DirectFitter = new ZeppelinCylinderDotLM_DirectFitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinCylinderDotLM_DirectFitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

