/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.FitModel;
import fitters.MCMC_Fitter;
import fitters.Perturbation;
import fitters.Prior;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import java.util.Random;
import java.util.logging.Logger;
import misc.DT;
import numerics.Vector3D;
import tools.CL_Initializer;

public class ZeppelinCylinderDotMCMC_GaussianFitter
extends MCMC_Fitter {
    private static Logger logger = Logger.getLogger("camino.fitters.ZeppelinCylinderDotMCMC_GaussianFitter");
    protected LinearDT_Inversion dtfitter;
    private final int numModelParams = 12;
    private final int numOptParams = 8;

    public ZeppelinCylinderDotMCMC_GaussianFitter() {
    }

    public ZeppelinCylinderDotMCMC_GaussianFitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public ZeppelinCylinderDotMCMC_GaussianFitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        super(dW_Scheme, stringArray, dArray);
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    @Override
    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[4], dArray[5], dArray[6], dArray[7], dArray[11]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], 1.0 - dArray[1] - dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[3], dArray[4], dArray[5], dArray[7]};
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 8;
            }

            @Override
            public int getNumModelParams() {
                return 12;
            }

            @Override
            public int getDirectionIndex() {
                return 5;
            }
        };
    }

    @Override
    protected void makePrior() {
        this.prior = new Prior(){

            @Override
            public double prior(double[] dArray) {
                double d = dArray[0] < 0.0 ? 0.0 : 1.0;
                double d2 = dArray[1] < 0.0 || dArray[1] > 1.0 ? 0.0 : 1.0;
                double d3 = dArray[2] < 0.0 || dArray[2] > 1.0 - dArray[1] ? 0.0 : 1.0;
                double d4 = dArray[3] < 0.0 ? 0.0 : 1.0;
                double d5 = dArray[7] < 0.0 || dArray[7] > 1.0 - dArray[3] ? 0.0 : 1.0;
                double d6 = dArray[6] < 0.0 ? 0.0 : 1.0;
                double d7 = Math.abs(Math.sin(dArray[4]));
                return d * d2 * d3 * d4 * d5 * d6 * d7;
            }
        };
    }

    @Override
    protected void makePerturbation() {
        this.perturbation = new Perturbation(){

            @Override
            public double[] perturb(double[] dArray, double[] dArray2, Random random) {
                double[] dArray3 = new double[dArray.length];
                double d = 0.05;
                double d2 = 0.001;
                dArray3[0] = dArray[0] + dArray2[0] * d * random.nextGaussian();
                dArray3[1] = dArray[1] + d * random.nextGaussian();
                dArray3[2] = dArray[2] + d * random.nextGaussian();
                dArray3[3] = dArray[3] + dArray2[3] * d * random.nextGaussian();
                dArray3[7] = dArray[7] + dArray2[7] * d * random.nextGaussian();
                dArray3[6] = dArray[6] + dArray2[6] * d * random.nextGaussian();
                dArray3[4] = dArray[4] + d2 * random.nextGaussian();
                dArray3[5] = dArray[5] + d2 * random.nextGaussian();
                return dArray3;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double[] dArray2 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double d = dArray2[1];
        double[][] dArray3 = dT.sortedEigenSystem();
        double d2 = dArray3[0][0];
        double d3 = dArray3[0][2];
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        double[] dArray4 = Vector3D.thetaPhi(vector3D);
        double d4 = dArray4[0];
        double d5 = -dArray4[1];
        double d6 = dT.fa();
        double[] dArray5 = new double[12];
        dArray5[0] = Math.exp(d);
        dArray5[1] = d6;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        dArray5[2] = 1.0 - d6;
        dArray5[3] = 0.0;
        dArray5[4] = d2;
        dArray5[5] = d4;
        dArray5[6] = d5;
        dArray5[7] = 1.0E-6;
        dArray5[8] = d2;
        dArray5[9] = d4;
        dArray5[10] = d5;
        dArray5[11] = d3;
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinCylinderDotMCMC_GaussianFitter zeppelinCylinderDotMCMC_GaussianFitter = new ZeppelinCylinderDotMCMC_GaussianFitter(CL_Initializer.imPars);
        int n = 1;
        while (CL_Initializer.data.more()) {
            try {
                long l = System.currentTimeMillis();
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinCylinderDotMCMC_GaussianFitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
                long l2 = System.currentTimeMillis();
                logger.info(" current step is " + n + ", time of minimization is " + (l2 - l) + " ms.");
                ++n;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

