/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.BallCylinderLM_Fitter;
import fitters.BallCylinderMultiRunLM_Fitter;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.FitModel;
import fitters.NoiseModel;
import fitters.ZeppelinStickLM_Fitter;
import fitters.ZeppelinStickMultiRunLM_Fitter;
import imaging.DW_Scheme;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class ZeppelinCylinderLM_Fitter
extends CompartmentFitter {
    protected BallCylinderLM_Fitter bcfitter;
    protected ZeppelinStickLM_Fitter zsfitter;
    private final int numModelParams = 11;
    private final int numOptParams = 7;

    public ZeppelinCylinderLM_Fitter() {
    }

    public ZeppelinCylinderLM_Fitter(DW_Scheme dW_Scheme) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = FitModel.getCompartmentList(CL_Initializer.fitModel);
        double[] dArray = FitModel.getCompartmentModelParams(CL_Initializer.fitModel);
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.bcfitter = new BallCylinderMultiRunLM_Fitter(dW_Scheme, 1, 0);
        this.zsfitter = new ZeppelinStickMultiRunLM_Fitter(dW_Scheme, 1, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.sqrt(dArray[3]), dArray[4], dArray[5], Math.acos(Math.sqrt((dArray[6] - 1.0E-7) / 2.0E-5)), Math.asin(Math.sqrt(dArray[10] / dArray[3]))};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[11];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                d *= d;
                dArray2[1] = d;
                dArray2[2] = 1.0 - d;
                dArray2[3] = dArray[2] * dArray[2];
                dArray2[4] = dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = 1.0E-7 + Math.cos(dArray[5]) * Math.cos(dArray[5]) * 2.0E-5;
                dArray2[7] = dArray2[3];
                dArray2[8] = dArray2[4];
                dArray2[9] = dArray2[5];
                dArray2[10] = Math.sin(dArray[6]) * Math.sin(dArray[6]);
                dArray2[10] = dArray2[10] * dArray2[3];
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 7;
            }

            @Override
            public int getNumModelParams() {
                return 11;
            }

            @Override
            public int getDirectionIndex() {
                return 4;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray3 = MultiRunMinimizer.getBestSolution(this.bcfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray3 = this.bcfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        try {
            dArray2 = MultiRunMinimizer.getBestSolution(this.zsfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.zsfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray2[1];
        double d2 = dArray2[5];
        double d3 = dArray2[6];
        double d4 = dArray2[2];
        double d5 = dArray2[4];
        double d6 = dArray3[7];
        double d7 = dArray2[10];
        double[] dArray4 = new double[11];
        dArray4[0] = d;
        dArray4[1] = d4;
        dArray4[1] = dArray4[1] < 0.1 ? 0.1 : dArray4[1];
        dArray4[1] = dArray4[1] > 0.9 ? 0.9 : dArray4[1];
        dArray4[2] = 1.0 - dArray4[1];
        dArray4[3] = d5;
        dArray4[4] = d2;
        dArray4[5] = d3;
        dArray4[6] = d6;
        dArray4[7] = dArray4[3];
        dArray4[8] = dArray4[4];
        dArray4[9] = dArray4[5];
        dArray4[10] = d7;
        return dArray4;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinCylinderLM_Fitter zeppelinCylinderLM_Fitter = new ZeppelinCylinderLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinCylinderLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

