/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.FixedSTD_GaussianPerturbation;
import fitters.NoiseModel;
import fitters.ZeppelinCylinderMultiRunLM_Fitter;
import fitters.ZeppelinGDRCylindersAstrosticksLM_Fitter;
import imaging.DW_Scheme;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.MultiRunLM_Minimizer;
import tools.CL_Initializer;

public class ZeppelinGDRCylindersAstrosticksMultiRunLM_Fitter
extends ZeppelinGDRCylindersAstrosticksLM_Fitter {
    public ZeppelinGDRCylindersAstrosticksMultiRunLM_Fitter(DW_Scheme dW_Scheme, int n, int n2) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("gammadistribradiicylinders"), new String("zeppelin"), new String("astrosticks")};
        double[] dArray = new double[]{1.0, 0.5, 0.3, 0.2, 1.0, 1.7E-9, 1.5, 1.5, 1.7E-9, 1.5, 1.5, 1.7E-10, 1.7E-10, 1.7E-10};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initMultiRunLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel), new FixedSTD_GaussianPerturbation(), n, n2);
            ((MultiRunLM_Minimizer)this.minimizer).setCONVERGETHRESH(1.0E-8);
            ((MultiRunLM_Minimizer)this.minimizer).setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.zcfitter = new ZeppelinCylinderMultiRunLM_Fitter(dW_Scheme, 1, 0);
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinGDRCylindersAstrosticksMultiRunLM_Fitter zeppelinGDRCylindersAstrosticksMultiRunLM_Fitter = new ZeppelinGDRCylindersAstrosticksMultiRunLM_Fitter(CL_Initializer.imPars, 100, 0);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinGDRCylindersAstrosticksMultiRunLM_Fitter.fit(dArray);
                for (int i = 0; i < dArray2.length; ++i) {
                    outputManager.output(dArray2[i]);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

