/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.FitModel;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.DT;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import numerics.RealMatrix;
import numerics.Vector3D;
import optimizers.LM_Minimizer;
import tools.CL_Initializer;

public class ZeppelinStickLM_DirectFitter
extends CompartmentFitter {
    protected LinearDT_Inversion dtfitter;
    private final int numModelParams = 10;
    private final int numOptParams = 6;

    public ZeppelinStickLM_DirectFitter() {
    }

    public ZeppelinStickLM_DirectFitter(DW_Scheme dW_Scheme) {
        this(dW_Scheme, FitModel.getCompartmentList(CL_Initializer.fitModel), FitModel.getCompartmentModelParams(CL_Initializer.fitModel));
    }

    public ZeppelinStickLM_DirectFitter(DW_Scheme dW_Scheme, String[] stringArray, double[] dArray) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.sqrt(dArray[3]), dArray[4], dArray[5], Math.asin(Math.sqrt(dArray[9] / dArray[3]))};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[10];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                d *= d;
                dArray2[1] = d;
                dArray2[2] = 1.0 - d;
                dArray2[3] = dArray[2] * dArray[2];
                dArray2[4] = dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = dArray2[3];
                dArray2[7] = dArray2[4];
                dArray2[8] = dArray2[5];
                dArray2[9] = Math.sin(dArray[5]) * Math.sin(dArray[5]);
                dArray2[9] = dArray2[9] * dArray2[3];
                return dArray2;
            }

            @Override
            public RealMatrix getJacobian(double[] dArray) {
                RealMatrix realMatrix = new RealMatrix(10, 6);
                realMatrix.entries[0][0] = 2.0 * dArray[0];
                realMatrix.entries[1][1] = -2.0 * Math.sin(dArray[1]) * Math.cos(dArray[1]);
                realMatrix.entries[2][1] = 2.0 * Math.sin(dArray[1]) * Math.cos(dArray[1]);
                realMatrix.entries[3][2] = 2.0 * dArray[2];
                realMatrix.entries[4][3] = 1.0;
                realMatrix.entries[5][4] = 1.0;
                realMatrix.entries[6][2] = 2.0 * dArray[2];
                realMatrix.entries[7][3] = 1.0;
                realMatrix.entries[8][4] = 1.0;
                realMatrix.entries[9][2] = 2.0 * dArray[2] * Math.sin(dArray[5]) * Math.sin(dArray[5]);
                realMatrix.entries[9][5] = 2.0 * dArray[2] * dArray[2] * Math.sin(dArray[5]) * Math.cos(dArray[5]);
                return realMatrix;
            }

            @Override
            public int getNumOptParams() {
                return 6;
            }

            @Override
            public int getNumModelParams() {
                return 10;
            }

            @Override
            public int getDirectionIndex() {
                return 4;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        double d = this.scheme.geoMeanZeroMeas(dArray);
        double[] dArray2 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double d2 = dArray2[1];
        double[][] dArray3 = dT.sortedEigenSystem();
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        double[] dArray4 = Vector3D.thetaPhi(vector3D);
        double d3 = dArray4[0];
        double d4 = -dArray4[1];
        double d5 = dT.fa();
        double d6 = Math.abs(dArray3[0][0]);
        double d7 = Math.abs(dArray3[0][1]);
        double[] dArray5 = new double[10];
        dArray5[0] = Math.exp(d2);
        dArray5[1] = d5;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        dArray5[2] = 1.0 - dArray5[1];
        dArray5[3] = d6;
        dArray5[4] = d3;
        dArray5[5] = d4;
        dArray5[6] = dArray5[3];
        dArray5[7] = d3;
        dArray5[8] = d4;
        dArray5[9] = d7;
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinStickLM_DirectFitter zeppelinStickLM_DirectFitter = new ZeppelinStickLM_DirectFitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinStickLM_DirectFitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

