/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.BallStickLM_GaussianFitter;
import fitters.BallStickMultiRunLM_GaussianFitter;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import inverters.LinearDT_Inversion;
import misc.DT;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import numerics.RealMatrix;
import numerics.Vector3D;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class ZeppelinStickLM_Fitter
extends CompartmentFitter {
    protected LinearDT_Inversion dtfitter;
    protected BallStickLM_GaussianFitter bsfitter;
    private final int numModelParams = 10;
    private final int numOptParams = 6;

    public ZeppelinStickLM_Fitter() {
    }

    public ZeppelinStickLM_Fitter(DW_Scheme dW_Scheme) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("stick"), new String("zeppelin")};
        double[] dArray = new double[]{1.0, 0.7, 0.3, 1.7E-9, 1.570796326794897, 1.570796326794897, 1.7E-9, 1.570796326794897, 1.570796326794897, 1.7E-10};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.dtfitter = new LinearDT_Inversion(dW_Scheme);
        this.bsfitter = new BallStickMultiRunLM_GaussianFitter(dW_Scheme, 3, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.sqrt(dArray[3]), dArray[4], dArray[5], Math.asin(Math.sqrt(dArray[9] / dArray[3]))};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[10];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                d *= d;
                dArray2[1] = d;
                dArray2[2] = 1.0 - d;
                dArray2[3] = dArray[2] * dArray[2];
                dArray2[4] = dArray[3];
                dArray2[5] = dArray[4];
                dArray2[6] = dArray2[3];
                dArray2[7] = dArray2[4];
                dArray2[8] = dArray2[5];
                dArray2[9] = Math.sin(dArray[5]) * Math.sin(dArray[5]);
                dArray2[9] = dArray2[9] * dArray2[3];
                return dArray2;
            }

            @Override
            public RealMatrix getJacobian(double[] dArray) {
                RealMatrix realMatrix = new RealMatrix(10, 6);
                realMatrix.entries[0][0] = 2.0 * dArray[0];
                realMatrix.entries[1][1] = -2.0 * Math.sin(dArray[1]) * Math.cos(dArray[1]);
                realMatrix.entries[2][1] = 2.0 * Math.sin(dArray[1]) * Math.cos(dArray[1]);
                realMatrix.entries[3][2] = 2.0 * dArray[2];
                realMatrix.entries[4][3] = 1.0;
                realMatrix.entries[5][4] = 1.0;
                realMatrix.entries[6][2] = 2.0 * dArray[2];
                realMatrix.entries[7][3] = 1.0;
                realMatrix.entries[8][4] = 1.0;
                realMatrix.entries[9][2] = 2.0 * dArray[2] * Math.sin(dArray[5]) * Math.sin(dArray[5]);
                realMatrix.entries[9][5] = 2.0 * dArray[2] * dArray[2] * Math.sin(dArray[5]) * Math.cos(dArray[5]);
                return realMatrix;
            }

            @Override
            public int getNumOptParams() {
                return 6;
            }

            @Override
            public int getNumModelParams() {
                return 10;
            }

            @Override
            public int getDirectionIndex() {
                return 4;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray2 = MultiRunMinimizer.getBestSolution(this.bsfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.bsfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray2[1];
        double d2 = dArray2[5];
        double d3 = dArray2[6];
        double d4 = dArray2[2];
        double d5 = dArray2[4];
        double[] dArray3 = this.dtfitter.invert(dArray);
        DT dT = new DT(dArray3[2], dArray3[3], dArray3[4], dArray3[5], dArray3[6], dArray3[7]);
        double[][] dArray4 = dT.sortedEigenSystem();
        Vector3D vector3D = new Vector3D(dArray4[1][0], dArray4[2][0], dArray4[3][0]);
        double d6 = dArray4[0][1];
        double[] dArray5 = new double[10];
        dArray5[0] = d;
        dArray5[1] = d4;
        dArray5[1] = dArray5[1] < 0.1 ? 0.1 : dArray5[1];
        dArray5[1] = dArray5[1] > 0.9 ? 0.9 : dArray5[1];
        dArray5[2] = 1.0 - dArray5[1];
        dArray5[3] = d5;
        dArray5[4] = d2;
        dArray5[5] = d3;
        dArray5[6] = dArray5[3];
        dArray5[7] = dArray5[4];
        dArray5[8] = dArray5[5];
        dArray5[9] = d6;
        return dArray5;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        ZeppelinStickLM_Fitter zeppelinStickLM_Fitter = new ZeppelinStickLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = zeppelinStickLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

