/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.DW_Scheme;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.SphericalPoints;

public class B_VectorScheme
extends DW_Scheme {
    public static final String VERSION = "BVECTOR";
    private static final Logger logger = Logger.getLogger("camino.imaging.B_VectorScheme");
    private final double[] bValue;

    public B_VectorScheme(double[][] dArray, double[] dArray2) {
        super(dArray);
        this.bValue = new double[this.numMeas];
        System.arraycopy(dArray2, 0, this.bValue, 0, this.numMeas);
    }

    @Override
    public double getB_Value(int n) {
        return this.bValue[n];
    }

    private DW_Scheme flip(int n) {
        double[][] dArray = new double[this.numMeas][3];
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            dArray[i] = this.getG_Dir(i);
            dArray[i][n] = -dArray[i][n];
        }
        return new B_VectorScheme(dArray, this.bValue);
    }

    @Override
    public DW_Scheme flipX() {
        return this.flip(0);
    }

    @Override
    public DW_Scheme flipY() {
        return this.flip(1);
    }

    @Override
    public DW_Scheme flipZ() {
        return this.flip(2);
    }

    @Override
    public DW_Scheme getSubsetScheme(int[] nArray) {
        int n = nArray.length;
        double[][] dArray = new double[nArray.length][3];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.getG_Dir(nArray[i]), 0, dArray[i], 0, 3);
            dArray2[i] = this.bValue[nArray[i]];
        }
        return new B_VectorScheme(dArray, dArray2);
    }

    @Override
    public DW_Scheme gradOrder(int[] nArray) {
        double[][] dArray = new double[this.numMeas][3];
        for (int i = 0; i < this.numMeas; ++i) {
            double[] dArray2 = this.getG_Dir(i);
            dArray[i][0] = dArray2[nArray[0]];
            dArray[i][1] = dArray2[nArray[1]];
            dArray[i][2] = dArray2[nArray[2]];
        }
        return new B_VectorScheme(dArray, this.bValue);
    }

    public static B_VectorScheme elecPointSetScheme(int n, int n2, double d) {
        double[][] dArray = SphericalPoints.getElecPointSet(n2);
        double[][] dArray2 = new double[n + n2][3];
        double[] dArray3 = new double[n2 + n];
        for (int i = 0; i < n2; ++i) {
            dArray3[n + i] = d;
            dArray2[n + i] = dArray[i];
        }
        return new B_VectorScheme(dArray2, dArray3);
    }

    protected static B_VectorScheme readScheme(Vector<String> vector) {
        if (vector.size() < 1) {
            throw new LoggedException("No measurements in scheme file");
        }
        int n = vector.size();
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            Scanner scanner = new Scanner(vector.elementAt(i));
            dArray[i][0] = scanner.nextDouble();
            dArray[i][1] = scanner.nextDouble();
            dArray[i][2] = scanner.nextDouble();
            dArray2[i] = scanner.nextDouble();
            if (dArray2[i] != 0.0 || dArray[i][0] == 0.0 && dArray[i][1] == 0.0 && dArray[i][2] == 0.0) continue;
            logger.info("Zero diffusion weighting in measurement " + i + ", setting gradient direction to zero");
            dArray[i][0] = 0.0;
            dArray[i][1] = 0.0;
            dArray[i][2] = 0.0;
        }
        return new B_VectorScheme(dArray, dArray2);
    }

    protected static B_VectorScheme readQ_VectorScheme(Vector<String> vector) {
        if (vector.size() < 5) {
            throw new LoggedException("No measurements in scheme file");
        }
        double d = Double.parseDouble(vector.elementAt(0));
        double d2 = Double.parseDouble(vector.elementAt(1));
        int n = (int)d2;
        if (Math.abs((double)n - d2) > 1.0E-9) {
            throw new LoggedException("Number of measurements in scheme, " + d2 + ", is not an integer");
        }
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = new double[3];
            for (int j = 0; j < 3; ++j) {
                dArray3[j] = Double.parseDouble(vector.elementAt(2 + 3 * i + j));
            }
            double d3 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
            dArray2[i] = d3 * d3 * d;
            if (!(d3 > 0.0)) continue;
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = dArray3[j] / d3;
            }
        }
        return new B_VectorScheme(dArray, dArray2);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        DecimalFormat decimalFormat2 = new DecimalFormat("   0.000E00");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#B-vector scheme. Contains gradient directions and b-values\n");
        stringBuffer.append("#g_x\tg_y\tg_z\tb\n");
        stringBuffer.append("VERSION: BVECTOR\n");
        for (int i = 0; i < this.numMeas; ++i) {
            double[] dArray = this.getG_Dir(i);
            stringBuffer.append(decimalFormat.format(dArray[0]));
            stringBuffer.append(decimalFormat.format(dArray[1]));
            stringBuffer.append(decimalFormat.format(dArray[2]));
            stringBuffer.append(decimalFormat2.format(this.bValue[i]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

