/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.B_VectorScheme;
import imaging.GradientWaveform_Scheme;
import imaging.RectGradSteTanScheme;
import imaging.RectGradTRSE_Scheme;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import misc.LoggedException;
import numerics.RealMatrix;
import tools.ArrayOps;

public abstract class DW_Scheme {
    public static final double GAMMA = 2.6751525E8;
    private static final Logger logger = Logger.getLogger("camino.imaging.DW_Scheme");
    public static final int[] gradXYZ = new int[]{0, 1, 2};
    public static final int[] gradXZY = new int[]{0, 2, 1};
    public static final int[] gradYXZ = new int[]{1, 0, 2};
    public static final int[] gradYZX = new int[]{1, 2, 0};
    public static final int[] gradZXY = new int[]{2, 0, 1};
    public static final int[] gradZYX = new int[]{2, 1, 0};
    protected final int numMeas;
    protected final int numZeroMeas;
    private final boolean[] zero;
    protected final double[][] gDir;

    public static DW_Scheme nullScheme() {
        return B_VectorScheme.elecPointSetScheme(1, 6, 1.0E9);
    }

    protected DW_Scheme() {
        this.numMeas = 0;
        this.numZeroMeas = 0;
        this.zero = null;
        this.gDir = null;
    }

    protected DW_Scheme(double[][] dArray) {
        this.gDir = DW_Scheme.normalizeGradDirs(dArray);
        this.numMeas = this.gDir.length;
        this.zero = new boolean[this.numMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            System.arraycopy(dArray[i], 0, this.gDir[i], 0, 3);
            if (this.gDir[i][0] != 0.0 || this.gDir[i][1] != 0.0 || this.gDir[i][2] != 0.0) continue;
            this.zero[i] = true;
            ++n;
        }
        this.numZeroMeas = n;
    }

    public int numMeasurements() {
        return this.numMeas;
    }

    public int numZeroMeasurements() {
        return this.numZeroMeas;
    }

    public final double[] getG_Dir(int n) {
        double[] dArray = new double[]{this.gDir[n][0], this.gDir[n][1], this.gDir[n][2]};
        return dArray;
    }

    public final double[][] getNonZeroG_Dirs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray[n][0] = this.gDir[i][0];
            dArray[n][1] = this.gDir[i][1];
            dArray[n][2] = this.gDir[i][2];
            ++n;
        }
        if (n != this.numMeas - this.numZeroMeas) {
            throw new LoggedException("Expected " + (this.numMeas - this.numZeroMeas) + " non-zero measurements but got " + n);
        }
        return dArray;
    }

    public final double[] getNonZeroB_Values() {
        double[] dArray = new double[this.numMeas - this.numZeroMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray[n++] = this.getB_Value(i);
        }
        if (n != this.numMeas - this.numZeroMeas) {
            throw new LoggedException("Expected " + (this.numMeas - this.numZeroMeas) + " non-zero measurements but got " + n);
        }
        return dArray;
    }

    public final double[] normalizeData(double[] dArray) {
        if (dArray.length != this.numMeas) {
            throw new LoggedException("Data to be normalized does not match scheme");
        }
        if (this.numZeroMeas == 0) {
            double[] dArray2 = new double[this.numMeas];
            System.arraycopy(dArray, 0, dArray2, 0, this.numMeas);
            logger.warning("No b=0 data, cannot normalize");
            return dArray2;
        }
        return this.normalizeData(dArray, this.geoMeanZeroMeas(dArray));
    }

    public final double[] normalizeData(double[] dArray, int[] nArray) {
        if (dArray.length != this.numMeas) {
            throw new LoggedException("Data to be normalized does not match scheme");
        }
        double[] dArray2 = new double[this.numMeas - nArray.length];
        double[] dArray3 = new double[nArray.length];
        boolean[] blArray = new boolean[this.numMeas];
        for (int i = 0; i < nArray.length; ++i) {
            dArray3[i] = dArray[nArray[i]];
            blArray[nArray[i]] = true;
        }
        double d = ArrayOps.geoMean(dArray3);
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (blArray[i]) continue;
            dArray2[n++] = dArray[i] / d;
        }
        return dArray2;
    }

    public final double[] normalizeData(double[] dArray, double d) {
        if (dArray.length != this.numMeas) {
            throw new LoggedException("Data to be normalized does not match scheme");
        }
        if (!(d > 0.0)) {
            logger.warning("Can't use normalization constant " + d);
            d = 1.0;
        }
        double[] dArray2 = new double[this.numMeas - this.numZeroMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray2[n++] = dArray[i] / d;
        }
        return dArray2;
    }

    protected final double[] getNonZeroParam(double[] dArray) {
        double[] dArray2 = new double[this.numMeas - this.numZeroMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray2[n++] = dArray[i];
        }
        if (n != this.numMeas - this.numZeroMeas) {
            throw new LoggedException("Expected " + (this.numMeas - this.numZeroMeas) + " non-zero measurements but got " + n);
        }
        return dArray2;
    }

    public final double geoMeanZeroMeas(double[] dArray) {
        if (dArray.length != this.numMeas) {
            throw new LoggedException("Data to be normalized does not match scheme: data length is " + dArray.length);
        }
        if (this.numZeroMeas == 0) {
            return 1.0;
        }
        double d = 1.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (!this.zero[i]) continue;
            d *= dArray[i];
        }
        return Math.pow(d, 1.0 / (double)this.numZeroMeas);
    }

    public boolean zero(int n) {
        return this.zero[n];
    }

    public final RealMatrix getB_Matrix() {
        RealMatrix realMatrix = new RealMatrix(this.numMeas, 7);
        for (int i = 0; i < this.numMeas; ++i) {
            double d = this.getB_Value(i);
            realMatrix.setEntry(i, 0, 1.0);
            realMatrix.setEntry(i, 1, -d * this.gDir[i][0] * this.gDir[i][0]);
            realMatrix.setEntry(i, 2, -2.0 * d * this.gDir[i][0] * this.gDir[i][1]);
            realMatrix.setEntry(i, 3, -2.0 * d * this.gDir[i][0] * this.gDir[i][2]);
            realMatrix.setEntry(i, 4, -d * this.gDir[i][1] * this.gDir[i][1]);
            realMatrix.setEntry(i, 5, -2.0 * d * this.gDir[i][1] * this.gDir[i][2]);
            realMatrix.setEntry(i, 6, -d * this.gDir[i][2] * this.gDir[i][2]);
        }
        return realMatrix;
    }

    public abstract double getB_Value(int var1);

    public abstract DW_Scheme flipX();

    public abstract DW_Scheme flipY();

    public abstract DW_Scheme flipZ();

    public abstract DW_Scheme getSubsetScheme(int[] var1);

    public abstract DW_Scheme gradOrder(int[] var1);

    public static final DW_Scheme readScheme(String string) {
        try {
            String string2;
            Vector<String> vector = new Vector<String>();
            Scanner scanner = new Scanner(new File(string));
            scanner.useLocale(Locale.UK);
            scanner.useDelimiter("\r\n|\n");
            while (scanner.hasNext()) {
                string2 = scanner.next().trim();
                if (string2.length() <= 0 || string2.startsWith("#")) continue;
                vector.add(string2);
            }
            scanner.close();
            string2 = ((String)vector.elementAt(0)).trim();
            try {
                Double.parseDouble(string2);
                return B_VectorScheme.readQ_VectorScheme(vector);
            }
            catch (NumberFormatException numberFormatException) {
                vector.removeElementAt(0);
                if (Pattern.matches("VERSION:\\s*1", string2) || Pattern.matches("VERSION:\\s*STEJSKALTANNER", string2)) {
                    return RectGradSteTanScheme.readScheme(vector);
                }
                if (Pattern.matches("VERSION:\\s*2", string2) || Pattern.matches("VERSION:\\s*BVECTOR", string2)) {
                    return B_VectorScheme.readScheme(vector);
                }
                if (Pattern.matches("VERSION:\\s*3", string2) || Pattern.matches("VERSION:\\s*TRSE", string2)) {
                    return RectGradTRSE_Scheme.readScheme(vector);
                }
                if (Pattern.matches("VERSION:\\s*GRADIENT_WAVEFORM", string2)) {
                    return GradientWaveform_Scheme.readScheme(vector);
                }
                throw new LoggedException("Unrecognized scheme version string: " + string2);
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public static final double[][] normalizeGradDirs(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][3];
        for (int i = 0; i < dArray2.length; ++i) {
            double d;
            dArray2[i][0] = dArray[i][0];
            dArray2[i][1] = dArray[i][1];
            dArray2[i][2] = dArray[i][2];
            if (dArray2[i][0] == 0.0 && dArray2[i][1] == 0.0 && dArray2[i][2] == 0.0 || Math.abs(1.0 - (d = Math.sqrt(dArray2[i][0] * dArray2[i][0] + dArray2[i][1] * dArray2[i][1] + dArray2[i][2] * dArray2[i][2]))) < 1.0E-4) continue;
            int n = 0;
            while (n < 3) {
                if (Double.isNaN(dArray2[i][n])) {
                    throw new LoggedException("Can't normalize gradient " + i + ":" + dArray[i][0] + " " + dArray[i][1] + " " + dArray[i][2]);
                }
                double[] dArray3 = dArray2[i];
                int n2 = n++;
                dArray3[n2] = dArray3[n2] / d;
            }
            logger.info("measurement " + i + " has non unit gradient direction. Normalizing");
        }
        return dArray2;
    }
}

