/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class EndianCorrectInputStream
extends DataInputStream {
    private boolean bigendian = true;

    public EndianCorrectInputStream(String string, boolean bl) throws FileNotFoundException {
        super(new FileInputStream(string));
        this.bigendian = bl;
    }

    public EndianCorrectInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.bigendian = bl;
    }

    public short readShortCorrect() throws IOException {
        short s = this.readShort();
        if (this.bigendian) {
            return s;
        }
        int n = s & 0xFF;
        int n2 = s >> 8 & 0xFF;
        return (short)(n << 8 | n2);
    }

    public short flipShort(short s) {
        int n = s & 0xFF;
        int n2 = s >> 8 & 0xFF;
        return (short)(n << 8 | n2);
    }

    public int readIntCorrect() throws IOException {
        int n = this.readInt();
        if (this.bigendian) {
            return n;
        }
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public int flipInt(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public long readLongCorrect() throws IOException {
        long l = this.readLong();
        if (this.bigendian) {
            return l;
        }
        return this.flipLong(l);
    }

    public long flipLong(long l) {
        long l2 = l & 0xFFL;
        long l3 = l >> 8 & 0xFFL;
        long l4 = l >> 16 & 0xFFL;
        long l5 = l >> 24 & 0xFFL;
        long l6 = l >> 32 & 0xFFL;
        long l7 = l >> 40 & 0xFFL;
        long l8 = l >> 48 & 0xFFL;
        long l9 = l >> 56 & 0xFFL;
        return l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9;
    }

    public float readFloatCorrect() throws IOException {
        float f;
        if (this.bigendian) {
            f = this.readFloat();
        } else {
            int n = this.readUnsignedByte();
            n |= this.readUnsignedByte() << 8;
            n |= this.readUnsignedByte() << 16;
            f = Float.intBitsToFloat(n |= this.readUnsignedByte() << 24);
        }
        return f;
    }

    public float flipFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        int n2 = this.flipInt(n);
        return Float.intBitsToFloat(n2);
    }

    public double readDoubleCorrect() throws IOException {
        double d;
        if (this.bigendian) {
            d = this.readDouble();
        } else {
            long l = this.readUnsignedByte();
            l |= (long)this.readUnsignedByte() << 8;
            l |= (long)this.readUnsignedByte() << 16;
            l |= (long)this.readUnsignedByte() << 24;
            l |= (long)this.readUnsignedByte() << 32;
            l |= (long)this.readUnsignedByte() << 40;
            l |= (long)this.readUnsignedByte() << 48;
            d = Double.longBitsToDouble(l |= (long)this.readUnsignedByte() << 56);
        }
        return d;
    }

    public double flipDouble(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = this.flipLong(l);
        return Double.longBitsToDouble(l2);
    }
}

