/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import data.DataSource;
import data.DataSourceException;
import data.ExternalDataSource;
import data.VoxelOrderDataSource;
import imaging.EndianCorrectOutputStream;
import imaging.ImageHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import misc.LoggedException;
import numerics.RealMatrix;
import tools.BufferedInflaterInputStream;
import tools.EndianNeutralDataInputStream;

public final class MetaImageHeader
extends ImageHeader {
    private static Logger logger = Logger.getLogger("camino.imaging.MetaImageHeader");
    protected final ObjectType objectType = ObjectType.IMAGE;
    protected final int nDims = 3;
    protected final boolean binaryData = true;
    protected boolean compressedData = false;
    protected boolean intelByteOrder = false;
    protected RealMatrix transformation = RealMatrix.identity(3);
    protected double[] offset = new double[]{0.0, 0.0, 0.0};
    protected double[] rotationCentre = new double[]{0.0, 0.0, 0.0};
    protected AnatomicalOrientation anatomicalOrientation = AnatomicalOrientation.LPI;
    protected double[] spacing = new double[]{1.0, 1.0, 1.0};
    protected int[] dimSize = new int[]{1, 1, 1};
    protected int channels = 1;
    protected DataType dataType = DataType.DOUBLE;
    protected String headerFile = "";
    protected String dataFile = "LOCAL";
    protected String localDataFile = "";
    protected int dataByteOffset = 0;

    public MetaImageHeader() {
    }

    protected MetaImageHeader(MetaImageHeader metaImageHeader, String string) {
        this.compressedData = metaImageHeader.compressedData;
        this.intelByteOrder = metaImageHeader.intelByteOrder;
        this.transformation = (RealMatrix)metaImageHeader.transformation.clone();
        this.offset = new double[3];
        this.rotationCentre = new double[3];
        this.spacing = new double[3];
        this.dimSize = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.offset[i] = metaImageHeader.offset[i];
            this.rotationCentre[i] = metaImageHeader.rotationCentre[i];
            this.spacing[i] = metaImageHeader.spacing[i];
            this.dimSize[i] = metaImageHeader.dimSize[i];
        }
        this.anatomicalOrientation = metaImageHeader.anatomicalOrientation;
        this.channels = metaImageHeader.channels;
        this.dataType = metaImageHeader.dataType;
        this.headerFile = string + ".mhd";
        if (metaImageHeader.dataFile.equals("LOCAL")) {
            this.dataFile = "LOCAL";
            this.localDataFile = this.headerFile;
        } else {
            String string2 = "";
            String string3 = "";
            String string4 = "/";
            int n = string.lastIndexOf(string4);
            if (n > -1) {
                string2 = string.substring(n + 1);
                metaImageHeader.localDataFile = string + ".raw";
                this.dataFile = string2 + ".raw";
            } else {
                this.dataFile = string + ".raw";
                this.localDataFile = string + ".raw";
            }
        }
    }

    public void setDataDims(int[] nArray) {
        this.dimSize[0] = nArray[0];
        this.dimSize[1] = nArray[1];
        this.dimSize[2] = nArray[2];
    }

    public void setVoxelDims(double[] dArray) {
        this.spacing[0] = dArray[0];
        this.spacing[1] = dArray[1];
        this.spacing[2] = dArray[2];
    }

    public static MetaImageHeader readHeader(String string) throws IOException {
        Object object;
        if (!string.endsWith(".mha") && !string.endsWith(".mhd")) {
            object = new File(string + ".mha");
            if (((File)object).exists()) {
                string = string + ".mha";
            } else {
                object = new File(string + ".mhd");
                if (((File)object).exists()) {
                    string = string + ".mhd";
                } else {
                    throw new FileNotFoundException("Can't find file " + string + ".mha or " + string + ".mhd");
                }
            }
        }
        object = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 1024));
        MetaImageHeader metaImageHeader = MetaImageHeader.readHeader((DataInput)object);
        ((FilterInputStream)object).close();
        metaImageHeader.headerFile = string;
        if (metaImageHeader.dataFile.equals("LOCAL")) {
            metaImageHeader.localDataFile = string;
        } else {
            String string2 = "";
            String string3 = "/";
            int n = string.lastIndexOf(string3);
            if (n > -1) {
                string2 = string.substring(0, n + 1);
            }
            metaImageHeader.localDataFile = string2 + metaImageHeader.dataFile;
        }
        return metaImageHeader;
    }

    public static MetaImageHeader readHeader(DataInput dataInput) throws IOException {
        MetaImageHeader metaImageHeader = new MetaImageHeader();
        boolean bl = false;
        byte by = new String("\n").getBytes()[0];
        byte by2 = new String("\r").getBytes()[0];
        int n = 0;
        while (!bl) {
            String string;
            String[] stringArray;
            int n2;
            String string2 = "";
            String string3 = "";
            byte[] byArray = new byte[2048];
            int n3 = 0;
            do {
                n2 = dataInput.readByte();
                byArray[n3++] = n2;
            } while (n2 != by);
            n += n3;
            n2 = n3 - 1;
            if (byArray[n3 - 1] == by2) {
                --n2;
            }
            if ((stringArray = (string = new String(byArray, 0, n2, "US-ASCII")).trim().split("\\s*=\\s*")).length != 2) {
                throw new LoggedException("Header line\n" + string + "\nis not a valid Meta header " + " field. Meta fields are of the form \"Key = Value\"");
            }
            metaImageHeader.setHeaderValue(stringArray[0].trim(), stringArray[1].trim());
            if (!stringArray[0].equals("ElementDataFile")) continue;
            bl = true;
        }
        if (metaImageHeader.dataFile.equals("LOCAL")) {
            metaImageHeader.dataByteOffset = n;
        }
        return metaImageHeader;
    }

    public void setHeaderValue(String string, String string2) {
        if (string.equalsIgnoreCase("ObjectType")) {
            ObjectType objectType = ObjectType.getObjectType(string2);
            if (objectType != ObjectType.IMAGE) {
                throw new LoggedException("Only image type is supported");
            }
        } else if (string.equalsIgnoreCase("NDims")) {
            int n = Integer.parseInt(string2);
            if (n != 3) {
                throw new LoggedException("only 3D images are supported.");
            }
        } else if (string.equalsIgnoreCase("BinaryData")) {
            boolean bl = Boolean.parseBoolean(string2);
            if (!bl) {
                throw new LoggedException("ASCII data is not supported.");
            }
        } else if (string.equalsIgnoreCase("CompressedData")) {
            this.compressedData = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("BinaryDataByteOrderMSB")) {
            this.intelByteOrder = !Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("ElementByteOrderMSB")) {
            this.intelByteOrder = !Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("TransformMatrix")) {
            String[] stringArray = string2.split("\\s+");
            this.transformation = new RealMatrix(3, 3);
            for (int i = 0; i < 9; ++i) {
                this.transformation.entries[i / 3][i % 3] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("Offset")) {
            String[] stringArray = string2.split("\\s+");
            this.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.offset[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("Position")) {
            String[] stringArray = string2.split("\\s+");
            this.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.offset[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("Origin")) {
            String[] stringArray = string2.split("\\s+");
            this.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.offset[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("CenterOfRotation")) {
            String[] stringArray = string2.split("\\s+");
            this.rotationCentre = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.rotationCentre[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("AnatomicalOrientation")) {
            this.anatomicalOrientation = AnatomicalOrientation.getAnatomicalOrientation(string2);
        } else if (string.equalsIgnoreCase("ElementSpacing")) {
            String[] stringArray = string2.split("\\s+");
            this.spacing = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.spacing[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("DimSize")) {
            String[] stringArray = string2.split("\\s+");
            this.dimSize = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.dimSize[i] = Integer.parseInt(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("ElementNumberOfChannels")) {
            this.channels = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("ElementType")) {
            this.dataType = DataType.getDataType(string2);
        } else if (string.equalsIgnoreCase("ElementDataFile")) {
            this.dataFile = string2;
        } else {
            logger.warning("Unrecognized header field " + string + " ignored");
        }
    }

    public void writeHeader(String string) throws IOException {
        if (!string.endsWith(".mha") && !string.endsWith(".mhd")) {
            string = this.dataFile.equalsIgnoreCase("LOCAL") ? string + ".mhd" : string + ".mha";
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string), 1024));
        this.writeHeader(dataOutputStream);
        dataOutputStream.close();
    }

    public void writeHeader(OutputStream outputStream) throws IOException {
        int n = 0;
        byte[][] byArrayArray = new byte[][]{new String("ObjectType = " + (Object)((Object)this.objectType) + "\n").getBytes("US-ASCII"), new String("NDims = 3\n").getBytes("US-ASCII"), new String("BinaryData = " + MetaImageHeader.titleCaseBool(true) + "\n").getBytes("US-ASCII"), new String("CompressedData = " + MetaImageHeader.titleCaseBool(this.compressedData) + "\n").getBytes("US-ASCII"), new String("BinaryDataByteOrderMSB = " + MetaImageHeader.titleCaseBool(!this.intelByteOrder) + "\n").getBytes("US-ASCII"), new String("TransformMatrix = " + MetaImageHeader.flatMatrixString(this.transformation) + "\n").getBytes("US-ASCII"), new String("Offset = " + this.offset[0] + " " + this.offset[1] + " " + this.offset[2] + "\n").getBytes("US-ASCII"), new String("CenterOfRotation = " + this.rotationCentre[0] + " " + this.rotationCentre[1] + " " + this.rotationCentre[2] + "\n").getBytes("US-ASCII"), new String("AnatomicalOrientation = " + (Object)((Object)this.anatomicalOrientation) + "\n").getBytes("US-ASCII"), new String("ElementSpacing = " + this.spacing[0] + " " + this.spacing[1] + " " + this.spacing[2] + "\n").getBytes("US-ASCII"), new String("DimSize = " + this.dimSize[0] + " " + this.dimSize[1] + " " + this.dimSize[2] + "\n").getBytes("US-ASCII"), new String("ElementNumberOfChannels = " + this.channels + "\n").getBytes("US-ASCII"), new String("ElementType = " + (Object)((Object)this.dataType) + "\n").getBytes("US-ASCII"), new String("ElementDataFile = " + this.dataFile + "\n").getBytes("US-ASCII")};
        for (int i = 0; i < 14; ++i) {
            outputStream.write(byArrayArray[i]);
            n += byArrayArray[i].length;
        }
        if (this.dataFile.equals("LOCAL")) {
            this.dataByteOffset = n;
        }
    }

    private void writeImage(double[][][][] dArray) throws IOException {
        FilterOutputStream filterOutputStream;
        BufferedOutputStream bufferedOutputStream;
        FileOutputStream fileOutputStream = new FileOutputStream(this.headerFile);
        if (this.dataFile.equals("LOCAL")) {
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream, ExternalDataSource.FILEBUFFERSIZE);
            filterOutputStream = this.compressedData ? new ZipOutputStream(bufferedOutputStream) : bufferedOutputStream;
        } else {
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
            BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(new FileOutputStream(this.localDataFile), ExternalDataSource.FILEBUFFERSIZE);
            filterOutputStream = this.compressedData ? new ZipOutputStream(bufferedOutputStream2) : bufferedOutputStream2;
        }
        this.writeHeader(bufferedOutputStream);
        this.writeData(dArray, filterOutputStream);
        ((OutputStream)filterOutputStream).close();
        if (!this.dataFile.equals("LOCAL")) {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    private void writeData(double[][][][] dArray, OutputStream outputStream) throws IOException {
        int n = this.dimSize[0];
        int n2 = this.dimSize[1];
        int n3 = this.dimSize[2];
        EndianCorrectOutputStream endianCorrectOutputStream = new EndianCorrectOutputStream(outputStream, !this.intelByteOrder);
        switch (this.dataType) {
            case UCHAR: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            for (int i2 = 0; i2 < this.channels; ++i2) {
                                short s = (short)Math.round(dArray[k][j][i][i2]);
                                endianCorrectOutputStream.write(s & 0xFF);
                            }
                        }
                    }
                }
                break;
            }
            case CHAR: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            for (int i3 = 0; i3 < this.channels; ++i3) {
                                endianCorrectOutputStream.write((byte)Math.round(dArray[k][j][i][i3]));
                            }
                        }
                    }
                }
                break;
            }
            case SHORT: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            for (int i4 = 0; i4 < this.channels; ++i4) {
                                endianCorrectOutputStream.writeShortCorrect((short)Math.round(dArray[k][j][i][i4]));
                            }
                        }
                    }
                }
                break;
            }
            case INT: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            for (int i5 = 0; i5 < this.channels; ++i5) {
                                endianCorrectOutputStream.writeIntCorrect((int)Math.round(dArray[k][j][i][i5]));
                            }
                        }
                    }
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            for (int i6 = 0; i6 < this.channels; ++i6) {
                                endianCorrectOutputStream.writeLongCorrect(Math.round(dArray[k][j][i][i6]));
                            }
                        }
                    }
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            for (int i7 = 0; i7 < this.channels; ++i7) {
                                endianCorrectOutputStream.writeFloatCorrect((float)dArray[k][j][i][i7]);
                            }
                        }
                    }
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            for (int i8 = 0; i8 < this.channels; ++i8) {
                                endianCorrectOutputStream.writeDoubleCorrect(dArray[k][j][i][i8]);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IOException("Sorry, cannot yet write MetaIO datatype " + (Object)((Object)this.dataType));
            }
        }
    }

    public String caminoDataTypeString() {
        return this.dataType.getCaminoDataType();
    }

    private static String titleCaseBool(boolean bl) {
        if (bl) {
            return "True";
        }
        return "False";
    }

    private static String flatMatrixString(RealMatrix realMatrix) {
        String string = "";
        double[][] dArray = realMatrix.entries;
        for (int i = 0; i < realMatrix.rows(); ++i) {
            for (int j = 0; j < realMatrix.columns(); ++j) {
                string = string + dArray[i][j] + " ";
            }
        }
        return string.trim();
    }

    @Override
    public int xDataDim() {
        return this.dimSize[0];
    }

    @Override
    public int yDataDim() {
        return this.dimSize[1];
    }

    @Override
    public int zDataDim() {
        return this.dimSize[2];
    }

    @Override
    public int[] getDataDims() {
        return new int[]{this.dimSize[0], this.dimSize[1], this.dimSize[2]};
    }

    @Override
    public double xVoxelDim() {
        return this.spacing[0];
    }

    @Override
    public double yVoxelDim() {
        return this.spacing[1];
    }

    @Override
    public double zVoxelDim() {
        return this.spacing[2];
    }

    @Override
    public double[] getVoxelDims() {
        return new double[]{this.spacing[0], this.spacing[1], this.spacing[2]};
    }

    @Override
    public int components() {
        return this.channels > 0 ? this.channels : 1;
    }

    @Override
    public DataSource getImageDataSource() {
        Object object;
        if (this.dataFile.equals("LOCAL")) {
            try {
                object = MetaImageHeader.readHeader(this.headerFile);
                this.dataByteOffset = ((MetaImageHeader)object).dataByteOffset;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        if (this.compressedData) {
            logger.warning("Compressed Meta IO is untested, use with caution");
            try {
                object = new FileInputStream(this.localDataFile);
                int n = 0;
                while (n < this.dataByteOffset) {
                    ((FileInputStream)object).skip(this.dataByteOffset - n);
                }
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream((InputStream)object, ExternalDataSource.FILEBUFFERSIZE / 2));
                zipInputStream.getNextEntry();
                EndianNeutralDataInputStream endianNeutralDataInputStream = new EndianNeutralDataInputStream(new BufferedInflaterInputStream(zipInputStream, ExternalDataSource.FILEBUFFERSIZE / 2), this.intelByteOrder);
                return new VoxelOrderDataSource(endianNeutralDataInputStream, this.channels, this.caminoDataTypeString());
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        object = new VoxelOrderDataSource(this.localDataFile, this.channels, this.caminoDataTypeString(), this.intelByteOrder, this.dataByteOffset);
        return object;
    }

    @Override
    public double[][][][] readVolumeData() {
        int n = this.dimSize[0];
        int n2 = this.dimSize[1];
        int n3 = this.dimSize[2];
        double[][][][] dArray = new double[n][n2][n3][this.channels];
        try {
            DataSource dataSource = this.getImageDataSource();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        double[] dArray2 = dataSource.nextVoxel();
                        for (int i2 = 0; i2 < this.channels; ++i2) {
                            dArray[k][j][i][i2] = dArray2[i2];
                        }
                    }
                }
            }
        }
        catch (DataSourceException dataSourceException) {
            throw new LoggedException(dataSourceException);
        }
        return dArray;
    }

    @Override
    public RealMatrix getVoxelToPhysicalTransform() {
        logger.warning("Basing transformation on TransformMatrix and Offset only (ignoring CenterOfRotation)");
        RealMatrix realMatrix = new RealMatrix(4, 4);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                realMatrix.entries[i][j] = this.transformation.entries[i][j];
            }
        }
        realMatrix.entries[0][3] = this.offset[0];
        realMatrix.entries[1][3] = this.offset[1];
        realMatrix.entries[2][3] = this.offset[2];
        realMatrix.entries[3][3] = 1.0;
        return realMatrix;
    }

    @Override
    protected String getHeaderFilename() {
        return this.headerFile;
    }

    @Override
    protected String getDataFilename() {
        if (this.dataFile.equals("LOCAL")) {
            return this.localDataFile;
        }
        return this.dataFile;
    }

    @Override
    public ImageHeader writeScalarImage(double[][][] dArray, String string) {
        if (dArray.length != this.dimSize[0] || dArray[0].length != this.dimSize[1] || dArray[0][0].length != this.dimSize[2]) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.dimSize[0] + " " + this.dimSize[1] + " " + this.dimSize[2]);
        }
        MetaImageHeader metaImageHeader = new MetaImageHeader(this, string);
        metaImageHeader.setDataTypeToSigned();
        metaImageHeader.channels = 1;
        double[][][][] dArray2 = new double[this.dimSize[0]][this.dimSize[1]][this.dimSize[2]][1];
        for (int i = 0; i < this.dimSize[0]; ++i) {
            for (int j = 0; j < this.dimSize[1]; ++j) {
                for (int k = 0; k < this.dimSize[2]; ++k) {
                    dArray2[i][j][k][0] = dArray[i][j][k];
                }
            }
        }
        try {
            metaImageHeader.writeImage(dArray2);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException.getMessage());
        }
        return metaImageHeader;
    }

    @Override
    public ImageHeader writeVectorImage(double[][][][] dArray, String string) {
        if (dArray.length != this.dimSize[0] || dArray[0].length != this.dimSize[1] || dArray[0][0].length != this.dimSize[2]) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.dimSize[0] + " " + this.dimSize[1] + " " + this.dimSize[2]);
        }
        MetaImageHeader metaImageHeader = new MetaImageHeader(this, string);
        metaImageHeader.channels = dArray[0][0][0].length;
        try {
            metaImageHeader.writeImage(dArray);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException.getMessage());
        }
        return metaImageHeader;
    }

    @Override
    public ImageHeader writeRGB_Image(int[][][] nArray, int[][][] nArray2, int[][][] nArray3, String string) {
        if (nArray.length != this.dimSize[0] || nArray[0].length != this.dimSize[1] || nArray[0][0].length != this.dimSize[2]) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.dimSize[0] + " " + this.dimSize[1] + " " + this.dimSize[2]);
        }
        MetaImageHeader metaImageHeader = new MetaImageHeader(this, string);
        metaImageHeader.channels = 3;
        metaImageHeader.dataType = DataType.UCHAR;
        int n = this.dimSize[0];
        int n2 = this.dimSize[1];
        int n3 = this.dimSize[2];
        double[][][][] dArray = new double[n][n2][n3][metaImageHeader.channels];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    dArray[k][j][i][0] = nArray[k][j][i];
                    dArray[k][j][i][1] = nArray2[k][j][i];
                    dArray[k][j][i][2] = nArray3[k][j][i];
                }
            }
        }
        try {
            metaImageHeader.writeImage(dArray);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException.getMessage());
        }
        return metaImageHeader;
    }

    @Override
    public ImageHeader writeTensorImage(double[][][][] dArray, String string) {
        if (dArray.length != this.dimSize[0] || dArray[0].length != this.dimSize[1] || dArray[0][0].length != this.dimSize[2]) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.dimSize[0] + " " + this.dimSize[1] + " " + this.dimSize[2]);
        }
        MetaImageHeader metaImageHeader = new MetaImageHeader(this, string);
        metaImageHeader.channels = 6;
        metaImageHeader.setDataTypeToSigned();
        try {
            metaImageHeader.writeImage(dArray);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException.getMessage());
        }
        return metaImageHeader;
    }

    @Override
    public void setDataType(String string) {
        this.dataType = DataType.getDataType(string);
    }

    @Override
    public void setGzip(boolean bl) {
        this.compressedData = bl;
        if (bl) {
            logger.warning("MetaIO uses ZLIB compression instead of gzip");
        }
    }

    private void setDataTypeToSigned() {
        if (this.dataType == DataType.UCHAR) {
            this.dataType = DataType.CHAR;
        } else if (this.dataType == DataType.USHORT) {
            this.dataType = DataType.SHORT;
        } else if (this.dataType == DataType.UINT) {
            this.dataType = DataType.INT;
        }
    }

    public static enum AnatomicalOrientation {
        LAS,
        LAI,
        LPS,
        LPI,
        RAS,
        RAI,
        RPS,
        RPI;


        public static AnatomicalOrientation getAnatomicalOrientation(String string) {
            for (AnatomicalOrientation anatomicalOrientation : AnatomicalOrientation.values()) {
                if (!string.equals(anatomicalOrientation.name())) continue;
                return anatomicalOrientation;
            }
            throw new LoggedException("Unsupported Anatomical Orientation " + string);
        }
    }

    public static enum ObjectType {
        IMAGE("Image");

        private final String typeName;

        private ObjectType(String string2) {
            this.typeName = string2;
        }

        public String toString() {
            return this.typeName;
        }

        public static ObjectType getObjectType(String string) {
            for (ObjectType objectType : ObjectType.values()) {
                if (!string.equals(objectType.typeName)) continue;
                return objectType;
            }
            throw new LoggedException("Unsupported Meta object type: '" + string + "'");
        }
    }

    public static enum DataType {
        UCHAR("MET_UCHAR", "ubyte", 2),
        CHAR("MET_CHAR", "byte", 132),
        SHORT("MET_SHORT", "short", 4),
        USHORT("MET_USHORT", "ushort", 130),
        INT("MET_INT", "int", 8),
        UINT("MET_UINT", "uint", 136),
        FLOAT("MET_FLOAT", "float", 16),
        DOUBLE("MET_DOUBLE", "double", 64),
        LONG("MET_LONG", "long", 199);

        private final String typeName;
        private final String caminoTypeName;
        private final int index;

        private DataType(String string2, String string3, int n2) {
            this.typeName = string2;
            this.caminoTypeName = string3;
            this.index = n2;
        }

        public String toString() {
            return this.typeName;
        }

        public static DataType getDataType(String string) {
            for (DataType dataType : DataType.values()) {
                if (!string.equals(dataType.typeName) && !string.equals(dataType.caminoTypeName)) continue;
                return dataType;
            }
            throw new LoggedException("Unsupported Meta data type " + string);
        }

        public String getCaminoDataType() {
            return this.caminoTypeName;
        }
    }
}

