/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import data.DataSource;
import data.OutputManager;
import data.ScannerOrderScaledDataSource;
import data.VoxelOrderScaledDataSource;
import imaging.EndianCorrectInputStream;
import imaging.EndianCorrectOutputStream;
import imaging.ImageHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import misc.LoggedException;
import numerics.RealMatrix;
import tools.BufferedInflaterInputStream;
import tools.CL_Initializer;
import tools.EndianNeutralDataInputStream;

public final class Nifti1Dataset
extends ImageHeader {
    private static Logger logger = Logger.getLogger("camino.imaging.Nifti1Dataset");
    public static final String ANZ_HDR_EXT = ".hdr";
    public static final String ANZ_DAT_EXT = ".img";
    public static final String NI1_EXT = ".nii";
    public static final String GZIP_EXT = ".gz";
    public static final int ANZ_HDR_SIZE = 348;
    public static final long NII_HDR_SIZE = 352L;
    public static final int EXT_KEY_SIZE = 8;
    public static final String NII_MAGIC_STRING = "n+1";
    public static final String ANZ_MAGIC_STRING = "ni1";
    public static final short NIFTI_INTENT_NONE = 0;
    public static final short NIFTI_INTENT_CORREL = 2;
    public static final short NIFTI_INTENT_TTEST = 3;
    public static final short NIFTI_INTENT_FTEST = 4;
    public static final short NIFTI_INTENT_ZSCORE = 5;
    public static final short NIFTI_INTENT_CHISQ = 6;
    public static final short NIFTI_INTENT_BETA = 7;
    public static final short NIFTI_INTENT_BINOM = 8;
    public static final short NIFTI_INTENT_GAMMA = 9;
    public static final short NIFTI_INTENT_POISSON = 10;
    public static final short NIFTI_INTENT_NORMAL = 11;
    public static final short NIFTI_INTENT_FTEST_NONC = 12;
    public static final short NIFTI_INTENT_CHISQ_NONC = 13;
    public static final short NIFTI_INTENT_LOGISTIC = 14;
    public static final short NIFTI_INTENT_LAPLACE = 15;
    public static final short NIFTI_INTENT_UNIFORM = 16;
    public static final short NIFTI_INTENT_TTEST_NONC = 17;
    public static final short NIFTI_INTENT_WEIBULL = 18;
    public static final short NIFTI_INTENT_CHI = 19;
    public static final short NIFTI_INTENT_INVGAUSS = 20;
    public static final short NIFTI_INTENT_EXTVAL = 21;
    public static final short NIFTI_INTENT_PVAL = 22;
    public static final short NIFTI_INTENT_ESTIMATE = 1001;
    public static final short NIFTI_INTENT_LABEL = 1002;
    public static final short NIFTI_INTENT_NEURONAME = 1003;
    public static final short NIFTI_INTENT_GENMATRIX = 1004;
    public static final short NIFTI_INTENT_SYMMATRIX = 1005;
    public static final short NIFTI_INTENT_DISPVECT = 1006;
    public static final short NIFTI_INTENT_VECTOR = 1007;
    public static final short NIFTI_INTENT_POINTSET = 1008;
    public static final short NIFTI_INTENT_TRIANGLE = 1009;
    public static final short NIFTI_INTENT_QUATERNION = 1010;
    public static final short NIFTI_FIRST_STATCODE = 2;
    public static final short NIFTI_LAST_STATCODE = 22;
    public static final short DT_NONE = 0;
    public static final short DT_BINARY = 1;
    public static final short NIFTI_TYPE_UINT8 = 2;
    public static final short NIFTI_TYPE_INT16 = 4;
    public static final short NIFTI_TYPE_INT32 = 8;
    public static final short NIFTI_TYPE_FLOAT32 = 16;
    public static final short NIFTI_TYPE_COMPLEX64 = 32;
    public static final short NIFTI_TYPE_FLOAT64 = 64;
    public static final short NIFTI_TYPE_RGB24 = 128;
    public static final short DT_ALL = 255;
    public static final short NIFTI_TYPE_INT8 = 256;
    public static final short NIFTI_TYPE_UINT16 = 512;
    public static final short NIFTI_TYPE_UINT32 = 768;
    public static final short NIFTI_TYPE_INT64 = 1024;
    public static final short NIFTI_TYPE_UINT64 = 1280;
    public static final short NIFTI_TYPE_FLOAT128 = 1536;
    public static final short NIFTI_TYPE_COMPLEX128 = 1792;
    public static final short NIFTI_TYPE_RGBA32 = 2304;
    public static final short NIFTI_TYPE_COMPLEX256 = 2048;
    public static final short NIFTI_UNITS_UNKNOWN = 0;
    public static final short NIFTI_UNITS_METER = 1;
    public static final short NIFTI_UNITS_MM = 2;
    public static final short NIFTI_UNITS_MICRON = 3;
    public static final short NIFTI_UNITS_SEC = 8;
    public static final short NIFTI_UNITS_MSEC = 16;
    public static final short NIFTI_UNITS_USEC = 24;
    public static final short NIFTI_UNITS_HZ = 32;
    public static final short NIFTI_UNITS_PPM = 40;
    public static final short NIFTI_SLICE_SEQ_INC = 1;
    public static final short NIFTI_SLICE_SEQ_DEC = 2;
    public static final short NIFTI_SLICE_ALT_INC = 3;
    public static final short NIFTI_SLICE_ALT_DEC = 4;
    public static final short NIFTI_XFORM_UNKNOWN = 0;
    public static final short NIFTI_XFORM_SCANNER_ANAT = 1;
    public static final short NIFTI_XFORM_ALIGNED_ANAT = 2;
    public static final short NIFTI_XFORM_TALAIRACH = 3;
    public static final short NIFTI_XFORM_MNI_152 = 4;
    private String ds_hdrname;
    private String ds_datname;
    private boolean ds_is_nii;
    private boolean gzip;
    private boolean big_endian;
    private short XDIM;
    private short YDIM;
    private short ZDIM;
    private short TDIM;
    private short DIM5;
    private short DIM6;
    private short DIM7;
    private short freq_dim;
    private short phase_dim;
    private short slice_dim;
    private short xyz_unit_code;
    private short t_unit_code;
    private short qfac;
    private Vector<Object> extensions_list;
    private Vector<Object> extension_blobs;
    private int sizeof_hdr;
    private StringBuffer data_type_string;
    private StringBuffer db_name;
    private int extents;
    private short session_error;
    private StringBuffer regular;
    private StringBuffer dim_info;
    private short[] dim;
    private float[] intent;
    private short intent_code;
    private short datatype;
    private short bitpix;
    private short slice_start;
    private float[] pixdim;
    private float vox_offset;
    private float scl_slope;
    private float scl_inter;
    private short slice_end;
    private byte slice_code;
    private byte xyzt_units;
    private float cal_max;
    private float cal_min;
    private float slice_duration;
    private float toffset;
    private int glmax;
    private int glmin;
    private StringBuffer descrip;
    private StringBuffer aux_file;
    private short qform_code;
    private short sform_code;
    private float[] quatern;
    private float[] qoffset;
    private float[] srow_x;
    private float[] srow_y;
    private float[] srow_z;
    private StringBuffer intent_name;
    private StringBuffer magic;
    private byte[] extension;

    public Nifti1Dataset(String string) {
        this.setDefaults();
        this.setFilename(string);
        try {
            this.readHeader();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public Nifti1Dataset() {
        this.setDefaults();
    }

    public Nifti1Dataset(Nifti1Dataset nifti1Dataset, String string) {
        this.setDefaults();
        this.copyHeader(nifti1Dataset);
        this.setFilename(string, this.ds_is_nii, this.gzip);
    }

    private void readHeader() throws IOException, FileNotFoundException {
        EndianCorrectInputStream endianCorrectInputStream;
        DataInputStream dataInputStream;
        if (this.ds_hdrname.endsWith(GZIP_EXT)) {
            dataInputStream = new DataInputStream(new GZIPInputStream(new FileInputStream(this.ds_hdrname)));
            this.gzip = true;
        } else {
            dataInputStream = new DataInputStream(new FileInputStream(this.ds_hdrname));
            this.gzip = false;
        }
        try {
            int n;
            dataInputStream.skipBytes(40);
            short s = dataInputStream.readShort();
            dataInputStream.close();
            this.big_endian = s >= 1 && s <= 7;
            endianCorrectInputStream = this.gzip ? new EndianCorrectInputStream(new GZIPInputStream(new FileInputStream(this.ds_hdrname)), this.big_endian) : new EndianCorrectInputStream(this.ds_hdrname, this.big_endian);
            this.sizeof_hdr = endianCorrectInputStream.readIntCorrect();
            byte[] byArray = new byte[10];
            endianCorrectInputStream.readFully(byArray, 0, 10);
            this.data_type_string = new StringBuffer(new String(byArray));
            byArray = new byte[18];
            endianCorrectInputStream.readFully(byArray, 0, 18);
            this.db_name = new StringBuffer(new String(byArray));
            this.extents = endianCorrectInputStream.readIntCorrect();
            this.session_error = endianCorrectInputStream.readShortCorrect();
            this.regular = new StringBuffer();
            this.regular.append((char)endianCorrectInputStream.readUnsignedByte());
            this.dim_info = new StringBuffer();
            this.dim_info.append((char)endianCorrectInputStream.readUnsignedByte());
            short[] sArray = this.unpackDimInfo(this.dim_info.charAt(0));
            this.freq_dim = sArray[0];
            this.phase_dim = sArray[1];
            this.slice_dim = sArray[2];
            for (n = 0; n < 8; ++n) {
                this.dim[n] = endianCorrectInputStream.readShortCorrect();
            }
            if (this.dim[0] > 0) {
                this.XDIM = this.dim[1];
            }
            if (this.dim[0] > 1) {
                this.YDIM = this.dim[2];
            }
            if (this.dim[0] > 2) {
                this.ZDIM = this.dim[3];
            }
            if (this.dim[0] > 3) {
                this.TDIM = this.dim[4];
            }
            for (n = 0; n < 3; ++n) {
                this.intent[n] = endianCorrectInputStream.readFloatCorrect();
            }
            this.intent_code = endianCorrectInputStream.readShortCorrect();
            this.datatype = endianCorrectInputStream.readShortCorrect();
            this.bitpix = endianCorrectInputStream.readShortCorrect();
            this.slice_start = endianCorrectInputStream.readShortCorrect();
            for (n = 0; n < 8; ++n) {
                this.pixdim[n] = endianCorrectInputStream.readFloatCorrect();
            }
            this.qfac = (short)Math.floor(this.pixdim[0]);
            this.vox_offset = endianCorrectInputStream.readFloatCorrect();
            this.scl_slope = endianCorrectInputStream.readFloatCorrect();
            this.scl_inter = endianCorrectInputStream.readFloatCorrect();
            this.slice_end = endianCorrectInputStream.readShortCorrect();
            this.slice_code = (byte)endianCorrectInputStream.readUnsignedByte();
            this.xyzt_units = (byte)endianCorrectInputStream.readUnsignedByte();
            sArray = this.unpackUnits(this.xyzt_units);
            this.xyz_unit_code = sArray[0];
            this.t_unit_code = sArray[1];
            this.cal_max = endianCorrectInputStream.readFloatCorrect();
            this.cal_min = endianCorrectInputStream.readFloatCorrect();
            this.slice_duration = endianCorrectInputStream.readFloatCorrect();
            this.toffset = endianCorrectInputStream.readFloatCorrect();
            this.glmax = endianCorrectInputStream.readIntCorrect();
            this.glmin = endianCorrectInputStream.readIntCorrect();
            byArray = new byte[80];
            endianCorrectInputStream.readFully(byArray, 0, 80);
            this.descrip = new StringBuffer(new String(byArray));
            byArray = new byte[24];
            endianCorrectInputStream.readFully(byArray, 0, 24);
            this.aux_file = new StringBuffer(new String(byArray));
            this.qform_code = endianCorrectInputStream.readShortCorrect();
            this.sform_code = endianCorrectInputStream.readShortCorrect();
            for (n = 0; n < 3; ++n) {
                this.quatern[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 3; ++n) {
                this.qoffset[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 4; ++n) {
                this.srow_x[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 4; ++n) {
                this.srow_y[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 4; ++n) {
                this.srow_z[n] = endianCorrectInputStream.readFloatCorrect();
            }
            byArray = new byte[16];
            endianCorrectInputStream.readFully(byArray, 0, 16);
            this.intent_name = new StringBuffer(new String(byArray));
            byArray = new byte[4];
            endianCorrectInputStream.readFully(byArray, 0, 4);
            this.magic = new StringBuffer(new String(byArray));
        }
        catch (IOException iOException) {
            throw new IOException("Error: unable to read header file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
        if (this.ds_is_nii) {
            this.readNiiExt(endianCorrectInputStream);
        } else {
            this.readNp1Ext(endianCorrectInputStream);
        }
        endianCorrectInputStream.close();
    }

    private void copyHeader(Nifti1Dataset nifti1Dataset) {
        int n;
        this.ds_hdrname = new String(nifti1Dataset.ds_hdrname);
        this.ds_datname = new String(nifti1Dataset.ds_datname);
        this.ds_is_nii = nifti1Dataset.ds_is_nii;
        this.big_endian = nifti1Dataset.big_endian;
        this.sizeof_hdr = nifti1Dataset.sizeof_hdr;
        this.data_type_string = new StringBuffer(nifti1Dataset.data_type_string.toString());
        this.db_name = new StringBuffer(nifti1Dataset.db_name.toString());
        this.extents = nifti1Dataset.extents;
        this.session_error = nifti1Dataset.session_error;
        this.regular = new StringBuffer(nifti1Dataset.regular.toString());
        this.dim_info = new StringBuffer(nifti1Dataset.dim_info.toString());
        this.freq_dim = nifti1Dataset.freq_dim;
        this.phase_dim = nifti1Dataset.phase_dim;
        this.slice_dim = nifti1Dataset.slice_dim;
        for (n = 0; n < 8; ++n) {
            this.dim[n] = nifti1Dataset.dim[n];
        }
        this.XDIM = nifti1Dataset.XDIM;
        this.YDIM = nifti1Dataset.YDIM;
        this.ZDIM = nifti1Dataset.ZDIM;
        this.TDIM = nifti1Dataset.TDIM;
        this.DIM5 = nifti1Dataset.DIM5;
        this.DIM6 = nifti1Dataset.DIM6;
        this.DIM7 = nifti1Dataset.DIM7;
        for (n = 0; n < 3; ++n) {
            this.intent[n] = nifti1Dataset.intent[n];
        }
        this.intent_code = nifti1Dataset.intent_code;
        this.datatype = nifti1Dataset.datatype;
        this.bitpix = nifti1Dataset.bitpix;
        this.slice_start = nifti1Dataset.slice_start;
        this.qfac = 1;
        for (n = 0; n < 8; ++n) {
            this.pixdim[n] = nifti1Dataset.pixdim[n];
        }
        this.qfac = (short)Math.floor(this.pixdim[0]);
        this.vox_offset = nifti1Dataset.vox_offset;
        this.scl_slope = nifti1Dataset.scl_slope;
        this.scl_inter = nifti1Dataset.scl_inter;
        this.slice_end = nifti1Dataset.slice_end;
        this.slice_code = nifti1Dataset.slice_code;
        this.xyzt_units = nifti1Dataset.xyzt_units;
        this.xyz_unit_code = nifti1Dataset.xyz_unit_code;
        this.t_unit_code = nifti1Dataset.t_unit_code;
        this.cal_max = nifti1Dataset.cal_max;
        this.cal_min = nifti1Dataset.cal_min;
        this.slice_duration = nifti1Dataset.slice_duration;
        this.toffset = nifti1Dataset.toffset;
        this.glmax = nifti1Dataset.glmax;
        this.glmin = nifti1Dataset.glmin;
        this.descrip = new StringBuffer(nifti1Dataset.descrip.toString());
        this.aux_file = new StringBuffer(nifti1Dataset.aux_file.toString());
        this.qform_code = nifti1Dataset.qform_code;
        this.sform_code = nifti1Dataset.sform_code;
        for (n = 0; n < 3; ++n) {
            this.quatern[n] = nifti1Dataset.quatern[n];
            this.qoffset[n] = nifti1Dataset.qoffset[n];
        }
        for (n = 0; n < 4; ++n) {
            this.srow_x[n] = nifti1Dataset.srow_x[n];
            this.srow_y[n] = nifti1Dataset.srow_y[n];
            this.srow_z[n] = nifti1Dataset.srow_z[n];
        }
        this.intent_name = new StringBuffer(nifti1Dataset.intent_name.toString());
        this.magic = new StringBuffer(nifti1Dataset.magic.toString());
        for (n = 0; n < 4; ++n) {
            this.extension[n] = 0;
        }
        this.gzip = nifti1Dataset.gzip;
    }

    private void readNiiExt(EndianCorrectInputStream endianCorrectInputStream) throws IOException {
        byte[] byArray = new byte[4];
        try {
            int n = endianCorrectInputStream.read(byArray);
            if (n < 4) {
                throw new IOException("Error: i/o error reading extension bytes on header file " + this.ds_hdrname);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Error: i/o error reading extension bytes on header file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
        int[] nArray = new int[2];
        if (byArray[0] == 0) {
            return;
        }
        int n = 352;
        nArray[0] = 0;
        nArray[1] = 0;
        while (n < (int)this.vox_offset) {
            try {
                nArray = new int[]{endianCorrectInputStream.readIntCorrect(), endianCorrectInputStream.readIntCorrect()};
                byte[] byArray2 = new byte[nArray[0] - 8];
                endianCorrectInputStream.readFully(byArray2, 0, nArray[0] - 8);
                this.extension_blobs.add(byArray2);
            }
            catch (IOException iOException) {
                this.printHeader();
                throw new EOFException("Error: i/o error reading extension data for extension " + (this.extensions_list.size() + 1) + " on header file " + this.ds_hdrname + ": " + iOException.getMessage());
            }
            this.extensions_list.add(nArray);
            if ((n += nArray[0]) <= (int)this.vox_offset) continue;
            this.printHeader();
            throw new IOException("Error: Data  for extension " + this.extensions_list.size() + " on header file " + this.ds_hdrname + " appears to overrun start of image data.");
        }
    }

    private void readNp1Ext(EndianCorrectInputStream endianCorrectInputStream) throws IOException, EOFException {
        try {
            endianCorrectInputStream.readFully(this.extension, 0, 4);
        }
        catch (EOFException eOFException) {
            return;
        }
        catch (IOException iOException) {
            throw new IOException("Error: i/o error reading extension bytes on header file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
        int[] nArray = new int[2];
        if (this.extension[0] != 0) {
            nArray[0] = 0;
            nArray[1] = 0;
            while (true) {
                try {
                    nArray = new int[]{endianCorrectInputStream.readIntCorrect(), endianCorrectInputStream.readIntCorrect()};
                    byte[] byArray = new byte[nArray[0] - 8];
                    endianCorrectInputStream.readFully(byArray, 0, nArray[0] - 8);
                    this.extension_blobs.add(byArray);
                }
                catch (EOFException eOFException) {
                    return;
                }
                catch (IOException iOException) {
                    throw new EOFException("Error: i/o error reading extension data for extension " + (this.extensions_list.size() + 1) + " on header file " + this.ds_hdrname + ": " + iOException.getMessage());
                }
                this.extensions_list.add(nArray);
            }
        }
    }

    public int[][] getExtensionsList() {
        int[] nArray = new int[2];
        int n = this.extensions_list.size();
        int[][] nArray2 = new int[n][2];
        for (int i = 0; i < n; ++i) {
            nArray = (int[])this.extensions_list.get(i);
            nArray2[i][0] = nArray[0];
            nArray2[i][1] = nArray[1];
        }
        return nArray2;
    }

    public void removeExtension(int n) {
        int[] nArray = new int[2];
        int n2 = this.extensions_list.size();
        if (n >= n2) {
            System.out.println("\nERROR: could not remove extension " + n + 1 + " from " + this.ds_hdrname + ". It only has " + n2 + " extensions.");
            return;
        }
        nArray = (int[])this.extensions_list.get(n);
        this.extensions_list.remove(n);
        this.extension_blobs.remove(n);
        if (this.ds_is_nii) {
            this.vox_offset -= (float)nArray[0];
        }
    }

    public void addExtension(int n, String string) throws IOException {
        int[] nArray = new int[2];
        File file = new File(string);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Error: maximum extension size is 2147483647bytes. " + string + " is " + l + " bytes.");
        }
        int n2 = (int)l;
        int n3 = (n2 + 8) % 16;
        if (n3 != 0) {
            n3 = 16 - n3;
        }
        byte[] byArray = new byte[n2 + n3];
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            dataInputStream.readFully(byArray, 0, n2);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("Error reading extension data for " + this.ds_hdrname + " from file " + string + ". :" + iOException.getMessage());
        }
        for (int i = n2; i < n2 + n3; ++i) {
            byArray[i] = 0;
        }
        nArray[0] = n2 + n3 + 8;
        nArray[1] = n;
        this.extensions_list.add(nArray);
        this.extension_blobs.add(byArray);
        this.extension[0] = 1;
        if (this.ds_is_nii) {
            this.vox_offset += (float)nArray[0];
        }
    }

    public void writeHeader() throws IOException {
        byte[] byArray = this.headerToBytes();
        FileOutputStream fileOutputStream = new FileOutputStream(this.ds_hdrname);
        FilterOutputStream filterOutputStream = this.gzip ? new GZIPOutputStream((OutputStream)fileOutputStream, 1024) : new BufferedOutputStream(fileOutputStream, 1024);
        ((OutputStream)filterOutputStream).write(byArray);
        ((OutputStream)filterOutputStream).close();
    }

    private byte[] headerToBytes() throws IOException {
        int n;
        int n2 = 348;
        if (this.ds_is_nii || this.extension[0] != 0) {
            n2 += 4;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 + 8);
        EndianCorrectOutputStream endianCorrectOutputStream = new EndianCorrectOutputStream(byteArrayOutputStream, this.big_endian);
        endianCorrectOutputStream.writeIntCorrect(this.sizeof_hdr);
        if (this.data_type_string.length() >= 10) {
            endianCorrectOutputStream.writeBytes(this.data_type_string.substring(0, 10));
        } else {
            endianCorrectOutputStream.writeBytes(this.data_type_string.toString());
            for (n = 0; n < 10 - this.data_type_string.length(); ++n) {
                endianCorrectOutputStream.writeByte(0);
            }
        }
        if (this.db_name.length() >= 18) {
            endianCorrectOutputStream.writeBytes(this.db_name.substring(0, 18));
        } else {
            endianCorrectOutputStream.writeBytes(this.db_name.toString());
            for (n = 0; n < 18 - this.db_name.length(); ++n) {
                endianCorrectOutputStream.writeByte(0);
            }
        }
        endianCorrectOutputStream.writeIntCorrect(this.extents);
        endianCorrectOutputStream.writeShortCorrect(this.session_error);
        endianCorrectOutputStream.writeByte(this.regular.charAt(0));
        byte by = this.packDimInfo(this.freq_dim, this.phase_dim, this.slice_dim);
        endianCorrectOutputStream.writeByte(by);
        for (n = 0; n < 8; ++n) {
            endianCorrectOutputStream.writeShortCorrect(this.dim[n]);
        }
        for (n = 0; n < 3; ++n) {
            endianCorrectOutputStream.writeFloatCorrect(this.intent[n]);
        }
        endianCorrectOutputStream.writeShortCorrect(this.intent_code);
        endianCorrectOutputStream.writeShortCorrect(this.datatype);
        endianCorrectOutputStream.writeShortCorrect(this.bitpix);
        endianCorrectOutputStream.writeShortCorrect(this.slice_start);
        for (n = 0; n < 8; ++n) {
            endianCorrectOutputStream.writeFloatCorrect(this.pixdim[n]);
        }
        endianCorrectOutputStream.writeFloatCorrect(this.vox_offset);
        endianCorrectOutputStream.writeFloatCorrect(this.scl_slope);
        endianCorrectOutputStream.writeFloatCorrect(this.scl_inter);
        endianCorrectOutputStream.writeShortCorrect(this.slice_end);
        endianCorrectOutputStream.writeByte(this.slice_code);
        endianCorrectOutputStream.writeByte(this.packUnits(this.xyz_unit_code, this.t_unit_code));
        endianCorrectOutputStream.writeFloatCorrect(this.cal_max);
        endianCorrectOutputStream.writeFloatCorrect(this.cal_min);
        endianCorrectOutputStream.writeFloatCorrect(this.slice_duration);
        endianCorrectOutputStream.writeFloatCorrect(this.toffset);
        endianCorrectOutputStream.writeIntCorrect(this.glmax);
        endianCorrectOutputStream.writeIntCorrect(this.glmin);
        endianCorrectOutputStream.write(this.setStringSize(this.descrip, 80), 0, 80);
        endianCorrectOutputStream.write(this.setStringSize(this.aux_file, 24), 0, 24);
        endianCorrectOutputStream.writeShortCorrect(this.qform_code);
        endianCorrectOutputStream.writeShortCorrect(this.sform_code);
        for (n = 0; n < 3; ++n) {
            endianCorrectOutputStream.writeFloatCorrect(this.quatern[n]);
        }
        for (n = 0; n < 3; ++n) {
            endianCorrectOutputStream.writeFloatCorrect(this.qoffset[n]);
        }
        for (n = 0; n < 4; ++n) {
            endianCorrectOutputStream.writeFloatCorrect(this.srow_x[n]);
        }
        for (n = 0; n < 4; ++n) {
            endianCorrectOutputStream.writeFloatCorrect(this.srow_y[n]);
        }
        for (n = 0; n < 4; ++n) {
            endianCorrectOutputStream.writeFloatCorrect(this.srow_z[n]);
        }
        endianCorrectOutputStream.write(this.setStringSize(this.intent_name, 16), 0, 16);
        endianCorrectOutputStream.write(this.setStringSize(this.magic, 4), 0, 4);
        if (this.ds_is_nii || this.extension[0] != 0) {
            for (n = 0; n < 4; ++n) {
                endianCorrectOutputStream.writeByte(this.extension[n]);
            }
        }
        if (this.extension[0] != 0) {
            endianCorrectOutputStream = new EndianCorrectOutputStream(byteArrayOutputStream, this.big_endian);
            int[][] nArray = this.getExtensionsList();
            int n3 = nArray.length;
            for (n = 0; n < n3; ++n) {
                endianCorrectOutputStream.writeIntCorrect(nArray[n][0]);
                endianCorrectOutputStream.writeIntCorrect(nArray[n][1]);
                byte[] byArray = (byte[])this.extension_blobs.get(n);
                endianCorrectOutputStream.write(byArray, 0, nArray[n][0] - 8);
            }
        }
        endianCorrectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void printHeader() {
        System.out.print(this.toString());
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append("Dataset header file:\t\t\t\t" + this.ds_hdrname + "\n");
        stringBuffer.append("Dataset data file:\t\t\t\t" + this.ds_datname + "\n");
        stringBuffer.append("Size of header:\t\t\t\t\t" + this.sizeof_hdr + "\n");
        stringBuffer.append("File offset to data blob:\t\t\t" + this.vox_offset + "\n");
        stringBuffer.append("Endianness:\t\t\t\t\t");
        if (this.big_endian) {
            stringBuffer.append("big\n");
        } else {
            stringBuffer.append("little\n");
        }
        stringBuffer.append("Magic filetype string:\t\t\t\t" + this.magic + "\n");
        stringBuffer.append("Datatype:\t\t\t\t\t" + this.datatype + " (" + this.decodeDatatype(this.datatype) + ")\n");
        stringBuffer.append("Bits per voxel:\t\t\t\t\t" + this.bitpix + "\n");
        stringBuffer.append("Scaling slope and intercept:\t\t\t" + this.scl_slope + " " + this.scl_inter + "\n");
        stringBuffer.append("Dataset dimensions (Count, X,Y,Z,T...):\t\t");
        for (n = 0; n <= this.dim[0]; ++n) {
            stringBuffer.append(this.dim[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Grid spacings (X,Y,Z,T,...):\t\t\t");
        for (n = 1; n <= this.dim[0]; ++n) {
            stringBuffer.append(this.pixdim[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("XYZ  units:\t\t\t\t\t" + this.xyz_unit_code + " (" + this.decodeUnits(this.xyz_unit_code) + ")\n");
        stringBuffer.append("T units:\t\t\t\t\t" + this.t_unit_code + " (" + this.decodeUnits(this.t_unit_code) + ")\n");
        stringBuffer.append("T offset:\t\t\t\t\t" + this.toffset + "\n");
        stringBuffer.append("Intent parameters:\t\t\t\t");
        for (n = 0; n < 3; ++n) {
            stringBuffer.append(this.intent[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Intent code:\t\t\t\t\t" + this.intent_code + " (" + this.decodeIntent(this.intent_code) + ")\n");
        stringBuffer.append("Cal. (display) max/min:\t\t\t\t" + this.cal_max + " " + this.cal_min + "\n");
        stringBuffer.append("Slice timing code:\t\t\t\t" + this.slice_code + " (" + this.decodeSliceOrder(this.slice_code) + ")\n");
        stringBuffer.append("MRI slice ordering (freq, phase, slice index):\t" + this.freq_dim + " " + this.phase_dim + " " + this.slice_dim + "\n");
        stringBuffer.append("Start/end slice:\t\t\t\t" + this.slice_start + " " + this.slice_end + "\n");
        stringBuffer.append("Slice duration:\t\t\t\t\t" + this.slice_duration + "\n");
        stringBuffer.append("Q factor:\t\t\t\t\t" + this.qfac + "\n");
        stringBuffer.append("Qform transform code:\t\t\t\t" + this.qform_code + " (" + this.decodeXform(this.qform_code) + ")\n");
        stringBuffer.append("Quaternion b,c,d params:\t\t\t" + this.quatern[0] + " " + this.quatern[1] + " " + this.quatern[2] + "\n");
        stringBuffer.append("Quaternion x,y,z shifts:\t\t\t" + this.qoffset[0] + " " + this.qoffset[1] + " " + this.qoffset[2] + "\n");
        stringBuffer.append("Affine transform code:\t\t\t\t" + this.sform_code + " (" + this.decodeXform(this.sform_code) + ")\n");
        stringBuffer.append("1st row affine transform:\t\t\t");
        for (n = 0; n < 4; ++n) {
            stringBuffer.append(this.srow_x[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("2nd row affine transform:\t\t\t");
        for (n = 0; n < 4; ++n) {
            stringBuffer.append(this.srow_y[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("3rd row affine transform:\t\t\t");
        for (n = 0; n < 4; ++n) {
            stringBuffer.append(this.srow_z[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Description:\t\t\t\t\t" + this.descrip + "\n");
        stringBuffer.append("Intent name:\t\t\t\t\t" + this.intent_name + "\n");
        stringBuffer.append("Auxiliary file:\t\t\t\t\t" + this.aux_file + "\n");
        stringBuffer.append("Extension byte 1:\t\t\t\t\t" + this.extension[0] + "\n");
        stringBuffer.append("\n\nUnused Fields\n");
        stringBuffer.append("----------------------------------------------------------------------\n");
        stringBuffer.append("Data type string:\t\t\t" + this.data_type_string + "\n");
        stringBuffer.append("db_name:\t\t\t\t\t" + this.db_name + "\n");
        stringBuffer.append("extents:\t\t\t\t\t" + this.extents + "\n");
        stringBuffer.append("session_error:\t\t\t\t\t" + this.session_error + "\n");
        stringBuffer.append("regular:\t\t\t\t\t" + this.regular + "\n");
        stringBuffer.append("glmax/glmin:\t\t\t\t\t" + this.glmax + " " + this.glmin + "\n");
        stringBuffer.append("Extension bytes 2-4:\t\t\t\t" + this.extension[1] + " " + this.extension[2] + " " + this.extension[3] + "\n");
        if (this.extension[0] != 0) {
            int[][] nArray = this.getExtensionsList();
            int n2 = nArray.length;
            stringBuffer.append("\n\nExtensions\n");
            stringBuffer.append("----------------------------------------------------------------------\n");
            stringBuffer.append("#\tCode\tSize\n");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(n + 1 + "\t" + nArray[n][1] + "\t" + nArray[n][0] + "\n");
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    public void printDoubleTmcrs(double[] dArray) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setGroupingUsed(false);
        for (short s = 0; s < this.TDIM; s = (short)(s + 1)) {
            System.out.println(numberFormat.format(dArray[s]));
        }
    }

    public void setFilename(String string) {
        if (string.endsWith(NI1_EXT) || string.endsWith(".nii.gz")) {
            this.setToNii();
            this.ds_hdrname = string;
            this.ds_datname = string;
            if (string.endsWith(".nii.gz")) {
                this.gzip = true;
            }
        }
        if (string.endsWith(ANZ_HDR_EXT)) {
            this.setToNi1();
            this.ds_hdrname = string;
            String string2 = string.substring(0, string.length() - 4);
            File file = new File(string2 + ANZ_DAT_EXT);
            if (file.exists()) {
                this.ds_datname = string2 + ANZ_DAT_EXT;
            } else {
                file = new File(string2 + ".img.gz");
                if (file.exists()) {
                    this.ds_datname = string2 + ".img.gz";
                    this.gzip = true;
                }
            }
        }
    }

    public void setFilename(String string, boolean bl, boolean bl2) {
        String string2 = null;
        String string3 = null;
        this.gzip = bl2;
        if (bl) {
            this.setToNii();
            string2 = this.gzip ? ".nii.gz" : NI1_EXT;
            string3 = string2;
        } else {
            this.setToNi1();
            string2 = ANZ_HDR_EXT;
            string3 = this.gzip ? ".img.gz" : ANZ_DAT_EXT;
        }
        this.ds_hdrname = string + string2;
        this.ds_datname = string + string3;
    }

    protected void setScale(double d, double d2) {
        this.scl_slope = d == 0.0 ? 1.0f : (float)d;
        this.scl_inter = (float)d2;
    }

    private void setToNii() {
        this.ds_is_nii = true;
        this.magic = new StringBuffer(NII_MAGIC_STRING);
        this.vox_offset = 352.0f;
        if (this.extension[0] != 0) {
            int[][] nArray = this.getExtensionsList();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                this.vox_offset += (float)nArray[i][0];
            }
        }
    }

    private void setToNi1() {
        this.ds_is_nii = false;
        this.magic = new StringBuffer(ANZ_MAGIC_STRING);
        this.vox_offset = 0.0f;
    }

    public void setDims(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        this.dim[0] = s;
        this.dim[1] = s2;
        this.dim[2] = s3;
        this.dim[3] = s4;
        this.dim[4] = s5;
        this.dim[5] = s6;
        this.dim[6] = s7;
        this.dim[7] = s8;
        this.XDIM = s2;
        this.YDIM = s3;
        this.ZDIM = s4;
        this.TDIM = s5;
    }

    public void setDims(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.setDims((short)n, (short)n2, (short)n3, (short)n4, (short)n5, (short)n6, (short)n7, (short)n8);
    }

    public void setDims(short[] sArray) {
        this.setDims(sArray[0], sArray[1], sArray[2], sArray[3], sArray[4], sArray[5], sArray[6], sArray[7]);
    }

    public void setPixDims(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.pixdim[0] = f < 0.0f ? -1.0f : 1.0f;
        this.pixdim[1] = f2;
        this.pixdim[2] = f3;
        this.pixdim[3] = f4;
        this.pixdim[4] = f5;
        this.pixdim[5] = f6;
        this.pixdim[6] = f7;
        this.pixdim[7] = f8;
    }

    public void setPixDims(float[] fArray) {
        this.setPixDims(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
    }

    public void setPixDims(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.setPixDims((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, (float)d8);
    }

    private void setDataType(short s) {
        this.datatype = s;
        this.bitpix = (short)(this.bytesPerVoxel(s) * 8);
    }

    public short getDatatype() {
        return this.datatype;
    }

    public short getBitpix() {
        return this.bitpix;
    }

    public String decodeIntent(short s) {
        switch (s) {
            case 0: {
                return "NIFTI_INTENT_NONE";
            }
            case 2: {
                return "NIFTI_INTENT_CORREL";
            }
            case 3: {
                return "NIFTI_INTENT_TTEST";
            }
            case 4: {
                return "NIFTI_INTENT_FTEST";
            }
            case 5: {
                return "NIFTI_INTENT_ZSCORE";
            }
            case 6: {
                return "NIFTI_INTENT_CHISQ";
            }
            case 7: {
                return "NIFTI_INTENT_BETA";
            }
            case 8: {
                return "NIFTI_INTENT_BINOM";
            }
            case 9: {
                return "NIFTI_INTENT_GAMMA";
            }
            case 10: {
                return "NIFTI_INTENT_POISSON";
            }
            case 11: {
                return "NIFTI_INTENT_NORMAL";
            }
            case 12: {
                return "NIFTI_INTENT_FTEST_NONC";
            }
            case 13: {
                return "NIFTI_INTENT_CHISQ_NONC";
            }
            case 14: {
                return "NIFTI_INTENT_LOGISTIC";
            }
            case 15: {
                return "NIFTI_INTENT_LAPLACE";
            }
            case 16: {
                return "NIFTI_INTENT_UNIFORM";
            }
            case 17: {
                return "NIFTI_INTENT_TTEST_NONC";
            }
            case 18: {
                return "NIFTI_INTENT_WEIBULL";
            }
            case 19: {
                return "NIFTI_INTENT_CHI";
            }
            case 20: {
                return "NIFTI_INTENT_INVGAUSS";
            }
            case 21: {
                return "NIFTI_INTENT_EXTVAL";
            }
            case 22: {
                return "NIFTI_INTENT_PVAL";
            }
            case 1001: {
                return "NIFTI_INTENT_ESTIMATE";
            }
            case 1002: {
                return "NIFTI_INTENT_LABEL";
            }
            case 1003: {
                return "NIFTI_INTENT_NEURONAME";
            }
            case 1004: {
                return "NIFTI_INTENT_GENMATRIX";
            }
            case 1005: {
                return "NIFTI_INTENT_SYMMATRIX";
            }
            case 1006: {
                return "NIFTI_INTENT_DISPVECT";
            }
            case 1007: {
                return "NIFTI_INTENT_VECTOR";
            }
            case 1008: {
                return "NIFTI_INTENT_POINTSET";
            }
            case 1009: {
                return "NIFTI_INTENT_TRIANGLE";
            }
            case 1010: {
                return "NIFTI_INTENT_QUATERNION";
            }
        }
        return "INVALID_NIFTI_INTENT_CODE";
    }

    public String decodeDatatype(short s) {
        switch (s) {
            case 0: {
                return "DT_NONE";
            }
            case 1: {
                return "DT_BINARY";
            }
            case 2: {
                return "NIFTI_TYPE_UINT8";
            }
            case 4: {
                return "NIFTI_TYPE_INT16";
            }
            case 8: {
                return "NIFTI_TYPE_INT32";
            }
            case 16: {
                return "NIFTI_TYPE_FLOAT32";
            }
            case 32: {
                return "NIFTI_TYPE_COMPLEX64";
            }
            case 64: {
                return "NIFTI_TYPE_FLOAT64";
            }
            case 128: {
                return "NIFTI_TYPE_RGB24";
            }
            case 255: {
                return "DT_ALL";
            }
            case 256: {
                return "NIFTI_TYPE_INT8";
            }
            case 512: {
                return "NIFTI_TYPE_UINT16";
            }
            case 768: {
                return "NIFTI_TYPE_UINT32";
            }
            case 1024: {
                return "NIFTI_TYPE_INT64";
            }
            case 1280: {
                return "NIFTI_TYPE_UINT64";
            }
            case 1536: {
                return "NIFTI_TYPE_FLOAT128";
            }
            case 1792: {
                return "NIFTI_TYPE_COMPLEX128";
            }
            case 2048: {
                return "NIFTI_TYPE_COMPLEX256";
            }
        }
        return "INVALID_NIFTI_DATATYPE_CODE";
    }

    public short bytesPerVoxel(short s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 8;
            }
            case 64: {
                return 8;
            }
            case 128: {
                return 3;
            }
            case 2304: {
                return 4;
            }
            case 255: {
                return 0;
            }
            case 256: {
                return 1;
            }
            case 512: {
                return 2;
            }
            case 768: {
                return 4;
            }
            case 1024: {
                return 8;
            }
            case 1280: {
                return 8;
            }
            case 1536: {
                return 16;
            }
            case 1792: {
                return 16;
            }
            case 2048: {
                return 32;
            }
        }
        return 0;
    }

    public String decodeSliceOrder(short s) {
        switch (s) {
            case 1: {
                return "NIFTI_SLICE_SEQ_INC";
            }
            case 2: {
                return "NIFTI_SLICE_SEQ_DEC";
            }
            case 3: {
                return "NIFTI_SLICE_ALT_INC";
            }
            case 4: {
                return "NIFTI_SLICE_ALT_DEC";
            }
        }
        return "INVALID_NIFTI_SLICE_SEQ_CODE";
    }

    public String decodeXform(short s) {
        switch (s) {
            case 0: {
                return "NIFTI_XFORM_UNKNOWN";
            }
            case 1: {
                return "NIFTI_XFORM_SCANNER_ANAT";
            }
            case 2: {
                return "NIFTI_XFORM_ALIGNED_ANAT";
            }
            case 3: {
                return "NIFTI_XFORM_TALAIRACH";
            }
            case 4: {
                return "NIFTI_XFORM_MNI_152";
            }
        }
        return "INVALID_NIFTI_XFORM_CODE";
    }

    public String decodeUnits(short s) {
        switch (s) {
            case 0: {
                return "NIFTI_UNITS_UNKNOWN";
            }
            case 1: {
                return "NIFTI_UNITS_METER";
            }
            case 2: {
                return "NIFTI_UNITS_MM";
            }
            case 3: {
                return "NIFTI_UNITS_MICRON";
            }
            case 8: {
                return "NIFTI_UNITS_SEC";
            }
            case 16: {
                return "NIFTI_UNITS_MSEC";
            }
            case 24: {
                return "NIFTI_UNITS_USEC";
            }
            case 32: {
                return "NIFTI_UNITS_HZ";
            }
            case 40: {
                return "NIFTI_UNITS_PPM";
            }
        }
        return "INVALID_NIFTI_UNITS_CODE";
    }

    public static boolean hdrIsNifti(String string) throws IOException {
        if (!string.endsWith(ANZ_HDR_EXT)) {
            return false;
        }
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(string);
        nifti1Dataset.readHeader();
        return nifti1Dataset.magic.toString().equals(ANZ_MAGIC_STRING);
    }

    private void setDefaults() {
        int n;
        this.ds_hdrname = new String("");
        this.ds_datname = new String("");
        this.ds_is_nii = true;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        this.big_endian = byteOrder == ByteOrder.BIG_ENDIAN;
        this.gzip = false;
        this.sizeof_hdr = 348;
        this.data_type_string = new StringBuffer();
        for (n = 0; n < 10; ++n) {
            this.data_type_string.append("\u0000");
        }
        this.db_name = new StringBuffer();
        for (n = 0; n < 18; ++n) {
            this.db_name.append("\u0000");
        }
        this.extents = 0;
        this.session_error = 0;
        this.regular = new StringBuffer("\u0000");
        this.dim_info = new StringBuffer("\u0000");
        this.freq_dim = 0;
        this.phase_dim = 0;
        this.slice_dim = 0;
        this.dim = new short[8];
        for (n = 0; n < 8; ++n) {
            this.dim[n] = 0;
        }
        this.XDIM = 0;
        this.YDIM = 0;
        this.ZDIM = 0;
        this.TDIM = 0;
        this.intent = new float[3];
        for (n = 0; n < 3; ++n) {
            this.intent[n] = 0.0f;
        }
        this.intent_code = 0;
        this.datatype = 0;
        this.bitpix = 0;
        this.slice_start = 0;
        this.pixdim = new float[8];
        this.pixdim[0] = 1.0f;
        this.qfac = 1;
        for (n = 1; n < 8; ++n) {
            this.pixdim[n] = 0.0f;
        }
        this.vox_offset = 352.0f;
        this.scl_slope = 0.0f;
        this.scl_inter = 0.0f;
        this.slice_end = 0;
        this.slice_code = 0;
        this.xyzt_units = 0;
        this.xyz_unit_code = 0;
        this.t_unit_code = 0;
        this.cal_max = 0.0f;
        this.cal_min = 0.0f;
        this.slice_duration = 0.0f;
        this.toffset = 0.0f;
        this.glmax = 0;
        this.glmin = 0;
        this.descrip = new StringBuffer();
        for (n = 0; n < 80; ++n) {
            this.descrip.append("\u0000");
        }
        this.aux_file = new StringBuffer();
        for (n = 0; n < 24; ++n) {
            this.aux_file.append("\u0000");
        }
        this.qform_code = 0;
        this.sform_code = 0;
        this.quatern = new float[3];
        this.qoffset = new float[3];
        for (n = 0; n < 3; ++n) {
            this.quatern[n] = 0.0f;
            this.qoffset[n] = 0.0f;
        }
        this.srow_x = new float[4];
        this.srow_y = new float[4];
        this.srow_z = new float[4];
        for (n = 0; n < 4; ++n) {
            this.srow_x[n] = 0.0f;
            this.srow_y[n] = 0.0f;
            this.srow_z[n] = 0.0f;
        }
        this.intent_name = new StringBuffer();
        for (n = 0; n < 16; ++n) {
            this.intent_name.append("\u0000");
        }
        this.magic = new StringBuffer(NII_MAGIC_STRING);
        this.extension = new byte[4];
        for (n = 0; n < 4; ++n) {
            this.extension[n] = 0;
        }
        this.extensions_list = new Vector(5);
        this.extension_blobs = new Vector(5);
    }

    private short[] unpackDimInfo(int n) {
        short[] sArray = new short[]{(short)(n & 3), (short)(n >>> 2 & 3), (short)(n >>> 4 & 3)};
        return sArray;
    }

    private byte packDimInfo(short s, short s2, short s3) {
        int n = 0;
        n = (n & (s3 & 3)) << 2;
        n = (n & (s2 & 3)) << 2;
        return (byte)(n &= s & 3);
    }

    private short[] unpackUnits(int n) {
        short[] sArray = new short[]{(short)(n & 7), (short)(n & 0x38)};
        return sArray;
    }

    private byte packUnits(short s, short s2) {
        return (byte)(s & 7 | s2 & 0x38);
    }

    private void writeData(double[][][][] dArray, OutputStream outputStream) throws IOException {
        short s = this.ZDIM;
        if (this.dim[0] == 2) {
            s = 1;
        }
        EndianCorrectOutputStream endianCorrectOutputStream = new EndianCorrectOutputStream(outputStream, this.big_endian);
        int n = this.components();
        switch (this.datatype) {
            case 256: {
                for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
                    for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                        for (short s3 = 0; s3 < this.YDIM; s3 = (short)(s3 + 1)) {
                            for (short s4 = 0; s4 < this.XDIM; s4 = (short)(s4 + 1)) {
                                if (this.scl_slope == 0.0f) {
                                    endianCorrectOutputStream.write((byte)Math.round(dArray[s4][s3][s2][n2]));
                                    continue;
                                }
                                endianCorrectOutputStream.write((byte)Math.round((dArray[s4][s3][s2][n2] - (double)this.scl_inter) / (double)this.scl_slope));
                            }
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int n3 = 0; n3 < n; n3 = (int)((short)(n3 + 1))) {
                    for (short s5 = 0; s5 < s; s5 = (short)(s5 + 1)) {
                        for (short s6 = 0; s6 < this.YDIM; s6 = (short)(s6 + 1)) {
                            for (short s7 = 0; s7 < this.XDIM; s7 = (short)(s7 + 1)) {
                                if (this.scl_slope == 0.0f) {
                                    endianCorrectOutputStream.writeShortCorrect((short)Math.round(dArray[s7][s6][s5][n3]));
                                    continue;
                                }
                                endianCorrectOutputStream.writeShortCorrect((short)Math.round((dArray[s7][s6][s5][n3] - (double)this.scl_inter) / (double)this.scl_slope));
                            }
                        }
                    }
                }
                break;
            }
            case 8: {
                for (int n4 = 0; n4 < n; n4 = (int)((short)(n4 + 1))) {
                    for (short s8 = 0; s8 < s; s8 = (short)(s8 + 1)) {
                        for (short s9 = 0; s9 < this.YDIM; s9 = (short)(s9 + 1)) {
                            for (short s10 = 0; s10 < this.XDIM; s10 = (short)(s10 + 1)) {
                                if (this.scl_slope == 0.0f) {
                                    endianCorrectOutputStream.writeIntCorrect((int)Math.round(dArray[s10][s9][s8][n4]));
                                    continue;
                                }
                                endianCorrectOutputStream.writeIntCorrect((int)Math.round((dArray[s10][s9][s8][n4] - (double)this.scl_inter) / (double)this.scl_slope));
                            }
                        }
                    }
                }
                break;
            }
            case 1024: {
                for (int n5 = 0; n5 < n; n5 = (int)((short)(n5 + 1))) {
                    for (short s11 = 0; s11 < s; s11 = (short)(s11 + 1)) {
                        for (short s12 = 0; s12 < this.YDIM; s12 = (short)(s12 + 1)) {
                            for (short s13 = 0; s13 < this.XDIM; s13 = (short)(s13 + 1)) {
                                if (this.scl_slope == 0.0f) {
                                    endianCorrectOutputStream.writeLongCorrect(Math.round(dArray[s13][s12][s11][n5]));
                                    continue;
                                }
                                endianCorrectOutputStream.writeLongCorrect(Math.round((dArray[s13][s12][s11][n5] - (double)this.scl_inter) / (double)this.scl_slope));
                            }
                        }
                    }
                }
                break;
            }
            case 16: {
                for (int n6 = 0; n6 < n; n6 = (int)((short)(n6 + 1))) {
                    for (short s14 = 0; s14 < s; s14 = (short)(s14 + 1)) {
                        for (short s15 = 0; s15 < this.YDIM; s15 = (short)(s15 + 1)) {
                            for (short s16 = 0; s16 < this.XDIM; s16 = (short)(s16 + 1)) {
                                if (this.scl_slope == 0.0f) {
                                    endianCorrectOutputStream.writeFloatCorrect((float)dArray[s16][s15][s14][n6]);
                                    continue;
                                }
                                endianCorrectOutputStream.writeFloatCorrect((float)((dArray[s16][s15][s14][n6] - (double)this.scl_inter) / (double)this.scl_slope));
                            }
                        }
                    }
                }
                break;
            }
            case 64: {
                for (int n7 = 0; n7 < n; n7 = (int)((short)(n7 + 1))) {
                    for (short s17 = 0; s17 < s; s17 = (short)(s17 + 1)) {
                        for (short s18 = 0; s18 < this.YDIM; s18 = (short)(s18 + 1)) {
                            for (short s19 = 0; s19 < this.XDIM; s19 = (short)(s19 + 1)) {
                                if (this.scl_slope == 0.0f) {
                                    endianCorrectOutputStream.writeDoubleCorrect(dArray[s19][s18][s17][n7]);
                                    continue;
                                }
                                endianCorrectOutputStream.writeDoubleCorrect((dArray[s19][s18][s17][n7] - (double)this.scl_inter) / (double)this.scl_slope);
                            }
                        }
                    }
                }
                break;
            }
            case 128: {
                for (int n8 = 0; n8 < n; n8 = (int)((short)(n8 + 1))) {
                    for (short s20 = 0; s20 < s; s20 = (short)(s20 + 1)) {
                        for (short s21 = 0; s21 < this.YDIM; s21 = (short)(s21 + 1)) {
                            for (short s22 = 0; s22 < this.XDIM; s22 = (short)(s22 + 1)) {
                                int n9 = (int)dArray[s22][s21][s20][n8];
                                endianCorrectOutputStream.write(n9 >> 16);
                                endianCorrectOutputStream.write(n9 >> 8 & 0xFF);
                                endianCorrectOutputStream.write(n9 & 0xFF);
                            }
                        }
                    }
                }
                break;
            }
            case 2304: {
                for (int n10 = 0; n10 < n; n10 = (int)((short)(n10 + 1))) {
                    for (short s23 = 0; s23 < s; s23 = (short)(s23 + 1)) {
                        for (short s24 = 0; s24 < this.YDIM; s24 = (short)(s24 + 1)) {
                            for (short s25 = 0; s25 < this.XDIM; s25 = (short)(s25 + 1)) {
                                int n11 = (int)dArray[s25][s24][s23][n10];
                                endianCorrectOutputStream.write(n11 >> 24);
                                endianCorrectOutputStream.write(n11 >> 16 & 0xFF);
                                endianCorrectOutputStream.write(n11 >> 8 & 0xFF);
                                endianCorrectOutputStream.write(n11 & 0xFF);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IOException("Sorry, cannot yet write nifti-1 datatype " + this.decodeDatatype(this.datatype));
            }
        }
        endianCorrectOutputStream.close();
    }

    protected void writeImage(double[][][][] dArray) {
        try {
            BufferedOutputStream bufferedOutputStream;
            byte[] byArray = this.headerToBytes();
            FileOutputStream fileOutputStream = new FileOutputStream(this.ds_hdrname);
            int n = 0x1000000;
            BufferedOutputStream bufferedOutputStream2 = this.gzip ? new BufferedOutputStream(new GZIPOutputStream((OutputStream)fileOutputStream, n / 4), n) : new BufferedOutputStream(fileOutputStream, n);
            if (this.ds_is_nii) {
                bufferedOutputStream = bufferedOutputStream2;
            } else {
                FileOutputStream fileOutputStream2 = new FileOutputStream(this.ds_datname);
                bufferedOutputStream = this.gzip ? new BufferedOutputStream(new GZIPOutputStream((OutputStream)fileOutputStream2, n / 4), n) : new BufferedOutputStream(fileOutputStream2, n);
            }
            ((OutputStream)bufferedOutputStream2).write(byArray);
            this.writeData(dArray, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream2).close();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException.getMessage());
        }
    }

    private byte[] setStringSize(StringBuffer stringBuffer, int n) {
        int n2;
        int n3 = stringBuffer.length();
        if (n3 >= n) {
            return stringBuffer.toString().substring(0, n).getBytes();
        }
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = (byte)stringBuffer.charAt(n2);
        }
        for (n2 = n3; n2 < n; ++n2) {
            byArray[n2] = 0;
        }
        return byArray;
    }

    public String caminoDataTypeString() {
        switch (this.datatype) {
            case 2: {
                return "ubyte";
            }
            case 256: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 512: {
                return "ushort";
            }
            case 8: {
                return "int";
            }
            case 768: {
                return "uint";
            }
            case 1024: {
                return "long";
            }
            case 16: {
                return "float";
            }
            case 64: {
                return "double";
            }
        }
        throw new LoggedException("Camino does not support this data type: " + this.decodeDatatype(this.datatype));
    }

    @Override
    public int xDataDim() {
        return this.XDIM;
    }

    @Override
    public int yDataDim() {
        return this.YDIM;
    }

    @Override
    public int zDataDim() {
        return this.ZDIM;
    }

    @Override
    public int[] getDataDims() {
        return new int[]{this.XDIM, this.YDIM, this.ZDIM};
    }

    @Override
    public double xVoxelDim() {
        return this.pixdim[1];
    }

    @Override
    public double yVoxelDim() {
        return this.pixdim[2];
    }

    @Override
    public double zVoxelDim() {
        return this.pixdim[3];
    }

    @Override
    public double[] getVoxelDims() {
        return new double[]{this.pixdim[1], this.pixdim[2], this.pixdim[3]};
    }

    @Override
    public int components() {
        if (this.dim[0] < 3) {
            throw new LoggedException("Can't handle " + this.dim[0] + "D images");
        }
        if (this.dim[0] == 3) {
            return 1;
        }
        if (this.dim[0] == 4) {
            return this.dim[4] > 0 ? this.dim[4] : 1;
        }
        if (this.dim[4] > 1 && this.dim[5] > 1) {
            throw new LoggedException("Can't handle multi-component images with multiple time points");
        }
        return this.dim[5] > 0 ? this.dim[5] : 1;
    }

    @Override
    public RealMatrix getVoxelToPhysicalTransform() {
        RealMatrix realMatrix = new RealMatrix(4, 4);
        realMatrix.entries[3][0] = 0.0;
        realMatrix.entries[3][1] = 0.0;
        realMatrix.entries[3][2] = 0.0;
        realMatrix.entries[3][3] = 1.0;
        if (this.sform_code > 0 && this.sform_code < 3) {
            for (int i = 0; i < 4; ++i) {
                realMatrix.entries[0][i] = this.srow_x[i];
                realMatrix.entries[1][i] = this.srow_y[i];
                realMatrix.entries[2][i] = this.srow_z[i];
            }
        } else if (this.qform_code > 0 && this.qform_code < 3) {
            float f = this.quatern[0];
            float f2 = this.quatern[1];
            float f3 = this.quatern[2];
            float f4 = (float)Math.sqrt(1.0 - (double)(f * f + f2 * f2 + f3 * f3));
            RealMatrix realMatrix2 = new RealMatrix(3, 3);
            realMatrix2.entries[0][0] = f4 * f4 + f * f - f2 * f2 - f3 * f3;
            realMatrix2.entries[1][1] = f4 * f4 + f2 * f2 - f * f - f3 * f3;
            realMatrix2.entries[2][2] = f4 * f4 + f3 * f3 - f2 * f2 - f * f;
            realMatrix2.entries[1][0] = 2.0 * (double)f * (double)f2 + (double)(2.0f * f4 * f3);
            realMatrix2.entries[0][1] = 2.0 * (double)f * (double)f2 - (double)(2.0f * f4 * f3);
            realMatrix2.entries[0][2] = 2.0 * (double)f * (double)f3 + 2.0 * (double)f4 * (double)f2;
            realMatrix2.entries[2][0] = 2.0 * (double)f * (double)f3 - 2.0 * (double)f4 * (double)f2;
            realMatrix2.entries[1][2] = 2.0 * (double)f2 * (double)f3 - (double)(2.0f * f4 * f);
            realMatrix2.entries[2][1] = 2.0 * (double)f2 * (double)f3 + (double)(2.0f * f4 * f);
            RealMatrix realMatrix3 = new RealMatrix(3, 3);
            realMatrix3.entries[0][0] = this.pixdim[1];
            realMatrix3.entries[1][1] = this.pixdim[2];
            realMatrix3.entries[2][2] = (float)this.qfac * this.pixdim[3];
            RealMatrix realMatrix4 = realMatrix2.product(realMatrix3);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    realMatrix.entries[i][j] = realMatrix4.entries[i][j];
                }
            }
            realMatrix.entries[0][3] = this.qoffset[0];
            realMatrix.entries[1][3] = this.qoffset[1];
            realMatrix.entries[2][3] = this.qoffset[2];
        } else {
            realMatrix.entries[0][0] = this.pixdim[1];
            realMatrix.entries[1][1] = this.pixdim[2];
            realMatrix.entries[2][2] = this.pixdim[3];
            logger.warning("Neither qform nor sform set for anatomical alignment, assuming identity rotation");
        }
        return realMatrix;
    }

    @Override
    public DataSource getImageDataSource() {
        double d = (double)this.scl_slope == 0.0 ? 1.0 : (double)this.scl_slope;
        double d2 = (double)this.scl_slope == 0.0 ? 0.0 : (double)this.scl_inter;
        boolean bl = !this.big_endian;
        String string = this.caminoDataTypeString();
        int n = (int)this.vox_offset;
        String string2 = this.ds_datname;
        if (this.dim[0] <= 2 || this.dim[0] >= 6) {
            throw new LoggedException("Can't handle this " + this.dim[0] + "-dimensional dataset. Camino " + "supports 3D or 4D scalar volumes (where fourth dimension is 1) " + "or 5D multivariate datasets");
        }
        int n2 = this.dim[1] * this.dim[2] * this.dim[3];
        int n3 = this.components();
        if (n3 == 1) {
            return new VoxelOrderScaledDataSource(this.ds_datname, 1, string, bl, n, d, d2);
        }
        ScannerOrderScaledDataSource scannerOrderScaledDataSource = new ScannerOrderScaledDataSource(this.ds_datname, n2, n3, string, bl, n, d, d2);
        return scannerOrderScaledDataSource;
    }

    @Override
    public double[][][][] readVolumeData() {
        int n = this.ZDIM;
        if (this.dim[0] == 2) {
            n = 1;
        }
        int n2 = this.components();
        double[][][][] dArray = new double[this.XDIM][this.YDIM][n][n2];
        try {
            FilterInputStream filterInputStream;
            int n3;
            if (this.ds_datname.endsWith(GZIP_EXT)) {
                n3 = 0x800000;
                filterInputStream = new BufferedInflaterInputStream(new GZIPInputStream((InputStream)new FileInputStream(this.ds_datname), n3), n3 * 2);
            } else {
                n3 = 0x1800000;
                filterInputStream = new BufferedInputStream(new FileInputStream(this.ds_datname), n3);
            }
            ((InputStream)filterInputStream).skip((int)this.vox_offset);
            EndianNeutralDataInputStream endianNeutralDataInputStream = new EndianNeutralDataInputStream(filterInputStream, !this.big_endian);
            switch (this.datatype) {
                case 256: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i2 = 0; i2 < this.XDIM; ++i2) {
                                    dArray[i2][k][j][i] = endianNeutralDataInputStream.readByte();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i2][k][j][i] = dArray[i2][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i3 = 0; i3 < this.XDIM; ++i3) {
                                    dArray[i3][k][j][i] = endianNeutralDataInputStream.readUnsignedByte();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i3][k][j][i] = dArray[i3][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i4 = 0; i4 < this.XDIM; ++i4) {
                                    dArray[i4][k][j][i] = endianNeutralDataInputStream.readShort();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i4][k][j][i] = dArray[i4][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 512: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i5 = 0; i5 < this.XDIM; ++i5) {
                                    dArray[i5][k][j][i] = endianNeutralDataInputStream.readUnsignedShort();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i5][k][j][i] = dArray[i5][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 8: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i6 = 0; i6 < this.XDIM; ++i6) {
                                    dArray[i6][k][j][i] = endianNeutralDataInputStream.readInt();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i6][k][j][i] = dArray[i6][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 768: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i7 = 0; i7 < this.XDIM; ++i7) {
                                    dArray[i7][k][j][i] = endianNeutralDataInputStream.readUnsignedInt();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i7][k][j][i] = dArray[i7][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 1024: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i8 = 0; i8 < this.XDIM; ++i8) {
                                    dArray[i8][k][j][i] = endianNeutralDataInputStream.readLong();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i8][k][j][i] = dArray[i8][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 16: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i9 = 0; i9 < this.XDIM; ++i9) {
                                    dArray[i9][k][j][i] = endianNeutralDataInputStream.readFloat();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i9][k][j][i] = dArray[i9][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                case 64: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < this.YDIM; ++k) {
                                for (int i10 = 0; i10 < this.XDIM; ++i10) {
                                    dArray[i10][k][j][i] = endianNeutralDataInputStream.readDouble();
                                    if ((double)this.scl_slope == 0.0) continue;
                                    dArray[i10][k][j][i] = dArray[i10][k][j][i] * (double)this.scl_slope + (double)this.scl_inter;
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new LoggedException("Sorry, cannot yet read nifti-1 datatype " + this.decodeDatatype(this.datatype));
                }
            }
            endianNeutralDataInputStream.close();
        }
        catch (IOException iOException) {
            throw new LoggedException("Error reading volume data: " + iOException.getMessage());
        }
        return dArray;
    }

    @Override
    protected String getHeaderFilename() {
        return this.ds_hdrname;
    }

    @Override
    protected String getDataFilename() {
        return this.ds_datname;
    }

    @Override
    public ImageHeader writeScalarImage(double[][][] dArray, String string) {
        int n;
        if (dArray.length != this.XDIM || dArray[0].length != this.YDIM || dArray[0][0].length != this.ZDIM) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.XDIM + " " + this.YDIM + " " + this.ZDIM);
        }
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(this, string);
        nifti1Dataset.setDataTypeToSigned();
        double[][][][] dArray2 = new double[this.XDIM][this.YDIM][this.ZDIM][1];
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.XDIM; ++n) {
            for (int i = 0; i < this.YDIM; ++i) {
                for (int j = 0; j < this.ZDIM; ++j) {
                    dArray2[n][i][j][0] = dArray[n][i][j];
                    if (dArray[n][i][j] < d) {
                        d = dArray[n][i][j];
                    }
                    if (!(dArray[n][i][j] > d2)) continue;
                    d2 = dArray[n][i][j];
                }
            }
        }
        nifti1Dataset.glmin = (int)Math.round(d);
        nifti1Dataset.glmax = (int)Math.round(d2);
        nifti1Dataset.scl_slope = 1.0f;
        nifti1Dataset.scl_inter = 0.0f;
        nifti1Dataset.dim[0] = 3;
        nifti1Dataset.dim[4] = 0;
        nifti1Dataset.dim[5] = 0;
        nifti1Dataset.dim[6] = 0;
        nifti1Dataset.dim[7] = 0;
        nifti1Dataset.setPixDims(this.pixdim[0], this.pixdim[1], this.pixdim[2], this.pixdim[3], 0.0f, 0.0f, 0.0f, 0.0f);
        nifti1Dataset.intent_code = 0;
        nifti1Dataset.intent_name = new StringBuffer();
        for (n = 0; n < 3; ++n) {
            nifti1Dataset.dim[n + 5] = 0;
        }
        nifti1Dataset.writeImage(dArray2);
        return nifti1Dataset;
    }

    @Override
    public ImageHeader writeVectorImage(double[][][][] dArray, String string) {
        if (dArray.length != this.XDIM || dArray[0].length != this.YDIM || dArray[0][0].length != this.ZDIM) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.XDIM + " " + this.YDIM + " " + this.ZDIM);
        }
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(this, string);
        nifti1Dataset.setDataTypeToSigned();
        nifti1Dataset.dim[0] = 5;
        nifti1Dataset.dim[4] = 1;
        nifti1Dataset.dim[5] = (short)dArray[0][0][0].length;
        nifti1Dataset.dim[6] = 0;
        nifti1Dataset.dim[7] = 0;
        nifti1Dataset.setPixDims(this.pixdim[0], this.pixdim[1], this.pixdim[2], this.pixdim[3], 0.0f, 0.0f, 0.0f, 0.0f);
        nifti1Dataset.intent_code = 0;
        nifti1Dataset.intent_name = new StringBuffer();
        nifti1Dataset.glmin = 0;
        nifti1Dataset.glmax = 0;
        nifti1Dataset.scl_slope = 1.0f;
        nifti1Dataset.scl_inter = 0.0f;
        nifti1Dataset.writeImage(dArray);
        return nifti1Dataset;
    }

    @Override
    public ImageHeader writeRGB_Image(int[][][] nArray, int[][][] nArray2, int[][][] nArray3, String string) {
        if (nArray.length != this.XDIM || nArray[0].length != this.YDIM || nArray[0][0].length != this.ZDIM) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.XDIM + " " + this.YDIM + " " + this.ZDIM);
        }
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(this, string);
        nifti1Dataset.setDataTypeToSigned();
        nifti1Dataset.dim[0] = 3;
        nifti1Dataset.dim[4] = 0;
        nifti1Dataset.dim[5] = 0;
        nifti1Dataset.dim[6] = 0;
        nifti1Dataset.dim[7] = 0;
        nifti1Dataset.setPixDims(this.pixdim[0], this.pixdim[1], this.pixdim[2], this.pixdim[3], 0.0f, 0.0f, 0.0f, 0.0f);
        nifti1Dataset.datatype = (short)128;
        nifti1Dataset.intent_code = 0;
        nifti1Dataset.intent_name = new StringBuffer();
        nifti1Dataset.glmin = 0;
        nifti1Dataset.glmax = 0;
        nifti1Dataset.scl_slope = 1.0f;
        nifti1Dataset.scl_inter = 0.0f;
        double[][][][] dArray = new double[this.XDIM][this.YDIM][this.ZDIM][1];
        for (int i = 0; i < this.XDIM; ++i) {
            for (int j = 0; j < this.YDIM; ++j) {
                for (int k = 0; k < this.ZDIM; ++k) {
                    int n = nArray3[i][j][k] + 256 * (nArray2[i][j][k] + 256 * nArray[i][j][k]);
                    dArray[i][j][k][0] = n;
                }
            }
        }
        nifti1Dataset.writeImage(dArray);
        return nifti1Dataset;
    }

    public ImageHeader writeRGBA_Image(int[][][] nArray, int[][][] nArray2, int[][][] nArray3, double[][][] dArray, String string) {
        if (nArray.length != this.XDIM || nArray[0].length != this.YDIM || nArray[0][0].length != this.ZDIM) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.XDIM + " " + this.YDIM + " " + this.ZDIM);
        }
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(this, string);
        nifti1Dataset.setDataTypeToSigned();
        nifti1Dataset.dim[0] = 3;
        nifti1Dataset.dim[4] = 0;
        nifti1Dataset.dim[5] = 0;
        nifti1Dataset.dim[6] = 0;
        nifti1Dataset.dim[7] = 0;
        nifti1Dataset.setPixDims(this.pixdim[0], this.pixdim[1], this.pixdim[2], this.pixdim[3], 0.0f, 0.0f, 0.0f, 0.0f);
        nifti1Dataset.datatype = (short)2304;
        nifti1Dataset.intent_code = 0;
        nifti1Dataset.intent_name = new StringBuffer();
        nifti1Dataset.glmin = 0;
        nifti1Dataset.glmax = 0;
        nifti1Dataset.scl_slope = 1.0f;
        nifti1Dataset.scl_inter = 0.0f;
        double[][][][] dArray2 = new double[this.XDIM][this.YDIM][this.ZDIM][1];
        for (int i = 0; i < this.XDIM; ++i) {
            for (int j = 0; j < this.YDIM; ++j) {
                for (int k = 0; k < this.ZDIM; ++k) {
                    int n = (int)(255.0 * dArray[i][j][k]);
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > 255) {
                        n = 255;
                    }
                    int n2 = n + 256 * (nArray3[i][j][k] + 256 * nArray2[i][j][k] + 65536 * nArray[i][j][k]);
                    dArray2[i][j][k][0] = n2;
                }
            }
        }
        nifti1Dataset.writeImage(dArray2);
        return nifti1Dataset;
    }

    @Override
    public ImageHeader writeTensorImage(double[][][][] dArray, String string) {
        if (dArray.length != this.XDIM || dArray[0].length != this.YDIM || dArray[0][0].length != this.ZDIM) {
            throw new LoggedException("Attempted to write image inconsistent with header dimensions " + this.XDIM + " " + this.YDIM + " " + this.ZDIM);
        }
        if (dArray[0][0][0].length != 6) {
            throw new LoggedException("DT output data must have six components");
        }
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(this, string);
        nifti1Dataset.setDataTypeToSigned();
        nifti1Dataset.dim[0] = 5;
        nifti1Dataset.dim[4] = 1;
        nifti1Dataset.dim[5] = 6;
        nifti1Dataset.dim[6] = 0;
        nifti1Dataset.dim[7] = 0;
        nifti1Dataset.setPixDims(this.pixdim[0], this.pixdim[1], this.pixdim[2], this.pixdim[3], 0.0f, 0.0f, 0.0f, 0.0f);
        nifti1Dataset.intent_code = (short)1005;
        nifti1Dataset.intent_name = new StringBuffer();
        nifti1Dataset.glmin = 0;
        nifti1Dataset.glmax = 0;
        nifti1Dataset.scl_slope = 1.0f;
        nifti1Dataset.scl_inter = 0.0f;
        double[][][][] dArray2 = new double[this.XDIM][this.YDIM][this.ZDIM][6];
        for (int i = 0; i < this.XDIM; ++i) {
            for (int j = 0; j < this.YDIM; ++j) {
                for (int k = 0; k < this.ZDIM; ++k) {
                    dArray2[i][j][k][0] = dArray[i][j][k][0];
                    dArray2[i][j][k][1] = dArray[i][j][k][1];
                    dArray2[i][j][k][2] = dArray[i][j][k][3];
                    dArray2[i][j][k][3] = dArray[i][j][k][2];
                    dArray2[i][j][k][4] = dArray[i][j][k][4];
                    dArray2[i][j][k][5] = dArray[i][j][k][5];
                }
            }
        }
        nifti1Dataset.writeImage(dArray2);
        return nifti1Dataset;
    }

    @Override
    public void setDataType(String string) {
        if (string.equals("ubyte")) {
            this.datatype = (short)2;
        } else if (string.equals("byte")) {
            this.datatype = (short)256;
        } else if (string.equals("short")) {
            this.datatype = (short)4;
        } else if (string.equals("ushort")) {
            this.datatype = (short)512;
        } else if (string.equals("int")) {
            this.datatype = (short)8;
        } else if (string.equals("uint")) {
            this.datatype = (short)768;
        } else if (string.equals("long")) {
            this.datatype = (short)1024;
        } else if (string.equals("float")) {
            this.datatype = (short)16;
        } else if (string.equals("double")) {
            this.datatype = (short)64;
        } else {
            throw new LoggedException("Camino does not support this data type: " + this.decodeDatatype(this.datatype));
        }
    }

    @Override
    public void setGzip(boolean bl) {
        if (bl == this.gzip) {
            return;
        }
        String string = null;
        string = this.gzip ? this.ds_hdrname.substring(0, this.ds_hdrname.length() - 7) : this.ds_hdrname.substring(0, this.ds_hdrname.length() - 4);
        this.setFilename(string, this.ds_is_nii, bl);
    }

    public String getDataType() {
        switch (this.datatype) {
            case 2: {
                return "char";
            }
            case 256: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 512: {
                return "ushort";
            }
            case 8: {
                return "int";
            }
            case 768: {
                return "uint";
            }
            case 1024: {
                return "long";
            }
            case 16: {
                return "float";
            }
            case 64: {
                return "double";
            }
        }
        throw new LoggedException("Camino does not support this data type: " + this.decodeDatatype(this.datatype));
    }

    public static ImageHeader readHeader(String string) throws IOException {
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(string);
        return nifti1Dataset;
    }

    public static void convertTo3D(String string, String string2) throws IOException {
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(string);
        nifti1Dataset.readHeader();
        int n = nifti1Dataset.components();
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        double[][][][] dArray = nifti1Dataset.readVolumeData();
        for (int i = 0; i < n; ++i) {
            double[][][][] dArray2 = new double[nifti1Dataset.XDIM][nifti1Dataset.YDIM][nifti1Dataset.ZDIM][1];
            for (int j = 0; j < nifti1Dataset.XDIM; ++j) {
                for (int k = 0; k < nifti1Dataset.YDIM; ++k) {
                    for (int i2 = 0; i2 < nifti1Dataset.ZDIM; ++i2) {
                        dArray2[j][k][i2][0] = dArray[j][k][i2][i];
                    }
                }
            }
            Nifti1Dataset nifti1Dataset2 = new Nifti1Dataset();
            nifti1Dataset2.copyHeader(nifti1Dataset);
            nifti1Dataset2.setDims(3, nifti1Dataset2.xDataDim(), nifti1Dataset2.yDataDim(), nifti1Dataset2.zDataDim(), 1, 0, 0, 0);
            nifti1Dataset2.intent_code = 0;
            nifti1Dataset2.intent_name = new StringBuffer("comp " + decimalFormat.format(i + 1));
            nifti1Dataset2.setFilename(string2 + decimalFormat.format(i + 1), nifti1Dataset.ds_is_nii, nifti1Dataset.gzip);
            nifti1Dataset2.writeImage(dArray2);
        }
    }

    public boolean checkQuaternion() {
        float f = this.quatern[0];
        float f2 = this.quatern[1];
        float f3 = this.quatern[2];
        if ((double)(f * f + f2 * f2 + f3 * f3) > 1.00000001) {
            logger.warning("Quaternian does not have unit magnitude [b,c,d] = [" + f + ", " + f2 + ", " + f3 + "]");
            return false;
        }
        float f4 = 1.0f - (f * f + f2 * f2 + f3 * f3);
        float f5 = 0.0f;
        if ((double)f4 > 0.0) {
            f5 = (float)Math.sqrt(f4);
        }
        RealMatrix realMatrix = new RealMatrix(3, 3);
        realMatrix.entries[0][0] = f5 * f5 + f * f - f2 * f2 - f3 * f3;
        realMatrix.entries[1][1] = f5 * f5 + f2 * f2 - f * f - f3 * f3;
        realMatrix.entries[2][2] = f5 * f5 + f3 * f3 - f2 * f2 - f * f;
        realMatrix.entries[0][1] = 2.0 * (double)f * (double)f2 - (double)(2.0f * f5 * f3);
        realMatrix.entries[0][2] = 2.0 * (double)f * (double)f3 + 2.0 * (double)f5 * (double)f2;
        realMatrix.entries[1][2] = 2.0 * (double)f2 * (double)f3 - (double)(2.0f * f5 * f);
        realMatrix.entries[1][0] = 2.0 * (double)f * (double)f2 + (double)(2.0f * f5 * f3);
        realMatrix.entries[2][0] = 2.0 * (double)f * (double)f3 - 2.0 * (double)f5 * (double)f2;
        realMatrix.entries[2][1] = 2.0 * (double)f2 * (double)f3 + (double)(2.0f * f5 * f);
        double d = realMatrix.det();
        if (d < 0.0) {
            logger.warning("Determinant of quaternian is negative");
            return false;
        }
        logger.info("Quaternion rotation:\n" + realMatrix.toString());
        logger.info("qfac: " + this.qfac);
        return true;
    }

    public void setQuaternion(short s, short s2, float[] fArray, float[] fArray2) {
        this.qform_code = s;
        this.qfac = s2;
        this.pixdim[0] = this.qfac;
        for (int i = 0; i < 3; ++i) {
            this.quatern[i] = fArray[i];
            this.qoffset[i] = fArray2[i];
        }
        if (!this.checkQuaternion()) {
            throw new LoggedException("Invalid quarternion parameters set");
        }
    }

    public void setSform(short s, RealMatrix realMatrix) {
        this.sform_code = s;
        for (int i = 0; i < 4; ++i) {
            this.srow_x[i] = (float)realMatrix.entries[0][i];
            this.srow_y[i] = (float)realMatrix.entries[1][i];
            this.srow_z[i] = (float)realMatrix.entries[2][i];
        }
    }

    private void setDataTypeToSigned() {
        switch (this.datatype) {
            case 2: {
                this.datatype = (short)256;
            }
            case 512: {
                this.datatype = (short)4;
            }
            case 768: {
                this.datatype = (short)8;
            }
            case 1280: {
                this.datatype = (short)1024;
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        Nifti1Dataset nifti1Dataset = null;
        OutputManager.outputFile = "niftiheader.nii";
        CL_Initializer.CL_init(stringArray);
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-initfromheader")) continue;
            nifti1Dataset = new Nifti1Dataset(stringArray[n + 1]);
            CL_Initializer.markAsParsed(n, 2);
            try {
                nifti1Dataset.readHeader();
                continue;
            }
            catch (IOException iOException) {
                System.out.println("\nCould not read header file for " + stringArray[n + 1] + ": " + iOException.getMessage());
            }
        }
        if (nifti1Dataset == null) {
            nifti1Dataset = new Nifti1Dataset();
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            if (stringArray[n].equals("-readheader")) {
                nifti1Dataset = new Nifti1Dataset(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                try {
                    nifti1Dataset.readHeader();
                }
                catch (IOException iOException) {
                    System.out.println("\nCould not read header file for " + stringArray[n + 1] + ": " + iOException.getMessage());
                }
                nifti1Dataset.checkQuaternion();
                nifti1Dataset.printHeader();
                return;
            }
            if (stringArray[n].equals("-datatype")) {
                nifti1Dataset.setDataType(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-intent")) {
                nifti1Dataset.intent_code = Short.parseShort(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-networkbyteorder")) {
                nifti1Dataset.big_endian = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-intelbyteorder")) {
                nifti1Dataset.big_endian = false;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-scaleslope")) {
                nifti1Dataset.scl_slope = Float.parseFloat(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-scaleinter")) {
                nifti1Dataset.scl_inter = Float.parseFloat(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-dims")) {
                int n3 = Short.parseShort(stringArray[n + 1]);
                short[] sArray = new short[8];
                sArray[0] = n3;
                for (n2 = 0; n2 < n3; ++n2) {
                    sArray[n2 + 1] = Short.parseShort(stringArray[n + 2 + n2]);
                }
                nifti1Dataset.setDims(sArray);
                CL_Initializer.markAsParsed(n, n3 + 2);
            }
            if (stringArray[n].equals("-pixdims")) {
                float[] fArray = new float[8];
                int n4 = Integer.parseInt(stringArray[n + 1]) + 1;
                for (n2 = 0; n2 < n4; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n + 2 + n2]);
                }
                nifti1Dataset.setPixDims(fArray);
                CL_Initializer.markAsParsed(n, n4 + 2);
            }
            if (stringArray[n].equals("-qform")) {
                nifti1Dataset.qform_code = Short.parseShort(stringArray[n + 1]);
                float f = Float.parseFloat(stringArray[n + 2]);
                f = f < 0.0f ? -1.0f : 1.0f;
                nifti1Dataset.pixdim[0] = f;
                nifti1Dataset.qfac = (short)f;
                nifti1Dataset.quatern[0] = Float.parseFloat(stringArray[n + 3]);
                nifti1Dataset.quatern[1] = Float.parseFloat(stringArray[n + 4]);
                nifti1Dataset.quatern[2] = Float.parseFloat(stringArray[n + 5]);
                nifti1Dataset.qoffset[0] = Float.parseFloat(stringArray[n + 6]);
                nifti1Dataset.qoffset[1] = Float.parseFloat(stringArray[n + 7]);
                nifti1Dataset.qoffset[2] = Float.parseFloat(stringArray[n + 8]);
                CL_Initializer.markAsParsed(n, 9);
                nifti1Dataset.checkQuaternion();
            }
            if (stringArray[n].equals("-sform")) {
                int n5;
                nifti1Dataset.sform_code = Short.parseShort(stringArray[n + 1]);
                for (n5 = 0; n5 < 4; ++n5) {
                    nifti1Dataset.srow_x[n5] = Float.parseFloat(stringArray[n + 2 + n5]);
                }
                for (n5 = 0; n5 < 4; ++n5) {
                    nifti1Dataset.srow_y[n5] = Float.parseFloat(stringArray[n + 6 + n5]);
                }
                for (n5 = 0; n5 < 4; ++n5) {
                    nifti1Dataset.srow_z[n5] = Float.parseFloat(stringArray[n + 10 + n5]);
                }
                CL_Initializer.markAsParsed(n, 14);
            }
            if (!stringArray[n].equals("-dt2symmatrix")) continue;
            nifti1Dataset.intent_code = (short)1005;
            nifti1Dataset.dim[0] = 5;
            nifti1Dataset.dim[4] = 1;
            nifti1Dataset.dim[5] = 6;
            CL_Initializer.markAsParsed(n, 1);
        }
        CL_Initializer.checkParsing(stringArray);
        n = 0;
        boolean bl = false;
        if (OutputManager.outputFile.endsWith(GZIP_EXT)) {
            n = 1;
            OutputManager.outputFile = OutputManager.outputFile.substring(0, OutputManager.outputFile.length() - 3);
        }
        if (OutputManager.outputFile.endsWith(NI1_EXT)) {
            bl = true;
        }
        OutputManager.outputFile = OutputManager.outputFile.substring(0, OutputManager.outputFile.length() - 4);
        try {
            nifti1Dataset.setFilename(OutputManager.outputFile, bl, n != 0);
            if (new File(nifti1Dataset.getHeaderFilename()).exists()) {
                throw new LoggedException("This program cannot modify existing headers (image data would be overwritten)");
            }
            nifti1Dataset.writeHeader();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

