/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.DW_Scheme;
import imaging.StejskalTannerScheme;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;

public final class RectGradSteTanScheme
extends StejskalTannerScheme {
    public static final String VERSION = "STEJSKALTANNER";
    private static final Logger logger = Logger.getLogger("camino.imaging.RectGradSteTanScheme");

    protected RectGradSteTanScheme(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        super(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    protected RectGradSteTanScheme(double[][] dArray, RectGradSteTanScheme rectGradSteTanScheme) {
        super(dArray, rectGradSteTanScheme);
    }

    @Override
    public double getB_Value(int n) {
        double d = this.getModQ(n);
        return d * d * (this.getDELTA(n) - this.getDelta(n) / 3.0);
    }

    private DW_Scheme flip(int n) {
        double[][] dArray = new double[this.numMeas][3];
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            dArray[i] = this.getG_Dir(i);
            dArray[i][n] = -dArray[i][n];
        }
        return new RectGradSteTanScheme(dArray, this);
    }

    @Override
    public DW_Scheme flipX() {
        return this.flip(0);
    }

    @Override
    public DW_Scheme flipY() {
        return this.flip(1);
    }

    @Override
    public DW_Scheme flipZ() {
        return this.flip(2);
    }

    @Override
    public DW_Scheme getSubsetScheme(int[] nArray) {
        int n = nArray.length;
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getG_Dir(nArray[i]);
            dArray2[i] = this.getModG(nArray[i]);
            dArray3[i] = this.getDELTA(nArray[i]);
            dArray4[i] = this.getDelta(nArray[i]);
            dArray5[i] = this.getTE(nArray[i]);
        }
        return new RectGradSteTanScheme(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    @Override
    public DW_Scheme gradOrder(int[] nArray) {
        double[][] dArray = new double[this.numMeas][3];
        for (int i = 0; i < this.numMeas; ++i) {
            double[] dArray2 = this.getG_Dir(i);
            dArray[i][0] = dArray2[nArray[0]];
            dArray[i][1] = dArray2[nArray[1]];
            dArray[i][2] = dArray2[nArray[2]];
        }
        return new RectGradSteTanScheme(dArray, this);
    }

    @Override
    public double[] getGradImpulse(int n, double d, double d2) {
        double d3;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double d4 = 1.0;
        double d5 = this.getTE(n);
        if (!(d >= 0.0) || !(d <= d5)) {
            return dArray;
        }
        if (this.zero(n)) {
            return dArray;
        }
        double d6 = this.getDELTA(n);
        double d7 = this.getDelta(n);
        double d8 = d3 = (d5 - d6 - d7) / 2.0;
        double d9 = d3 + d7;
        double d10 = d3 + d6;
        double d11 = d3 + d6 + d7;
        if (d < d3 || d > d5 - d3) {
            return dArray;
        }
        if (d >= d8 && d < d9 && d2 < d8) {
            double d12 = d - d8;
            double d13 = this.getModG(n);
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = d4 * d13 * this.gDir[n][i] * d12;
            }
            return dArray2;
        }
        if (d >= d9 && d < d10) {
            if (d2 < d9) {
                double d14 = d9 - d2;
                double d15 = this.getModG(n);
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = d4 * d15 * this.gDir[n][i] * d14;
                }
                return dArray2;
            }
            return dArray;
        }
        if (d >= d10) {
            d4 = -1.0;
        }
        if (d >= d11) {
            if (d2 < d11) {
                double d16 = d11 - d2;
                double d17 = this.getModG(n);
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = d4 * d17 * this.gDir[n][i] * d16;
                }
                return dArray2;
            }
            return dArray;
        }
        if (d >= d10 && d2 < d10) {
            double d18 = d - d10;
            double d19 = this.getModG(n);
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = d4 * d19 * this.gDir[n][i] * d18;
            }
            return dArray2;
        }
        double d20 = this.getModG(n);
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = d4 * d20 * this.gDir[n][i] * (d - d2);
        }
        return dArray2;
    }

    @Override
    public double getDuration() {
        double d = 0.0;
        for (int i = 0; i < this.numMeas; ++i) {
            double d2 = this.getTE(i);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    protected static RectGradSteTanScheme readScheme(Vector<String> vector) {
        int n = vector.size();
        if (n == 0) {
            throw new LoggedException("No measurements in scheme file");
        }
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        for (int i = 0; i < n; ++i) {
            Scanner scanner = new Scanner(vector.elementAt(i));
            dArray[i][0] = scanner.nextDouble();
            dArray[i][1] = scanner.nextDouble();
            dArray[i][2] = scanner.nextDouble();
            dArray2[i] = scanner.nextDouble();
            dArray3[i] = scanner.nextDouble();
            dArray4[i] = scanner.nextDouble();
            dArray5[i] = scanner.nextDouble();
            scanner.close();
            if (dArray2[i] != 0.0 || dArray[i][0] == 0.0 && dArray[i][1] == 0.0 && dArray[i][2] == 0.0) continue;
            logger.info("Zero diffusion weighting in measurement " + i + ", setting gradient direction to zero");
            dArray[i][0] = 0.0;
            dArray[i][1] = 0.0;
            dArray[i][2] = 0.0;
        }
        return new RectGradSteTanScheme(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#Stejskal-Tanner scheme with rectangular gradient pulses\n");
        stringBuffer.append("#g_x\tg_y\tg_z\t|g|\tDELTA\tdelta\tTE\n");
        stringBuffer.append("VERSION: STEJSKALTANNER");
        stringBuffer.append("\n");
        for (int i = 0; i < this.numMeas; ++i) {
            double[] dArray = this.getG_Dir(i);
            stringBuffer.append(decimalFormat.format(dArray[0]));
            stringBuffer.append(decimalFormat.format(dArray[1]));
            stringBuffer.append(decimalFormat.format(dArray[2]));
            stringBuffer.append(decimalFormat.format(this.getModG(i)));
            stringBuffer.append(decimalFormat.format(this.getDELTA(i)));
            stringBuffer.append(decimalFormat.format(this.getDelta(i)));
            stringBuffer.append(decimalFormat.format(this.getTE(i)));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

