/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.DW_Scheme;
import imaging.SimulableScheme;
import java.util.logging.Logger;
import misc.LoggedException;

public abstract class TRSE_Scheme
extends DW_Scheme
implements SimulableScheme {
    private static final Logger logger = Logger.getLogger("camino.imaging.TRSE_Scheme");
    private final double[] modG;
    private final double[] bigDel;
    private final double[] del1;
    private final double[] t_del1;
    private final double[] del2;
    private final double[] t_del2;
    private final double[] del3;
    private final double[] t_del3;
    private final double[] del4;
    private final double[] t_del4;
    private final double[] TE;

    protected TRSE_Scheme(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9) {
        super(dArray);
        this.modG = new double[this.numMeas];
        this.bigDel = new double[this.numMeas];
        this.del1 = new double[this.numMeas];
        this.t_del1 = new double[this.numMeas];
        this.del2 = new double[this.numMeas];
        this.t_del2 = new double[this.numMeas];
        this.del3 = new double[this.numMeas];
        this.t_del3 = new double[this.numMeas];
        this.del4 = new double[this.numMeas];
        this.t_del4 = new double[this.numMeas];
        this.TE = new double[this.numMeas];
        System.arraycopy(dArray2, 0, this.modG, 0, this.numMeas);
        System.arraycopy(dArray3, 0, this.del1, 0, this.numMeas);
        System.arraycopy(dArray4, 0, this.t_del1, 0, this.numMeas);
        System.arraycopy(dArray5, 0, this.del2, 0, this.numMeas);
        System.arraycopy(dArray6, 0, this.t_del2, 0, this.numMeas);
        System.arraycopy(dArray7, 0, this.del3, 0, this.numMeas);
        System.arraycopy(dArray8, 0, this.t_del4, 0, this.numMeas);
        System.arraycopy(dArray9, 0, this.TE, 0, this.numMeas);
        for (int i = 0; i < this.numMeas; ++i) {
            this.t_del3[i] = dArray6[i] + dArray5[i];
            this.bigDel[i] = this.t_del3[i] - dArray4[i];
            if (dArray7[i] > dArray3[i] + dArray5[i]) {
                throw new LoggedException(" third gradient pulse in direction " + i + " of schemefile is longer than sum of first two.");
            }
            this.del4[i] = dArray3[i] + dArray5[i] - dArray7[i];
        }
    }

    protected TRSE_Scheme(double[][] dArray, TRSE_Scheme tRSE_Scheme) {
        this(dArray, tRSE_Scheme.modG, tRSE_Scheme.del1, tRSE_Scheme.t_del1, tRSE_Scheme.del2, tRSE_Scheme.t_del2, tRSE_Scheme.del3, tRSE_Scheme.t_del4, tRSE_Scheme.TE);
    }

    public final double[][] getNonZeroGs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero(i)) continue;
            double[] dArray2 = this.getG_Dir(i);
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = this.modG[i] * dArray2[j];
            }
            ++n;
        }
        return dArray;
    }

    public final double[] getNonZeroBigDeltas() {
        return this.getNonZeroParam(this.bigDel);
    }

    public final double[] getNonZeroDelta1s() {
        return this.getNonZeroParam(this.del1);
    }

    public final double[] getNonZeroT_Delta1s() {
        return this.getNonZeroParam(this.t_del1);
    }

    public final double[] getNonZeroDelta2s() {
        return this.getNonZeroParam(this.del2);
    }

    public final double[] getNonZeroT_Delta2s() {
        return this.getNonZeroParam(this.t_del2);
    }

    public final double[] getNonZeroDelta3s() {
        return this.getNonZeroParam(this.del3);
    }

    public final double[] getNonZeroT_Delta3s() {
        return this.getNonZeroParam(this.t_del1);
    }

    public final double[] getNonZeroDelta4s() {
        return this.getNonZeroParam(this.del4);
    }

    public final double[] getNonZeroT_Delta4s() {
        return this.getNonZeroParam(this.t_del4);
    }

    public final double[] getNonZeroTEs() {
        return this.getNonZeroParam(this.TE);
    }

    public final double[] getNonZeroModGs() {
        return this.getNonZeroParam(this.modG);
    }

    public final double[] getG(int n) {
        double[] dArray = this.getG_Dir(n);
        int n2 = 0;
        while (n2 < 3) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * this.modG[n];
        }
        return dArray;
    }

    public final double getDELTA(int n) {
        return this.bigDel[n];
    }

    public final double getModG(int n) {
        return this.modG[n];
    }

    public final double getT_Del1(int n) {
        return this.t_del1[n];
    }

    public final double getT_Del2(int n) {
        return this.t_del2[n];
    }

    public final double getT_Del3(int n) {
        return this.t_del3[n];
    }

    public final double getT_Del4(int n) {
        return this.t_del4[n];
    }

    public final double getDel1(int n) {
        return this.del1[n];
    }

    public final double getDel2(int n) {
        return this.del2[n];
    }

    public final double getDel3(int n) {
        return this.del3[n];
    }

    public final double getDel4(int n) {
        return this.del4[n];
    }

    public final double getTE(int n) {
        return this.TE[n];
    }

    @Override
    public abstract double[] getGradImpulse(int var1, double var2, double var4);

    @Override
    public abstract double getDuration();
}

