/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.DW_Scheme;
import inverters.DiffusionInversion;
import numerics.RealMatrix;

public class LinearADC_Inversion
extends DiffusionInversion {
    protected RealMatrix linearInv;
    protected static final double SVTHRESH = 1.0E12;
    public static final int ITEMSPERVOX = 3;

    public LinearADC_Inversion(DW_Scheme dW_Scheme) {
        int n;
        this.ip = dW_Scheme;
        RealMatrix realMatrix = new RealMatrix(this.ip.numMeasurements(), 2);
        for (int i = 0; i < realMatrix.rows(); ++i) {
            double[] dArray = this.ip.getG_Dir(i);
            realMatrix.setEntry(i, 0, 1.0);
            realMatrix.setEntry(i, 1, -this.ip.getB_Value(i));
        }
        RealMatrix[] realMatrixArray = null;
        try {
            realMatrixArray = realMatrix.svd();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        double d = realMatrixArray[1].entry(0, 0);
        for (n = 0; n < realMatrixArray[1].rows() && n < realMatrixArray[1].columns(); ++n) {
            if (!(realMatrixArray[1].entry(n, n) > d)) continue;
            d = realMatrixArray[1].entry(n, n);
        }
        for (n = 0; n < realMatrixArray[1].rows() && n < realMatrixArray[1].columns(); ++n) {
            double d2 = realMatrixArray[1].entry(n, n);
            realMatrixArray[1].setEntry(n, n, d2 > d / 1.0E12 ? 1.0 / d2 : 0.0);
        }
        this.linearInv = realMatrixArray[2].product(realMatrixArray[1].transpose()).product(realMatrixArray[0].transpose());
    }

    @Override
    public double[] invert(double[] dArray) {
        double d = 0.0;
        RealMatrix realMatrix = new RealMatrix(dArray.length, 1);
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > 0.0) {
                realMatrix.setEntry(i, 0, Math.log(dArray[i]));
                continue;
            }
            realMatrix.setEntry(i, 0, 0.0);
            d = 6.0;
        }
        RealMatrix realMatrix2 = this.linearInv.product(realMatrix);
        double[] dArray2 = new double[3];
        dArray2[0] = d;
        for (int i = 0; i < 2; ++i) {
            dArray2[i + 1] = realMatrix2.entry(i, 0);
        }
        return dArray2;
    }

    @Override
    public int itemsPerVoxel() {
        return 3;
    }
}

