/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.ModelIndex;
import inverters.TensorModelFitter;
import inverters.ThreeTensorAxiSymFitter;
import inverters.ThreeTensorAxiSymFixMP_Fitter;
import inverters.ThreeTensorCholFitter;
import inverters.ThreeTensorCholFixMP_Fitter;
import inverters.ThreeTensorOneAxiSymFitter;
import inverters.ThreeTensorOneAxiSymFixMP_Fitter;
import inverters.ThreeTensorTwoAxiSymFitter;
import inverters.ThreeTensorTwoAxiSymFixMP_Fitter;
import misc.DT;
import optimizers.MarquardtMinimiserException;

public class ThreeTensorFitter
extends TensorModelFitter {
    protected int dt1StartIndex;
    protected int dt2StartIndex;
    protected int dt3StartIndex;
    protected int mixPar1Index;
    protected int mixPar2Index;

    public ThreeTensorFitter() {
    }

    public ThreeTensorFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.noParams = 20;
        this.dt1StartIndex = 1;
        this.dt2StartIndex = 7;
        this.dt3StartIndex = 13;
        this.mixPar1Index = 19;
        this.mixPar2Index = 20;
        this.initialize(dArray, dArray2, dArray3, n);
    }

    @Override
    protected void initAs() {
        double d = 0.333;
        double d2 = 0.333;
        double[] dArray = this.getParamArray(this.initParams1(), this.initParams2(), this.initParams3(), d, d2);
        for (int i = 0; i < dArray.length; ++i) {
            this.a[i] = dArray[i];
        }
    }

    protected double[] initParams1() {
        double d = 2.1E-9;
        DT dT = new DT(d / 3.0, 0.0, 0.0, d / 3.0, 0.0, d / 3.0);
        return this.dt1ToParams(dT);
    }

    protected double[] initParams2() {
        double d = 2.4E-9;
        DT dT = new DT(d / 3.0, 0.0, 0.0, d / 3.0, 0.0, d / 3.0);
        return this.dt2ToParams(dT);
    }

    protected double[] initParams3() {
        double d = 1.8E-9;
        DT dT = new DT(d / 3.0, 0.0, 0.0, d / 3.0, 0.0, d / 3.0);
        return this.dt3ToParams(dT);
    }

    public void setStartFromSingleDT(DT dT) {
        double[] dArray = this.getStartParamsFromSingleDT(dT);
        for (int i = 1; i <= this.noParams; ++i) {
            this.a[i] = dArray[i];
        }
    }

    protected double[] getStartParamsFromSingleDT(DT dT) {
        double[] dArray = ThreeTensorFitter.fsAndBetasThreeFromSingleDT(dT);
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[9]};
        double[] dArray3 = this.fAndBetaToParams1(dArray2);
        dArray2[0] = dArray[3];
        dArray2[1] = dArray[4];
        dArray2[2] = dArray[5];
        dArray2[3] = dArray[10];
        double[] dArray4 = this.fAndBetaToParams2(dArray2);
        dArray2[0] = dArray[6];
        dArray2[1] = dArray[7];
        dArray2[2] = dArray[8];
        dArray2[3] = dArray[11];
        double[] dArray5 = this.fAndBetaToParams3(dArray2);
        double d = 0.333;
        double d2 = 0.333;
        return this.getParamArray(dArray3, dArray4, dArray5, d, d2);
    }

    protected double[] fAndBetaToParams1(double[] dArray) {
        DT dT = ThreeTensorFitter.fAndBetaToDT(dArray);
        return this.dt1ToParams(dT);
    }

    protected double[] fAndBetaToParams2(double[] dArray) {
        DT dT = ThreeTensorFitter.fAndBetaToDT(dArray);
        return this.dt2ToParams(dT);
    }

    protected double[] fAndBetaToParams3(double[] dArray) {
        DT dT = ThreeTensorFitter.fAndBetaToDT(dArray);
        return this.dt3ToParams(dT);
    }

    protected double[] getParamArray(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2) {
        int n;
        double[] dArray4 = new double[this.noParams + 1];
        for (n = 0; n < dArray.length; ++n) {
            dArray4[this.dt1StartIndex + n] = dArray[n];
        }
        for (n = 0; n < dArray2.length; ++n) {
            dArray4[this.dt2StartIndex + n] = dArray2[n];
        }
        for (n = 0; n < dArray3.length; ++n) {
            dArray4[this.dt3StartIndex + n] = dArray3[n];
        }
        this.insertMixPars(dArray4, d, d2);
        return dArray4;
    }

    protected void insertMixPars(double[] dArray, double d, double d2) {
        dArray[this.mixPar1Index] = Math.sqrt((1.0 - d) / d);
        dArray[this.mixPar2Index] = Math.sqrt((1.0 - d - d2) / d2);
    }

    protected double[] dt1ToParams(DT dT) {
        return ThreeTensorFitter.getPosDiagParams(dT);
    }

    protected double[] dt2ToParams(DT dT) {
        return ThreeTensorFitter.getPosDiagParams(dT);
    }

    protected double[] dt3ToParams(DT dT) {
        return ThreeTensorFitter.getPosDiagParams(dT);
    }

    public DT getDT1() {
        return this.getDT1(this.a);
    }

    public DT getDT2() {
        return this.getDT2(this.a);
    }

    public DT getDT3() {
        return this.getDT3(this.a);
    }

    public double getMix1() {
        return this.getP1(this.a);
    }

    public double getMix2() {
        return this.getP2(this.a);
    }

    @Override
    protected double yfit(double[] dArray, int n) {
        double[] dArray2 = ThreeTensorFitter.getG(this.x, n);
        DT dT = this.getDT1(dArray);
        double d = Math.exp(-this.bValues[n] * dT.contractBy(dArray2));
        DT dT2 = this.getDT2(dArray);
        double d2 = Math.exp(-this.bValues[n] * dT2.contractBy(dArray2));
        DT dT3 = this.getDT3(dArray);
        double d3 = Math.exp(-this.bValues[n] * dT3.contractBy(dArray2));
        double d4 = this.getP1(dArray);
        double d5 = this.getP2(dArray);
        double d6 = d4 * d + d5 * d2 + (1.0 - d4 - d5) * d3;
        return d6;
    }

    @Override
    protected double[] dydas(double[] dArray, int n) {
        double[] dArray2 = new double[this.ma + 1];
        double[] dArray3 = ThreeTensorFitter.getG(this.x, n);
        DT dT = this.getDT1(dArray);
        double d = Math.exp(-this.bValues[n] * dT.contractBy(dArray3));
        DT dT2 = this.getDT2(dArray);
        double d2 = Math.exp(-this.bValues[n] * dT2.contractBy(dArray3));
        DT dT3 = this.getDT3(dArray);
        double d3 = Math.exp(-this.bValues[n] * dT3.contractBy(dArray3));
        double d4 = this.getP1(dArray);
        double d5 = this.getP2(dArray);
        this.insertTensorParamDerivs(dArray2, dArray, dArray3, d, d2, d3, d4, d5, this.bValues[n]);
        this.insertOtherDerivs(dArray2, dArray, d, d2, d3, d4, d5);
        boolean bl = false;
        if (bl) {
            double[] dArray4 = this.dydasNumerical(dArray, n);
            System.out.println("i = " + n);
            for (int i = 0; i < dArray2.length; ++i) {
                System.out.print(dArray[i] + " " + dArray2[i] + " " + dArray4[i] + "  :  ");
            }
            System.out.println();
        }
        return dArray2;
    }

    protected void insertTensorParamDerivs(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray4 = new double[]{dArray3[0] * dArray3[0], 2.0 * dArray3[0] * dArray3[1], 2.0 * dArray3[0] * dArray3[2], dArray3[1] * dArray3[1], 2.0 * dArray3[1] * dArray3[2], dArray3[2] * dArray3[2]};
        ThreeTensorFitter.insertPosDiagDerivs(dArray, d6, this.dt1StartIndex, dArray4, dArray2[this.dt1StartIndex], dArray2[this.dt1StartIndex + 3], dArray2[this.dt1StartIndex + 5], d4, d);
        ThreeTensorFitter.insertPosDiagDerivs(dArray, d6, this.dt2StartIndex, dArray4, dArray2[this.dt2StartIndex], dArray2[this.dt2StartIndex + 3], dArray2[this.dt2StartIndex + 5], d5, d2);
        ThreeTensorFitter.insertPosDiagDerivs(dArray, d6, this.dt3StartIndex, dArray4, dArray2[this.dt3StartIndex], dArray2[this.dt3StartIndex + 3], dArray2[this.dt3StartIndex + 5], 1.0 - d4 - d5, d3);
    }

    protected void insertOtherDerivs(double[] dArray, double[] dArray2, double d, double d2, double d3, double d4, double d5) {
        double d6 = -2.0 * dArray2[this.mixPar1Index] * (d4 * d4);
        double d7 = d5 / (1.0 - d4);
        dArray[this.mixPar1Index] = d6 * (d - d7 * d2 - (1.0 - d7) * d3);
        double d8 = (1.0 - d4) * (-2.0 * dArray2[this.mixPar2Index] * (d7 * d7));
        dArray[this.mixPar2Index] = d8 * (d2 - d3);
    }

    protected DT getDT1(double[] dArray) {
        return ThreeTensorFitter.getDT_PosDiag(dArray, this.dt1StartIndex);
    }

    protected DT getDT2(double[] dArray) {
        return ThreeTensorFitter.getDT_PosDiag(dArray, this.dt2StartIndex);
    }

    protected DT getDT3(double[] dArray) {
        return ThreeTensorFitter.getDT_PosDiag(dArray, this.dt3StartIndex);
    }

    protected double getP1(double[] dArray) {
        return ThreeTensorFitter.invX2P1(dArray[this.mixPar1Index]);
    }

    protected double getP2(double[] dArray) {
        return (1.0 - this.getP1(dArray)) * ThreeTensorFitter.invX2P1(dArray[this.mixPar2Index]);
    }

    public static ThreeTensorFitter getIndexedThreeTensorFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n, ModelIndex modelIndex) throws MarquardtMinimiserException {
        if (modelIndex == ModelIndex.CYLCYLCYL) {
            return new ThreeTensorAxiSymFitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.CYLCYLCYL_EQ) {
            return new ThreeTensorAxiSymFixMP_Fitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSPOSPOS) {
            return new ThreeTensorCholFitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSPOSPOS_EQ) {
            return new ThreeTensorCholFixMP_Fitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSPOSCYL) {
            return new ThreeTensorOneAxiSymFitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSPOSCYL_EQ) {
            return new ThreeTensorOneAxiSymFixMP_Fitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSCYLCYL) {
            return new ThreeTensorTwoAxiSymFitter(dArray, dArray2, dArray3, n);
        }
        if (modelIndex == ModelIndex.POSCYLCYL_EQ) {
            return new ThreeTensorTwoAxiSymFixMP_Fitter(dArray, dArray2, dArray3, n);
        }
        return new ThreeTensorFitter(dArray, dArray2, dArray3, n);
    }
}

