/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.DW_Scheme;
import inverters.DT_Inversion;
import inverters.LinearDT_Inversion;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import misc.LoggedException;
import numerics.RealMatrix;
import numerics.SVD_Exception;
import tools.CL_Initializer;

public class WeightedLinearDT_Inversion
extends DT_Inversion {
    protected static final double SVTHRESH = 1.0E12;
    private final LinearDT_Inversion olsInv;
    private final int numMeas;
    private final RealMatrix X;
    private final RealMatrix XT;
    private DataOutputStream noiseMap = null;
    private DataOutputStream residualVectorMap = null;
    private static final int MAX_ITERATIONS = 10;

    public WeightedLinearDT_Inversion(DW_Scheme dW_Scheme) {
        FileOutputStream fileOutputStream;
        this.ip = dW_Scheme;
        this.numMeas = this.ip.numMeasurements();
        this.X = this.ip.getB_Matrix();
        this.XT = this.X.transpose();
        this.olsInv = new LinearDT_Inversion(dW_Scheme);
        if (CL_Initializer.noiseVarianceMapFile != null) {
            try {
                fileOutputStream = new FileOutputStream(CL_Initializer.noiseVarianceMapFile);
                this.noiseMap = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x1800000));
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        if (CL_Initializer.residualVectorMapFile != null) {
            try {
                fileOutputStream = new FileOutputStream(CL_Initializer.residualVectorMapFile);
                this.residualVectorMap = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x1800000));
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        int n;
        double[] dArray2;
        double d;
        RealMatrix realMatrix;
        double[] dArray3;
        block13: {
            dArray3 = this.olsInv.invert(dArray);
            if (dArray3[0] == -100.0) {
                return dArray3;
            }
            realMatrix = null;
            RealMatrix[] realMatrixArray = null;
            d = 0.0;
            dArray2 = new double[this.numMeas];
            try {
                realMatrixArray = this.computeWeightedFit(dArray, dArray3);
                realMatrix = realMatrixArray[3];
                if (this.noiseMap != null) {
                    d = this.computeNoiseVariance(realMatrixArray);
                }
                if (this.residualVectorMap == null) break block13;
                dArray2 = this.computeResidualVector(realMatrixArray);
            }
            catch (SVD_Exception sVD_Exception) {
                realMatrix = new RealMatrix(7, 1);
                for (n = 0; n < 7; ++n) {
                    realMatrix.entries[n][0] = dArray3[n + 1];
                }
            }
        }
        if (this.noiseMap != null) {
            try {
                this.noiseMap.writeDouble(d);
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        if (this.residualVectorMap != null) {
            try {
                for (int i = 0; i < this.numMeas; ++i) {
                    this.residualVectorMap.writeDouble(dArray2[i]);
                }
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        double[] dArray4 = new double[8];
        dArray4[0] = dArray3[0];
        for (n = 0; n < 7; ++n) {
            dArray4[n + 1] = realMatrix.entries[n][0];
        }
        return dArray4;
    }

    @Override
    public void close() {
        if (this.noiseMap != null) {
            try {
                this.noiseMap.close();
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        if (this.residualVectorMap != null) {
            try {
                this.residualVectorMap.close();
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
    }

    @Override
    public void background() {
        if (this.noiseMap != null) {
            try {
                this.noiseMap.writeDouble(0.0);
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        if (this.residualVectorMap != null) {
            try {
                for (int i = 0; i < this.numMeas; ++i) {
                    this.residualVectorMap.writeDouble(0.0);
                }
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
    }

    public double[] computeResidualVector(RealMatrix[] realMatrixArray) {
        RealMatrix realMatrix = realMatrixArray[0];
        RealMatrix realMatrix2 = realMatrixArray[1];
        RealMatrix realMatrix3 = realMatrixArray[2];
        RealMatrix realMatrix4 = realMatrix2.product(realMatrix).sub(realMatrix2.product(realMatrix3));
        double[] dArray = new double[this.numMeas];
        for (int i = 0; i < this.numMeas; ++i) {
            dArray[i] = realMatrix4.entries[i][0];
        }
        return dArray;
    }

    public double computeNoiseVariance(RealMatrix[] realMatrixArray) {
        RealMatrix realMatrix = realMatrixArray[0];
        RealMatrix realMatrix2 = realMatrixArray[1];
        RealMatrix realMatrix3 = realMatrixArray[2];
        RealMatrix realMatrix4 = new RealMatrix(this.numMeas, this.numMeas);
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            realMatrix4.entries[i][i] = realMatrix2.entries[i][i] * realMatrix2.entries[i][i];
            if (realMatrix4.entries[i][i] != 0.0) continue;
            ++n;
        }
        RealMatrix realMatrix5 = realMatrix.sub(realMatrix3).transpose().product(realMatrix4).product(realMatrix.sub(realMatrix3));
        double d = realMatrix5.entries[0][0] / (double)(this.numMeas - 7 - n);
        return d;
    }

    public RealMatrix[] computeWeightedFit(double[] dArray) throws SVD_Exception {
        return this.computeWeightedFit(dArray, this.olsInv.invert(dArray));
    }

    public RealMatrix[] computeWeightedFit(double[] dArray, double[] dArray2) throws SVD_Exception {
        int n;
        double[] dArray3 = new double[this.numMeas];
        RealMatrix realMatrix = new RealMatrix(this.numMeas, 1);
        RealMatrix realMatrix2 = new RealMatrix(7, 1);
        RealMatrix realMatrix3 = new RealMatrix(this.numMeas, this.numMeas);
        for (int i = 0; i < 7; ++i) {
            realMatrix2.entries[i][0] = dArray2[i + 1];
        }
        RealMatrix realMatrix4 = this.X.product(realMatrix2);
        double d = 0.0;
        boolean[] blArray = new boolean[this.numMeas];
        int n2 = 0;
        if (dArray2[0] == 0.0) {
            for (n = 0; n < this.numMeas; ++n) {
                dArray3[n] = Math.log(dArray[n]);
                realMatrix.entries[n][0] = dArray3[n];
                realMatrix3.entries[n][n] = Math.exp(realMatrix4.entries[n][0]);
                d += (dArray3[n] - realMatrix4.entries[n][0]) * (dArray3[n] - realMatrix4.entries[n][0]);
            }
        } else {
            for (n = 0; n < this.numMeas; ++n) {
                boolean bl = blArray[n] = !(dArray[n] > 0.0);
                if (blArray[n]) {
                    ++n2;
                    dArray3[n] = 0.0;
                } else {
                    dArray3[n] = Math.log(dArray[n]);
                    d += (dArray3[n] - realMatrix4.entries[n][0]) * (dArray3[n] - realMatrix4.entries[n][0]);
                }
                realMatrix.entries[n][0] = dArray3[n];
                realMatrix3.entries[n][n] = blArray[n] ? 0.0 : Math.exp(realMatrix4.entries[n][0]);
            }
        }
        if (this.numMeas - n2 < 8) {
            throw new SVD_Exception("Insufficient data to invert WX");
        }
        double d2 = Double.MAX_VALUE;
        double d3 = 0.01;
        for (n = 0; d2 > d3 && n < 10; ++n) {
            int n3;
            RealMatrix realMatrix5 = null;
            RealMatrix[] realMatrixArray = null;
            realMatrixArray = realMatrix3.product(this.X).svd();
            double d4 = realMatrixArray[1].entry(0, 0);
            for (n3 = 0; n3 < realMatrixArray[1].rows() && n3 < realMatrixArray[1].columns(); ++n3) {
                if (!(realMatrixArray[1].entry(n3, n3) > d4)) continue;
                d4 = realMatrixArray[1].entry(n3, n3);
            }
            for (n3 = 0; n3 < realMatrixArray[1].rows() && n3 < realMatrixArray[1].columns(); ++n3) {
                double d5 = realMatrixArray[1].entry(n3, n3);
                realMatrixArray[1].setEntry(n3, n3, d5 > d4 / 1.0E12 ? 1.0 / d5 : 0.0);
            }
            realMatrix5 = realMatrixArray[2].product(realMatrixArray[1].transpose()).product(realMatrixArray[0].transpose());
            realMatrix2 = realMatrix5.product(realMatrix3.product(realMatrix));
            double d6 = 0.0;
            realMatrix4 = this.X.product(realMatrix2);
            for (int i = 0; i < this.numMeas; ++i) {
                if (!blArray[i]) {
                    d6 += (dArray3[i] - realMatrix4.entries[i][0]) * (dArray3[i] - realMatrix4.entries[i][0]);
                }
                realMatrix3.entries[i][i] = blArray[i] ? 0.0 : Math.exp(realMatrix4.entries[i][0]);
            }
            d2 = d > 0.0 ? Math.abs(d6 - d) / d : 0.0;
            d = d6;
        }
        return new RealMatrix[]{realMatrix, realMatrix3, realMatrix4, realMatrix2};
    }
}

