/*
 * Decompiled with CFR 0.152.
 */
package mesd;

import java.util.Vector;
import java.util.logging.Logger;
import mesd.SphDeconvKernels;
import misc.SphericalPoints;
import optimizers.MarquardtChiSqFitter;
import optimizers.MarquardtMinimiserException;
import sphfunc.ISCodes;
import sphfunc.MaxEntProfile;
import sphfunc.SphericalPointSet;

public class MESD_Fitter
extends MarquardtChiSqFitter {
    Logger logger = Logger.getLogger("camino." + this.getClass().getName());
    protected double[] lastATry;
    protected int lastI;
    protected double[] derivs;
    protected double yVal;
    protected double[][] xvecs;
    protected Vector<SphericalPointSet> pointSets;
    protected int psIndex = 0;
    protected double[][] testPS;
    protected double[] pxsTS;
    protected double ptAreaTS;
    protected final int testPSResolution = 350;
    protected double[] kernelParams;
    protected double ptArea;
    protected double[][] ckdx;
    protected Vector<DPSet> ckdxs;
    protected double[][] ckdxTS;
    protected double[][] kvecs;
    protected double[][] cpdx;
    protected Vector<DPSet> cpdxs;
    protected double[][] cpdxTS;
    protected double[][] pvecs;
    protected double n;
    protected double[] pxs;

    public MESD_Fitter(double[][] dArray, int n, double[] dArray2, int n2) throws MarquardtMinimiserException {
        this.n = n;
        this.kernelParams = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            this.kernelParams[i] = dArray2[i];
        }
        double[][] dArray3 = new double[dArray.length + 1][dArray[0].length];
        dArray3[0][0] = 0.0;
        dArray3[0][1] = 0.0;
        dArray3[0][2] = 0.0;
        boolean bl = false;
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i + 1][0] = dArray[i][0];
            dArray3[i + 1][1] = dArray[i][1];
            dArray3[i + 1][2] = dArray[i][2];
        }
        this.initialise(dArray3, n2);
    }

    public void setPointSet(int n) {
        this.psIndex = n;
        this.xvecs = this.pointSets.elementAt((int)n).data;
        this.ckdx = this.ckdxs.elementAt(n).getData();
        this.cpdx = this.cpdxs.elementAt(n).getData();
        this.pxs = new double[this.xvecs.length];
        this.ptArea = this.computePT_Area(this.xvecs.length);
    }

    public void reInit() {
        this.initAs();
    }

    public void newDepVals(double[] dArray) throws MarquardtMinimiserException {
        if (dArray.length != this.y.length - 2) {
            this.logger.severe("New data contains the wrong number of values." + dArray.length + " " + (this.y.length - 2));
            System.err.println(dArray.length + " " + (this.y.length - 2));
            throw new MarquardtMinimiserException("New data contains the wrong number of values.");
        }
        this.y[1] = 1.0;
        for (int i = 0; i < this.ndata - 1; ++i) {
            this.y[i + 2] = dArray[i];
        }
        this.initASigs();
        this.setPointSet(0);
    }

    protected void initialise(double[][] dArray, int n) throws MarquardtMinimiserException {
        this.initData(dArray, new double[dArray.length], n);
        this.initKVecs(dArray);
        this.initParamKVecs(MaxEntProfile.getLambdaDirs());
        this.testPS = SphericalPoints.getZPhiXs(350);
        this.pxsTS = new double[this.testPS.length];
        this.initPointSets();
        this.initASigs();
        this.setPointSet(0);
        this.lastATry = new double[this.ma + 1];
        this.derivs = new double[this.ma + 1];
    }

    protected void initASigs() {
        this.initAs();
        this.initSigs();
    }

    protected void initAs() {
        this.a[1] = -Math.log(Math.PI * 4);
        for (int i = 2; i <= this.ma; ++i) {
            this.a[i] = 0.0;
        }
    }

    protected void initSigs() {
        for (int i = 1; i <= this.ndata; ++i) {
            this.sig[i] = Math.sqrt(1.0 + this.y[i] * this.y[i] / this.n);
        }
    }

    @Override
    protected double yfit(double[] dArray, int n) {
        if (!this.sameAsLast(dArray, n)) {
            this.evaluateFunction(dArray, n);
        }
        return this.yVal;
    }

    @Override
    protected double[] dydas(double[] dArray, int n) {
        if (!this.sameAsLast(dArray, n)) {
            this.evaluateFunction(dArray, n);
        }
        return this.derivs;
    }

    @Override
    protected void mrqcof(double[] dArray, double[][] dArray2, double[] dArray3) throws MarquardtMinimiserException {
        this.computePXs(dArray);
        super.mrqcof(dArray, dArray2, dArray3);
    }

    protected void computePXs(double[] dArray) {
        for (int i = 0; i < this.xvecs.length; ++i) {
            double d = 0.0;
            for (int j = 1; j <= this.ma; ++j) {
                d += this.cpdx[j - 1][i] * dArray[j];
            }
            this.pxs[i] = this.ptArea * Math.exp(d);
        }
    }

    protected boolean sameAsLast(double[] dArray, int n) {
        boolean bl = true;
        bl &= n == this.lastI;
        for (int i = 1; i < dArray.length; ++i) {
            bl &= dArray[i] == this.lastATry[i];
        }
        return bl;
    }

    protected void evaluateFunction(double[] dArray, int n) {
        int n2;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.lastATry[n2] = dArray[n2];
        }
        this.lastI = n;
        for (n2 = 0; n2 < this.derivs.length; ++n2) {
            this.derivs[n2] = 0.0;
        }
        this.yVal = 0.0;
        for (n2 = 0; n2 < this.xvecs.length; ++n2) {
            double d = this.pxs[n2] * this.ckdx[n - 1][n2];
            this.yVal += d;
            for (int i = 1; i <= this.ma; ++i) {
                int n3 = i;
                this.derivs[n3] = this.derivs[n3] + this.cpdx[i - 1][n2] * d;
            }
        }
    }

    protected void initKVecs(double[][] dArray) {
        this.kvecs = new double[this.ndata][3];
        for (int i = 0; i < this.ndata; ++i) {
            this.kvecs[i][0] = dArray[i][0];
            this.kvecs[i][1] = dArray[i][1];
            this.kvecs[i][2] = dArray[i][2];
        }
    }

    protected void initParamKVecs(double[][] dArray) {
        if (dArray.length != this.ma - 1) {
            this.logger.severe("length of lambda summation array passed to initialiseris not of proscribed length! ma = " + this.ma + " but length is " + dArray.length);
            throw new RuntimeException("length of lambda summation array passed to initialiseris not of proscribed length! ma = " + this.ma + " but length is " + dArray.length);
        }
        this.pvecs = new double[this.ma][3];
        for (int i = 0; i < this.pvecs.length - 1; ++i) {
            this.pvecs[i + 1][0] = dArray[i][0];
            this.pvecs[i + 1][1] = dArray[i][1];
            this.pvecs[i + 1][2] = dArray[i][2];
        }
    }

    protected void initPointSets() {
        Object object;
        Object object2;
        int n;
        this.pointSets = new Vector();
        this.ckdxs = new Vector();
        this.cpdxs = new Vector();
        for (n = 0; n < ISCodes.getNoPointSetsForMaxEnt(); ++n) {
            try {
                SphericalPointSet sphericalPointSet = ISCodes.getPointSetForMaxEnt(n);
                this.pointSets.addElement(sphericalPointSet);
                object2 = new double[this.ndata][sphericalPointSet.data.length];
                object = new double[this.ma][sphericalPointSet.data.length];
                for (int i = 0; i < sphericalPointSet.data.length; ++i) {
                    double[] dArray;
                    double[] dArray2;
                    int n2;
                    for (n2 = 0; n2 < this.ndata; ++n2) {
                        dArray2 = this.kvecs[n2];
                        dArray = sphericalPointSet.data[i];
                        object2[n2][i] = SphDeconvKernels.kernel(dArray2, dArray, this.kernelParams);
                    }
                    for (n2 = 0; n2 < this.ma; ++n2) {
                        dArray2 = this.pvecs[n2];
                        dArray = sphericalPointSet.data[i];
                        object[n2][i] = SphDeconvKernels.kernel(dArray2, dArray, this.kernelParams);
                    }
                }
                this.ckdxs.addElement(new DPSet((double[][])object2));
                this.cpdxs.addElement(new DPSet((double[][])object));
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.ckdxTS = new double[this.ndata][this.testPS.length];
        this.cpdxTS = new double[this.ma][this.testPS.length];
        for (n = 0; n < this.testPS.length; ++n) {
            int n3;
            for (n3 = 0; n3 < this.ndata; ++n3) {
                object2 = this.kvecs[n3];
                object = this.testPS[n];
                this.ckdxTS[n3][n] = SphDeconvKernels.kernel((double[])object2, (double[])object, this.kernelParams);
            }
            for (n3 = 0; n3 < this.ma; ++n3) {
                object2 = this.pvecs[n3];
                object = this.testPS[n];
                this.cpdxTS[n3][n] = SphDeconvKernels.kernel((double[])object2, (double[])object, this.kernelParams);
            }
        }
        this.ptAreaTS = this.computePT_Area(this.testPS.length);
    }

    protected double computePT_Area(int n) {
        return Math.PI * 4 / (double)n;
    }

    public double[] integrationErrorStats() {
        int n;
        for (int i = 0; i < this.testPS.length; ++i) {
            double d = 0.0;
            for (int j = 1; j <= this.ma; ++j) {
                d += this.cpdxTS[j - 1][i] * this.a[j];
            }
            this.pxsTS[i] = this.ptAreaTS * Math.exp(d);
        }
        double[][] dArray = new double[this.ndata][this.ndata + 1];
        double[][] dArray2 = new double[this.ndata][this.ndata + 1];
        for (int i = 1; i <= this.ndata; ++i) {
            int n2;
            double[] dArray3 = new double[this.ndata + 1];
            for (n2 = 0; n2 < this.testPS.length; ++n2) {
                double d = this.pxsTS[n2] * this.ckdxTS[i - 1][n2];
                double[] dArray4 = dArray[i - 1];
                dArray4[0] = dArray4[0] + d;
                dArray3[0] = dArray3[0] > d ? dArray3[0] : d;
                for (n = 1; n <= this.ma; ++n) {
                    double d2 = this.cpdxTS[n - 1][n2] * d;
                    double[] dArray5 = dArray[i - 1];
                    int n3 = n;
                    dArray5[n3] = dArray5[n3] + d2;
                    dArray3[n] = dArray3[n] > d2 ? dArray3[n] : d2;
                }
            }
            n2 = 0;
            while (n2 <= this.ndata) {
                int n4 = n2++;
                dArray3[n4] = dArray3[n4] / this.ptAreaTS;
            }
            for (n2 = 0; n2 <= this.ndata; ++n2) {
                dArray2[i - 1][n2] = Math.sqrt(dArray[i - 1][n2] / dArray3[n2]);
            }
        }
        this.computePXs(this.a);
        double[][] dArray6 = new double[this.ndata][this.ndata + 1];
        for (int i = 1; i <= this.ndata; ++i) {
            double[] dArray7 = this.computeFIntegralDerivs(i);
            for (int j = 0; j < dArray7.length; ++j) {
                dArray6[i - 1][j] = dArray7[j];
            }
        }
        double d = 0.0;
        double d3 = 0.0;
        for (n = 0; n < dArray6.length; ++n) {
            for (int i = 0; i < dArray6[0].length; ++i) {
                double d4 = Math.abs(dArray6[n][i] - dArray[n][i]) / dArray[n][i];
                double d5 = this.estimateErrors350(dArray2[n][i]);
                d = d4 > d ? d4 : d;
                d3 = d5 > d3 ? d5 : d3;
            }
        }
        double[] dArray8 = new double[]{d, d3};
        return dArray8;
    }

    protected double[] computeFIntegralDerivs(int n) {
        double[] dArray = new double[this.ndata + 1];
        for (int i = 0; i < this.xvecs.length; ++i) {
            double d = this.pxs[i] * this.ckdx[n - 1][i];
            dArray[0] = dArray[0] + d;
            for (int j = 1; j <= this.ma; ++j) {
                int n2 = j;
                dArray[n2] = dArray[n2] + d * this.cpdx[j - 1][i];
            }
        }
        return dArray;
    }

    protected double estimateErrors350(double d) {
        double d2 = -3.06354;
        double d3 = -12.3513;
        double d4 = Math.exp(d2 * Math.log(d) + d3);
        return d4;
    }

    protected class DPSet {
        private double[][] data;

        public DPSet(double[][] dArray) {
            this.data = dArray;
        }

        public double[][] getData() {
            return this.data;
        }
    }
}

