/*
 * Decompiled with CFR 0.152.
 */
package models;

import imaging.DW_Scheme;
import numerics.NumDeriv;
import numerics.RealMatrix;

public abstract class ParametricModel {
    private final int numParams;

    public ParametricModel(int n) {
        this.numParams = n;
    }

    public abstract RealMatrix getSignals(double[] var1, DW_Scheme var2);

    public abstract double getSignal(double[] var1, DW_Scheme var2, int var3);

    public RealMatrix getJacobian_old(double[] dArray, final DW_Scheme dW_Scheme) {
        int n;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), dArray.length);
        final double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = dArray[n];
        }
        for (n = 0; n < dW_Scheme.numMeasurements(); ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                final int n2 = n;
                final int n3 = i;
                NumDeriv numDeriv = new NumDeriv(){

                    @Override
                    protected float func(float f) {
                        dArray2[n3] = f;
                        float f2 = (float)ParametricModel.this.getSignal(dArray2, dW_Scheme, n2);
                        return f2;
                    }
                };
                float[] fArray = new float[1];
                realMatrix.entries[n2][n3] = numDeriv.dfridr((float)dArray[n3], dArray[n3] != 0.0 ? 0.1f * (float)dArray[n3] : 0.1f, fArray);
                dArray2[n3] = dArray[n3];
            }
        }
        return realMatrix;
    }

    public RealMatrix getJacobian(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            RealMatrix realMatrix2 = this.getJacobian(dArray, dW_Scheme, i);
            for (int j = 0; j < dW_Scheme.numMeasurements(); ++j) {
                realMatrix.setEntry(j, i, realMatrix2.entry(j, i));
            }
        }
        return realMatrix;
    }

    public RealMatrix getJacobian(double[] dArray, final DW_Scheme dW_Scheme, int n) {
        int n2;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), dArray.length);
        final double[] dArray2 = new double[dArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < dW_Scheme.numMeasurements(); ++n2) {
            final int n3 = n2;
            final int n4 = n;
            NumDeriv numDeriv = new NumDeriv(){

                @Override
                protected float func(float f) {
                    dArray2[n4] = f;
                    float f2 = (float)ParametricModel.this.getSignal(dArray2, dW_Scheme, n3);
                    return f2;
                }
            };
            float[] fArray = new float[1];
            realMatrix.entries[n3][n4] = numDeriv.dfridr((float)dArray[n4], dArray[n4] != 0.0 ? 0.1f * (float)dArray[n4] : 0.1f, fArray);
            dArray2[n4] = dArray[n4];
        }
        return realMatrix;
    }

    public final int numParams() {
        return this.numParams;
    }
}

