/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import imaging.StejskalTannerScheme;
import misc.LoggedException;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.ErrorFunction;
import numerics.ErrorFunctionException;
import numerics.RealMatrix;

public class Astrosticks
extends ParametricModel {
    private final double GAMMA = 2.6751525E8;

    public Astrosticks() {
        super(CompartmentType.ASTROSTICKS.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        StejskalTannerScheme stejskalTannerScheme;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to cylinder compartment is not a StejskalTanner sequence");
        }
        for (int i = 0; i < stejskalTannerScheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, stejskalTannerScheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        StejskalTannerScheme stejskalTannerScheme;
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to astrostick compartment is not a StejskalTanner sequence");
        }
        return this.getSignal(dArray, stejskalTannerScheme, n);
    }

    private final double getSignal(double[] dArray, StejskalTannerScheme stejskalTannerScheme, int n) {
        double d;
        if (stejskalTannerScheme.zero(n)) {
            return 1.0;
        }
        double d2 = stejskalTannerScheme.getModG(n);
        double d3 = stejskalTannerScheme.getB_Value(n);
        double d4 = 0.0;
        double d5 = -d3 / (d2 * d2) * dArray[0];
        try {
            d = Math.sqrt(Math.PI) * 1.0 / (2.0 * d2 * Math.sqrt(d4 - d5)) * Math.exp(d2 * d2 * d4) * ErrorFunction.erf(d2 * Math.sqrt(d4 - d5));
        }
        catch (ErrorFunctionException errorFunctionException) {
            throw new LoggedException(errorFunctionException);
        }
        return d;
    }
}

