/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import imaging.StejskalTannerScheme;
import java.util.logging.Logger;
import misc.LoggedException;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.RealMatrix;

public class SphereGPD
extends ParametricModel {
    private final double GAMMA = 2.6751525E8;
    protected static Logger logger = Logger.getLogger("camino.models.compartments.CylinderGPD");
    private double REQPREC = 1.0E-7;
    private double lastDelta = 0.0;
    private double lastDELTA = 0.0;
    private double lastDiff = 0.0;
    private double lastR = 0.0;
    private double lastSum = 0.0;
    double[] am = new double[]{2.0815759778181, 5.94036999057271, 9.20584014293667, 12.404445021902, 15.5792364103872, 18.7426455847748, 21.8996964794928, 25.052825280993, 28.2033610039524, 31.3520917265645, 34.499514921367, 37.6459603230864, 40.7916552312719, 43.9367614714198, 47.0813974121542, 50.2256516491831, 53.3695918204908, 56.5132704621986, 59.6567290035279, 62.8000005565198, 65.9431119046553, 69.0860849466452, 72.2289377620154, 75.3716854092873, 78.5143405319308, 81.6569138240367, 84.7994143922025, 87.9418500396598, 91.0842274914688, 94.2265525745684, 97.368830362901, 100.511065295271, 103.653261271734, 106.795421732944, 109.937549725876, 113.079647958579, 116.221718846033, 116.221718846033, 119.363764548757, 122.505787005472, 125.647787960854, 128.789768989223, 131.931731514843, 135.073676829384, 138.215606107009, 141.357520417437, 144.499420737305, 147.641307960079, 150.783182904724, 153.925046323312, 157.066898907715, 166.492397790874, 169.634212946261, 172.776020008465, 175.917819411203, 179.059611557741, 182.201396823524, 185.343175558534, 188.484948089409, 191.626714721361};

    public SphereGPD() {
        super(CompartmentType.SPHEREGPD.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        StejskalTannerScheme stejskalTannerScheme;
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to sphere compartment is not a StejskalTanner sequence");
        }
        for (int i = 0; i < stejskalTannerScheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, stejskalTannerScheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        StejskalTannerScheme stejskalTannerScheme;
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("scheme object passed to sphere compartment is not a StejskalTanner sequence");
        }
        return this.getSignal(dArray, stejskalTannerScheme, n);
    }

    private double getSignal(double[] dArray, StejskalTannerScheme stejskalTannerScheme, int n) {
        if (stejskalTannerScheme.zero(n)) {
            return 1.0;
        }
        double d = stejskalTannerScheme.getDELTA(n);
        double d2 = stejskalTannerScheme.getDelta(n);
        double d3 = stejskalTannerScheme.getModG(n);
        double[] dArray2 = stejskalTannerScheme.getG_Dir(n);
        double[] dArray3 = new double[3];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray2[i] * d3;
        }
        return this.getSignal(dArray, d2, d, dArray3);
    }

    public double getSignal(double[] dArray, double d, double d2, double[] dArray2) {
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = d2 - d / 3.0;
        double d6 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d6 += dArray2[i] * dArray2[i];
        }
        d6 = Math.sqrt(d6);
        double[] dArray3 = new double[this.am.length];
        for (int i = 0; i < this.am.length; ++i) {
            dArray3[i] = this.am[i] / d4;
        }
        double d7 = this.computeGPD_Sum(dArray3, d, d2, d3, d4);
        double d8 = Math.exp(-1.43128817965125E17 * d6 * d6 * d7);
        return d8;
    }

    protected double computeGPD_Sum(double[] dArray, double d, double d2, double d3, double d4) {
        int n;
        if (this.lastDelta == d && this.lastDELTA == d2 && this.lastDiff == d3 && this.lastR == d4) {
            return this.lastSum;
        }
        double d5 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            double d6;
            double d7 = d3 * dArray[n] * dArray[n];
            double d8 = -d7 * d;
            double d9 = -d7 * d2;
            double d10 = d2 - d;
            double d11 = -d7 * d10;
            double d12 = d2 + d;
            double d13 = -d7 * d12;
            double d14 = 2.0 * d7 * d - 2.0 + 2.0 * Math.exp(d8) + 2.0 * Math.exp(d9) - Math.exp(d11) - Math.exp(d13);
            double d15 = d14 / (d6 = d7 * d7 * dArray[n] * dArray[n] * (d4 * d4 * dArray[n] * dArray[n] - 2.0));
            if (d15 < this.REQPREC * (d5 += d15)) break;
        }
        if (n == dArray.length) {
            logger.warning("Last term in SphereGPD sum greater than " + this.REQPREC + " times sum.  May lack precision. R=" + d4 + ". diff=" + d3 + ". delta=" + d + ". DELTA=" + d2 + ".");
        }
        this.lastDelta = d;
        this.lastDELTA = d2;
        this.lastDiff = d3;
        this.lastR = d4;
        this.lastSum = d5;
        return d5;
    }
}

