/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.RealMatrix;

public class Stick
extends ParametricModel {
    public Stick() {
        super(CompartmentType.STICK.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), 1);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, dW_Scheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d3);
        double d7 = Math.cos(d3);
        double[] dArray2 = new double[]{d7 * d4, d6 * d4, d5};
        double d8 = dW_Scheme.getB_Value(n);
        double[] dArray3 = dW_Scheme.getG_Dir(n);
        double d9 = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1] + dArray2[2] * dArray3[2];
        double d10 = Math.exp(-d8 * d * d9 * d9);
        return d10;
    }

    @Override
    public RealMatrix getJacobian(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), dArray.length);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d3);
        double d7 = Math.cos(d3);
        double[] dArray2 = new double[]{d7 * d4, d6 * d4, d5};
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            double d8 = dW_Scheme.getB_Value(i);
            double[] dArray3 = dW_Scheme.getG_Dir(i);
            double d9 = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1] + dArray2[2] * dArray3[2];
            double d10 = Math.exp(-d8 * d * d9 * d9);
            realMatrix.setEntry(i, 0, -d8 * d9 * d9 * d10);
            double d11 = -2.0 * d8 * d * d9 * d10;
            realMatrix.setEntry(i, 1, d11 * (dArray3[0] * d5 * d7 + dArray3[1] * d5 * d6 - dArray3[2] * d4));
            realMatrix.setEntry(i, 2, d11 * (dArray3[1] * d4 * d7 - dArray3[0] * d4 * d6));
        }
        return realMatrix;
    }
}

