/*
 * Decompiled with CFR 0.152.
 */
package models.compartments;

import imaging.DW_Scheme;
import imaging.StejskalTannerScheme;
import misc.LoggedException;
import models.ParametricModel;
import models.compartments.CompartmentType;
import numerics.RealMatrix;
import numerics.Vector3D;

public class Tensor
extends ParametricModel {
    public Tensor() {
        super(CompartmentType.TENSOR.numParams);
    }

    @Override
    public RealMatrix getSignals(double[] dArray, DW_Scheme dW_Scheme) {
        StejskalTannerScheme stejskalTannerScheme;
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("Tensor compartment model assumes Stejskal Tanner schemes but was passed something else");
        }
        RealMatrix realMatrix = new RealMatrix(stejskalTannerScheme.numMeasurements(), 1);
        for (int i = 0; i < stejskalTannerScheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, this.getSignal(dArray, stejskalTannerScheme, i));
        }
        return realMatrix;
    }

    @Override
    public double getSignal(double[] dArray, DW_Scheme dW_Scheme, int n) {
        StejskalTannerScheme stejskalTannerScheme;
        try {
            stejskalTannerScheme = (StejskalTannerScheme)dW_Scheme;
        }
        catch (ClassCastException classCastException) {
            throw new LoggedException("Tensor compartment model assumes Stejskal Tanner schemes but was passed something else");
        }
        return this.getSignal(dArray, stejskalTannerScheme, n);
    }

    private double getSignal(double[] dArray, StejskalTannerScheme stejskalTannerScheme, int n) {
        double d = dArray[1];
        double d2 = dArray[2];
        double d3 = dArray[5];
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        double d6 = Math.sin(d2);
        double d7 = Math.cos(d2);
        double[] dArray2 = new double[]{d7 * d4, d6 * d4, d5};
        Vector3D vector3D = new Vector3D(dArray2);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, d + 1.5707963267948966, d2);
        Vector3D vector3D3 = vector3D2.rotate(d3, vector3D);
        Vector3D vector3D4 = vector3D.cross(vector3D3);
        double d8 = stejskalTannerScheme.getB_Value(n);
        double[] dArray3 = stejskalTannerScheme.getG_Dir(n);
        double d9 = vector3D.x * dArray3[0] + vector3D.y * dArray3[1] + vector3D.z * dArray3[2];
        double d10 = vector3D3.x * dArray3[0] + vector3D3.y * dArray3[1] + vector3D3.z * dArray3[2];
        double d11 = vector3D4.x * dArray3[0] + vector3D4.y * dArray3[1] + vector3D4.z * dArray3[2];
        double d12 = dArray[0];
        double d13 = dArray[3];
        double d14 = dArray[4];
        double d15 = Math.exp(-d8 * (d12 * d9 * d9 + d13 * d10 * d10 + d14 * d11 * d11));
        return d15;
    }

    @Override
    public RealMatrix getJacobian(double[] dArray, DW_Scheme dW_Scheme) {
        RealMatrix realMatrix = new RealMatrix(dW_Scheme.numMeasurements(), dArray.length);
        RealMatrix realMatrix2 = super.getJacobian(dArray, dW_Scheme, 0);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 0, realMatrix2.entry(i, 0));
        }
        double d = dArray[1];
        if (d < 1.0E-6) {
            dArray[1] = 1.0E-6;
        }
        RealMatrix realMatrix3 = super.getJacobian(dArray, dW_Scheme, 1);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 1, realMatrix3.entry(i, 1));
        }
        RealMatrix realMatrix4 = super.getJacobian(dArray, dW_Scheme, 2);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 2, d > 1.0E-6 ? realMatrix4.entry(i, 2) : 1.0);
        }
        RealMatrix realMatrix5 = super.getJacobian(dArray, dW_Scheme, 3);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 3, realMatrix5.entry(i, 3));
        }
        RealMatrix realMatrix6 = super.getJacobian(dArray, dW_Scheme, 4);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 4, realMatrix6.entry(i, 4));
        }
        RealMatrix realMatrix7 = super.getJacobian(dArray, dW_Scheme, 5);
        for (int i = 0; i < dW_Scheme.numMeasurements(); ++i) {
            realMatrix.setEntry(i, 5, realMatrix7.entry(i, 5));
        }
        return realMatrix;
    }
}

