/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import misc.LoggedException;

public class GammaFunctions {
    public static final double EULERGAMMA = 0.5772156649;
    private static final int ITMAX = 100;
    private static final double EPS = 3.0E-7;
    private static final double FPMIN = 1.0E-30;

    public static double gammln(double d) {
        double d2;
        double[] dArray = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double d3 = d2 = d;
        double d4 = d2 + 5.5;
        d4 -= (d2 + 0.5) * Math.log(d4);
        double d5 = 1.000000000190015;
        for (int i = 0; i <= 5; ++i) {
            d5 += dArray[i] / (d3 += 1.0);
        }
        return -d4 + Math.log(2.5066282746310007 * d5 / d2);
    }

    public static double gammp(double d, double d2) {
        if (d2 < 0.0 || d <= 0.0) {
            throw new LoggedException("Invalid args in incomplete gamma function");
        }
        if (d2 < d + 1.0) {
            return GammaFunctions.gser(d, d2);
        }
        return 1.0 - GammaFunctions.gcf(d, d2);
    }

    private static double gser(double d, double d2) {
        double d3;
        double d4 = GammaFunctions.gammln(d);
        if (d2 <= 0.0) {
            if (d2 < 0.0) {
                throw new LoggedException("x less than 0 in routine gser");
            }
            return 0.0;
        }
        double d5 = d;
        double d6 = d3 = 1.0 / d;
        for (int i = 1; i <= 100; ++i) {
            d3 += (d6 *= d2 / (d5 += 1.0));
            if (!(Math.abs(d6) < Math.abs(d3) * 3.0E-7)) continue;
            return d3 * Math.exp(-d2 + d * Math.log(d2) - d4);
        }
        throw new LoggedException("a too large, ITMAX too small in routine gser");
    }

    private static double gcf(double d, double d2) {
        int n;
        double d3;
        double d4 = GammaFunctions.gammln(d);
        double d5 = d2 + 1.0 - d;
        double d6 = 9.999999999999999E29;
        double d7 = d3 = 1.0 / d5;
        for (n = 1; n <= 100; ++n) {
            double d8 = (double)(-n) * ((double)n - d);
            if (Math.abs(d3 = d8 * d3 + (d5 += 2.0)) < 1.0E-30) {
                d3 = 1.0E-30;
            }
            if (Math.abs(d6 = d5 + d8 / d6) < 1.0E-30) {
                d6 = 1.0E-30;
            }
            d3 = 1.0 / d3;
            double d9 = d3 * d6;
            d7 *= d9;
            if (Math.abs(d9 - 1.0) < 3.0E-7) break;
        }
        if (n > 100) {
            throw new LoggedException("a too large, ITMAX too small in gcf");
        }
        return Math.exp(-d2 + d * Math.log(d2) - d4) * d7;
    }
}

