/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.ConvergenceException;
import numerics.SVAnalyticalFunction;

public class NewtonRaphsonSolver {
    public static double solve(SVAnalyticalFunction sVAnalyticalFunction, double d, double d2, double d3) throws ConvergenceException {
        SVAnalyticalFunction sVAnalyticalFunction2 = sVAnalyticalFunction.differentiated();
        double d4 = Double.MAX_VALUE;
        int n = 0;
        double d5 = d2;
        double d6 = 0.0;
        while (d4 > d3) {
            double d7 = sVAnalyticalFunction2.evaluate(d5);
            d6 = d5 - (sVAnalyticalFunction.evaluate(d5) - d) / d7;
            if (Double.isNaN(d6)) {
                throw new ConvergenceException("xi is NaN, probable divergence");
            }
            if (Double.isInfinite(d6)) {
                throw new ConvergenceException("xi is Infinite, probable divergence");
            }
            d4 = Math.abs((d6 - d5) / d6) * 100.0;
            if (n++ > 9999) {
                throw new ConvergenceException("Couldn't converge -- try a different x0");
            }
            d5 = d6;
        }
        return d5;
    }
}

