/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import data.VoxelOrderDataSource;
import misc.LoggedException;
import numerics.PolynomialFunction1D;
import numerics.PolynomialFunction2D;

public abstract class PolynomialFunction {
    public abstract double evaluate(double[] var1);

    public static PolynomialFunction[] readFunctions(String string) {
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, 1, "double");
        int n = (int)voxelOrderDataSource.nextVoxel()[0];
        if (n == 1) {
            return PolynomialFunction1D.readFunctions(string);
        }
        if (n == 2) {
            return PolynomialFunction2D.readFunctions(string);
        }
        throw new LoggedException("Cannot create function with " + n + " variables");
    }

    public abstract int variables();
}

