/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.Arrays;
import numerics.ConvergenceException;
import numerics.EigenSystem3D;
import numerics.NewtonRaphsonSolver;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.SphericalDistributionFitter;
import numerics.Vector3D;
import numerics.WatsonD;
import numerics.WatsonDistribution;

public class WatsonFitter
extends SphericalDistributionFitter {
    public static double testBipolarRotSymm(EigenSystem3D eigenSystem3D, Vector3D vector3D, Vector3D[] vector3DArray) {
        double d = 0.0;
        double d2 = vector3DArray.length;
        for (int i = 0; i < vector3DArray.length; ++i) {
            d += 1.0 / d2 * Math.pow(vector3D.dot(vector3DArray[i]), 4.0);
        }
        double d3 = 2.0 * d2 * Math.pow(eigenSystem3D.eigenvalues[1] - eigenSystem3D.eigenvalues[2], 2.0) / (1.0 - 2.0 * eigenSystem3D.eigenvalues[0] + d);
        return d3;
    }

    public static double getBipolarConfidenceCone(EigenSystem3D eigenSystem3D, Vector3D[] vector3DArray, double d) {
        double d2 = 0.0;
        Vector3D vector3D = eigenSystem3D.eigenvectors[0];
        double d3 = vector3DArray.length;
        for (int i = 0; i < vector3DArray.length; ++i) {
            d2 += 1.0 / d3 * Math.pow(vector3D.dot(vector3DArray[i]), 4.0);
        }
        if (eigenSystem3D.eigenvalues[0] < d2) {
            d2 = eigenSystem3D.eigenvalues[0];
        }
        double d4 = Math.sqrt((eigenSystem3D.eigenvalues[0] - d2) / d3) / (eigenSystem3D.eigenvalues[0] - eigenSystem3D.eigenvalues[1]);
        double d5 = Math.sqrt(-Math.log(d)) * d4;
        if (Math.abs(d5) > 1.0) {
            d5 = 1.0;
        }
        double d6 = Math.asin(d5);
        return d6;
    }

    public static double testGirdleRotSymm(EigenSystem3D eigenSystem3D, Vector3D vector3D, Vector3D[] vector3DArray) {
        double d = 0.0;
        double d2 = vector3DArray.length;
        for (int i = 0; i < vector3DArray.length; ++i) {
            d += 1.0 / d2 * Math.pow(vector3D.dot(vector3DArray[i]), 4.0);
        }
        return 2.0 * d2 * Math.pow(eigenSystem3D.eigenvalues[0] - eigenSystem3D.eigenvalues[1], 2.0) / (1.0 - 2.0 * eigenSystem3D.eigenvalues[2] + d);
    }

    public static double kuiperTest(Vector3D vector3D, Vector3D[] vector3DArray) {
        int n;
        double d;
        double d2 = 0.0;
        double d3 = vector3DArray.length;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        double[] dArray = new double[vector3DArray.length];
        RealMatrix realMatrix = Rotations.getRotMat(vector3D, new Vector3D(0.0, 0.0, 1.0));
        for (int i = 0; i < vector3DArray.length; ++i) {
            Vector3D vector3D2 = Rotations.rotateVector(vector3DArray[i], realMatrix);
            d = 0.0;
            d = vector3D2.x == 0.0 ? (vector3D2.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : (vector3D2.x < 0.0 ? Math.PI + Math.atan(vector3D2.y / vector3D2.x) : Math.atan(vector3D2.y / vector3D2.x));
            dArray[i] = d / (Math.PI * 2);
        }
        Arrays.sort(dArray);
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < vector3DArray.length; ++n) {
            dArray2[n] = dArray[n];
        }
        for (n = 0; n < vector3DArray.length; ++n) {
            double d6;
            d = ((double)n + 1.0) / d3 - dArray2[n];
            if (d > d4) {
                d4 = d;
            }
            if (!((d6 = dArray2[n] - (double)n / d3) > d5)) continue;
            d5 = d6;
        }
        d2 = d4 + d5;
        return d2 * (Math.sqrt(d3) + 0.155 + 0.24 / Math.sqrt(d3));
    }

    public static double fitKappa(Vector3D[] vector3DArray) {
        EigenSystem3D eigenSystem3D = WatsonFitter.tBarEigenSystem(vector3DArray);
        return WatsonFitter.fitKappa(eigenSystem3D, vector3DArray);
    }

    public static double fitKappa(EigenSystem3D eigenSystem3D, Vector3D[] vector3DArray) {
        WatsonD watsonD = new WatsonD();
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            d = NewtonRaphsonSolver.solve(watsonD, eigenSystem3D.eigenvalues[0], 0.0, 1.0E-5);
            bl = true;
        }
        catch (ConvergenceException convergenceException) {
            // empty catch block
        }
        try {
            d2 = NewtonRaphsonSolver.solve(watsonD, eigenSystem3D.eigenvalues[2], 0.0, 1.0E-5);
            bl2 = true;
        }
        catch (ConvergenceException convergenceException) {
            // empty catch block
        }
        if (bl && bl2) {
            double d3;
            double d4 = WatsonDistribution.sumLogPDF(eigenSystem3D.eigenvectors[0], vector3DArray, d);
            if (d4 > (d3 = WatsonDistribution.sumLogPDF(eigenSystem3D.eigenvectors[2], vector3DArray, d2)) || eigenSystem3D.eigenvalues[0] > 0.95) {
                return d;
            }
            return d2;
        }
        if (bl) {
            return d;
        }
        if (bl2) {
            return d2;
        }
        return 0.0;
    }

    public static double fitKappa(EigenSystem3D eigenSystem3D) {
        WatsonD watsonD = new WatsonD();
        double d = 0.0;
        double d2 = eigenSystem3D.eigenvalues[0];
        if (Math.abs(eigenSystem3D.eigenvalues[0] - eigenSystem3D.eigenvalues[1]) < Math.abs(eigenSystem3D.eigenvalues[1] - eigenSystem3D.eigenvalues[2])) {
            d2 = eigenSystem3D.eigenvalues[2];
        }
        try {
            d = NewtonRaphsonSolver.solve(watsonD, d2, 0.0, 1.0E-5);
        }
        catch (ConvergenceException convergenceException) {
            return 0.0;
        }
        return d;
    }

    public static double fitKappa(double d) throws ConvergenceException {
        WatsonD watsonD = new WatsonD();
        double d2 = 0.0;
        d2 = NewtonRaphsonSolver.solve(watsonD, d, 0.0, 1.0E-5);
        return d2;
    }

    public static double ksTest(Vector3D[] vector3DArray, Vector3D vector3D, double d) {
        int n;
        double d2 = 0.0;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        int n2 = vector3DArray.length;
        double d5 = n2;
        double[] dArray = new double[n2];
        if (d > 0.0) {
            for (n = 0; n < n2; ++n) {
                dArray[n] = 1.0 - Math.pow(vector3DArray[n].dot(vector3D), 2.0);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                dArray[n] = Math.pow(vector3DArray[n].dot(vector3D), 2.0);
            }
        }
        Arrays.sort(dArray);
        for (n = 0; n < n2; ++n) {
            double d6;
            double d7 = 1.0 - Math.exp(-1.0 * d * dArray[n]);
            double d8 = ((double)n + 1.0) / d5 - d7;
            if (d8 > d3) {
                d3 = d8;
            }
            if (!((d6 = d7 - (double)n / d5) > d4)) continue;
            d4 = d6;
        }
        d2 = d3 >= d4 ? d3 : d4;
        if (d > 0.0) {
            return (d2 - 0.2 / d5) * (Math.sqrt(d5) + 0.26 + 0.5 / Math.sqrt(d5));
        }
        return d2 * (Math.sqrt(d5) - 0.04 + 0.7 / Math.sqrt(d5));
    }
}

