/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import imaging.DW_Scheme;
import java.util.logging.Logger;
import models.ParametricModel;
import numerics.NumDeriv;
import numerics.RealMatrix;
import optimizers.MarquardtMinimiser;
import optimizers.MarquardtMinimiserException;
import optimizers.MarquardtMinimiserNonConvergenceException;
import optimizers.Minimizer;

public abstract class LM_Minimizer
extends MarquardtMinimiser
implements Minimizer {
    private static Logger logger = Logger.getLogger("optimizers.LM_Minimizer");
    protected DW_Scheme scheme;
    protected ParametricModel model;
    protected Codec codec;
    protected double[] sig;
    protected double[] measurements;
    protected int exitcode;

    @Override
    public double[][] getSolutions() {
        double[] dArray = new double[this.a.length - 1];
        for (int i = 0; i < this.a.length - 1; ++i) {
            dArray[i] = this.a[i + 1];
        }
        double d = this.fObj(this.a, new double[this.a.length], new double[this.a.length][this.a.length]);
        double[][] dArray2 = new double[1][this.codec.getNumModelParams() + 2];
        double[] dArray3 = this.codec.optToModel(dArray);
        dArray2[0][0] = this.exitcode;
        for (int i = 0; i < dArray3.length; ++i) {
            dArray2[0][i + 1] = dArray3[i];
        }
        dArray2[0][dArray2[0].length - 1] = d;
        return dArray2;
    }

    @Override
    public int getNumSolutions() {
        return 1;
    }

    @Override
    public int getNumParameters() {
        return this.model.numParams() + 2;
    }

    @Override
    public void minimise() throws MarquardtMinimiserException {
        this.exitcode = 0;
        try {
            super.minimise();
        }
        catch (MarquardtMinimiserNonConvergenceException marquardtMinimiserNonConvergenceException) {
            logger.warning(marquardtMinimiserNonConvergenceException.toString());
            this.exitcode = 3;
        }
        catch (Exception exception) {
            logger.warning(exception.toString());
            this.exitcode = 2;
        }
    }

    @Override
    public void setMeasurements(double[] dArray) throws MarquardtMinimiserException {
        if (dArray.length != this.scheme.numMeasurements()) {
            throw new MarquardtMinimiserException("New data contains the wrong number of values: " + dArray.length + " instead of " + this.measurements.length + ".");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.measurements[i] = dArray[i];
        }
    }

    protected RealMatrix numericalOptJac(double[] dArray) {
        int n;
        RealMatrix realMatrix = new RealMatrix(this.scheme.numMeasurements(), dArray.length);
        final double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = dArray[n];
        }
        for (n = 0; n < this.scheme.numMeasurements(); ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                final int n2 = n;
                final int n3 = i;
                NumDeriv numDeriv = new NumDeriv(){

                    @Override
                    protected float func(float f) {
                        dArray2[n3] = f;
                        float f2 = (float)LM_Minimizer.this.model.getSignal(LM_Minimizer.this.codec.optToModel(dArray2), LM_Minimizer.this.scheme, n2);
                        return f2;
                    }
                };
                float[] fArray = new float[1];
                realMatrix.entries[n2][n3] = numDeriv.dfridr((float)dArray[n3], dArray[n3] != 0.0 ? 0.1f * (float)dArray[n3] : 0.1f, fArray);
                dArray2[n3] = dArray[n3];
            }
        }
        return realMatrix;
    }
}

