/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import imaging.DW_Scheme;
import models.ParametricModel;
import numerics.BesselFunctions;
import numerics.RealMatrix;
import optimizers.LM_OffGaussMinimizer;
import optimizers.MarquardtMinimiserException;

public class LM_RicianMinimizer
extends LM_OffGaussMinimizer {
    public LM_RicianMinimizer(DW_Scheme dW_Scheme, ParametricModel parametricModel, Codec codec, double d) throws MarquardtMinimiserException {
        super(dW_Scheme, parametricModel, codec, d);
    }

    @Override
    protected double fObj(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        double d = 0.0;
        for (int i = 1; i <= this.ma; ++i) {
            for (n2 = 1; n2 <= this.ma; ++n2) {
                dArray3[i][n2] = 0.0;
            }
            dArray2[i] = 0.0;
        }
        double[] dArray4 = new double[dArray.length - 1];
        for (n2 = 0; n2 < dArray.length - 1; ++n2) {
            dArray4[n2] = dArray[n2 + 1];
        }
        double[] dArray5 = this.codec.optToModel(dArray4);
        RealMatrix realMatrix = this.model.getSignals(dArray5, this.scheme);
        RealMatrix realMatrix2 = this.model.getJacobian(dArray5, this.scheme);
        RealMatrix realMatrix3 = this.codec.getJacobian(dArray4);
        RealMatrix realMatrix4 = realMatrix2.product(realMatrix3);
        boolean bl = false;
        if (bl) {
            System.err.println("modParams");
            for (n = 0; n < dArray5.length; ++n) {
                System.err.print(dArray5[n] + " ");
            }
            System.err.println();
            System.err.println("measurements");
            for (n = 0; n < this.measurements.length; ++n) {
                System.err.print(this.measurements[n] + " ");
            }
            System.err.println();
            System.err.println("modSignals");
            System.err.println(realMatrix);
            System.err.println("modJac");
            System.err.println(realMatrix2);
            System.err.println("codJac");
            System.err.println(realMatrix3);
            System.err.println("optJac");
            System.err.println(realMatrix4);
        }
        for (n = 1; n <= this.scheme.numMeasurements(); ++n) {
            double d2;
            double d3;
            double d4;
            double d5 = realMatrix.entries[n - 1][0];
            double d6 = this.sig[n - 1] * this.sig[n - 1];
            double d7 = 1.0 / d6;
            double d8 = d5 * this.measurements[n - 1] * d7;
            if (d8 < 700.0) {
                double d9 = BesselFunctions.besselI0(d8);
                d4 = Math.log(d9);
                double d10 = BesselFunctions.besselI1(d8);
                d3 = d10 / d9;
                double d11 = BesselFunctions.besselIn(2, d8);
                d2 = d11 / d9;
            } else {
                d4 = d8 - Math.log(Math.PI * 2 * d8) / 2.0;
                d3 = 1.0 - Math.exp((d8 - 700.0) * -0.00143010502604 - 7.24386992534278);
                d2 = 1.0 - Math.exp((d8 - 700.0) * -0.001428569477897 - 5.858647951071322);
            }
            double[] dArray6 = realMatrix4.entries[n - 1];
            for (int i = 1; i <= this.ma; ++i) {
                for (int j = 1; j <= i; ++j) {
                    double[] dArray7 = dArray3[j];
                    int n3 = i;
                    dArray7[n3] = dArray7[n3] + dArray6[i - 1] * dArray6[j - 1] * d7 * (1.0 - this.measurements[n - 1] * this.measurements[n - 1] * d7 * (0.5 + 0.5 * d2 - d3 * d3));
                }
                int n4 = i;
                dArray2[n4] = dArray2[n4] + dArray6[i - 1] * d7 * (d5 - this.measurements[n - 1] * d3);
            }
            d += 0.5 * d7 * d5 * d5 - d4;
        }
        for (n = 2; n <= this.ma; ++n) {
            for (int i = 1; i < n; ++i) {
                dArray3[n][i] = dArray3[i][n];
            }
        }
        if (bl) {
            System.err.println("chisq: " + d);
        }
        return d;
    }
}

