/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import fitters.Perturbation;
import fitters.Prior;
import imaging.DW_Scheme;
import java.util.logging.Logger;
import models.ParametricModel;
import numerics.RealMatrix;
import optimizers.MCMC_Minimizer;
import optimizers.MarkovChainMonteCarloException;

public class MCMC_GaussianMinimizer
extends MCMC_Minimizer {
    private static Logger logger = Logger.getLogger("camino.optimizers.MCMC_GaussianMinimizer");
    protected double[] sig;

    public MCMC_GaussianMinimizer() {
    }

    public MCMC_GaussianMinimizer(DW_Scheme dW_Scheme, ParametricModel parametricModel, Codec codec, Prior prior, Perturbation perturbation, double d) throws MarkovChainMonteCarloException {
        this.scheme = dW_Scheme;
        this.codec = codec;
        this.model = parametricModel;
        this.prior = prior;
        this.perturbation = perturbation;
        this.sig = new double[dW_Scheme.numMeasurements()];
        for (int i = 0; i < this.sig.length; ++i) {
            this.sig[i] = d;
        }
        this.measurements = new double[dW_Scheme.numMeasurements()];
        this.init(this.codec.getNumOptParams());
    }

    @Override
    protected double fObj(double[] dArray) {
        int n;
        double d = 0.0;
        double[] dArray2 = this.codec.optToModel(dArray);
        RealMatrix realMatrix = this.model.getSignals(dArray2, this.scheme);
        boolean bl = false;
        if (bl) {
            System.err.println("modParams");
            for (n = 0; n < dArray2.length; ++n) {
                System.err.print(dArray2[n] + " ");
            }
            System.err.println();
            System.err.println("measurements");
            for (n = 0; n < this.measurements.length; ++n) {
                System.err.print(this.measurements[n] + " ");
            }
            System.err.println();
            System.err.println("modSignals");
            System.err.println(realMatrix);
        }
        for (n = 1; n <= this.scheme.numMeasurements(); ++n) {
            double d2 = realMatrix.entries[n - 1][0];
            double d3 = 1.0 / (this.sig[n - 1] * this.sig[n - 1]);
            double d4 = this.measurements[n - 1] - d2;
            d += d4 * d4 * d3;
        }
        if (bl) {
            System.err.println("chisq: " + d);
        }
        return d;
    }
}

