/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import imaging.DW_Scheme;
import java.util.logging.Logger;
import models.ParametricModel;
import optimizers.MarkovChainMonteCarlo;
import optimizers.MarkovChainMonteCarloException;
import optimizers.Minimizer;

public abstract class MCMC_Minimizer
extends MarkovChainMonteCarlo
implements Minimizer {
    private static Logger logger = Logger.getLogger("camino.optimizers.MCMC_Minimizer");
    protected DW_Scheme scheme;
    protected ParametricModel model;
    protected Codec codec;
    protected double[] measurements;

    @Override
    public double[][] getSolutions() {
        double[][] dArray = new double[this.samplesNumber][this.codec.getNumModelParams() + 2];
        for (int i = 0; i < this.samplesNumber; ++i) {
            double[] dArray2 = new double[this.paramsNumber];
            for (int j = 0; j < this.paramsNumber; ++j) {
                dArray2[j] = this.samples[i][j + 1];
            }
            double[] dArray3 = this.codec.optToModel(dArray2);
            dArray[i][0] = this.samples[i][0];
            for (int j = 0; j < dArray3.length; ++j) {
                dArray[i][j + 1] = dArray3[j];
            }
            dArray[i][dArray[i].length - 1] = this.samples[i][this.paramsNumber + 1];
        }
        return dArray;
    }

    @Override
    public int getNumSolutions() {
        return this.samplesNumber;
    }

    @Override
    public int getNumParameters() {
        return this.model.numParams() + 2;
    }

    @Override
    public void setMeasurements(double[] dArray) throws MarkovChainMonteCarloException {
        if (dArray.length != this.scheme.numMeasurements()) {
            throw new MarkovChainMonteCarloException("New data contains the wrong number of values: " + dArray.length + " instead of " + this.measurements.length + ".");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.measurements[i] = dArray[i];
        }
    }
}

