/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import fitters.Perturbation;
import fitters.Prior;
import imaging.DW_Scheme;
import java.util.logging.Logger;
import models.ParametricModel;
import numerics.BesselFunctions;
import numerics.RealMatrix;
import optimizers.MCMC_GaussianMinimizer;
import optimizers.MarkovChainMonteCarloException;

public class MCMC_RicianMinimizer
extends MCMC_GaussianMinimizer {
    private static Logger logger = Logger.getLogger("camino.optimizers.MCMC_RicianMinimizer");

    public MCMC_RicianMinimizer() {
    }

    public MCMC_RicianMinimizer(DW_Scheme dW_Scheme, ParametricModel parametricModel, Codec codec, Prior prior, Perturbation perturbation, double d) throws MarkovChainMonteCarloException {
        super(dW_Scheme, parametricModel, codec, prior, perturbation, d);
    }

    @Override
    protected double fObj(double[] dArray) {
        int n;
        double d = 0.0;
        double[] dArray2 = this.codec.optToModel(dArray);
        RealMatrix realMatrix = this.model.getSignals(dArray2, this.scheme);
        boolean bl = false;
        if (bl) {
            System.err.println("modParams");
            for (n = 0; n < dArray2.length; ++n) {
                System.err.print(dArray2[n] + " ");
            }
            System.err.println();
            System.err.println("measurements");
            for (n = 0; n < this.measurements.length; ++n) {
                System.err.print(this.measurements[n] + " ");
            }
            System.err.println();
            System.err.println("modSignals");
            System.err.println(realMatrix);
        }
        for (n = 1; n <= this.scheme.numMeasurements(); ++n) {
            double d2;
            double d3 = realMatrix.entries[n - 1][0];
            double d4 = this.sig[n - 1] * this.sig[n - 1];
            double d5 = 1.0 / d4;
            double d6 = d3 * this.measurements[n - 1] * d5;
            if (d6 < 700.0) {
                double d7 = BesselFunctions.besselI0(d6);
                d2 = Math.log(d7);
            } else {
                d2 = d6 - Math.log(Math.PI * 2 * d6) / 2.0;
            }
            d += 0.5 * d5 * d3 * d3 - d2;
        }
        if (bl) {
            System.err.println("loglik: " + d);
        }
        return d;
    }
}

