/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Perturbation;
import fitters.Prior;
import java.util.Random;
import java.util.logging.Logger;
import optimizers.MarkovChainMonteCarloException;
import tools.CL_Initializer;

public abstract class MarkovChainMonteCarlo {
    private static Logger logger = Logger.getLogger("camino.optimizers.MarkovChainMonteCarlo");
    protected int burninTime = CL_Initializer.burnInTime;
    protected int intervalTime = CL_Initializer.interval;
    protected int samplesNumber = CL_Initializer.samples;
    protected double[][] samples;
    protected int acceptances;
    protected Random rand = new Random(CL_Initializer.seed);
    protected Prior prior;
    protected Perturbation perturbation;
    protected int paramsNumber;
    protected double[] paramsCurrent;
    protected double[] paramsInitial;
    protected double fObjCurrent;
    protected double priorCurrent;
    protected int voxelIndex = 0;

    protected abstract double fObj(double[] var1);

    protected void init(int n) {
        this.paramsNumber = n;
        this.paramsCurrent = new double[this.paramsNumber];
        this.paramsInitial = new double[this.paramsNumber];
        this.samples = new double[this.samplesNumber][this.paramsNumber + 2];
        for (int i = 0; i < this.paramsNumber; ++i) {
            this.paramsCurrent[i] = 0.0;
            this.paramsInitial[i] = 0.0;
        }
    }

    public void setInitParams(double[] dArray) throws MarkovChainMonteCarloException {
        if (dArray.length != this.paramsNumber) {
            throw new MarkovChainMonteCarloException("Wrong number of parameters in initializing array.  Got " + dArray.length + " expected " + this.paramsNumber + ".");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.paramsInitial[i] = dArray[i];
            this.paramsCurrent[i] = dArray[i];
        }
        this.fObjCurrent = this.fObj(this.paramsCurrent);
        this.priorCurrent = this.prior.prior(this.paramsCurrent);
    }

    public double[] getParameters() {
        double[] dArray = new double[this.paramsCurrent.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.paramsCurrent[i];
        }
        return dArray;
    }

    public void minimise() throws MarkovChainMonteCarloException {
        int n;
        ++this.voxelIndex;
        this.acceptances = 0;
        for (n = 0; n < this.burninTime; ++n) {
            this.update();
        }
        for (n = 0; n < this.samplesNumber; ++n) {
            int n2;
            for (n2 = 0; n2 < this.intervalTime; ++n2) {
                this.update();
            }
            this.samples[n][0] = 0.0;
            for (n2 = 0; n2 < this.paramsNumber; ++n2) {
                this.samples[n][n2 + 1] = this.paramsCurrent[n2];
            }
            this.samples[n][this.paramsNumber + 1] = this.fObjCurrent;
        }
    }

    public double getAcceptanceRate() {
        return (double)this.acceptances / (double)(this.burninTime + this.samplesNumber * this.intervalTime);
    }

    private void update() throws MarkovChainMonteCarloException {
        double[] dArray = this.perturbation.perturb(this.paramsCurrent, this.paramsInitial, this.rand);
        double d = this.prior.prior(dArray);
        if (d > 0.0) {
            double d2 = this.fObj(dArray);
            double d3 = this.fObjCurrent + Math.log(this.priorCurrent) - d2 - Math.log(d);
            double d4 = 0.0;
            if (d3 > 0.0) {
                d4 = 1.0;
            } else if (d3 > -100.0) {
                d4 = Math.exp(d3);
            }
            if (Double.isNaN(d4) || Double.isInfinite(d4)) {
                System.err.println(d3);
                System.err.println(d4);
                throw new MarkovChainMonteCarloException("Infinite likelihood ratio in Update function.");
            }
            double d5 = this.rand.nextDouble();
            if (d5 < d4) {
                for (int i = 0; i < this.paramsNumber; ++i) {
                    this.paramsCurrent[i] = dArray[i];
                }
                this.fObjCurrent = d2;
                this.priorCurrent = d;
                ++this.acceptances;
            }
        }
    }
}

