/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import numerics.NumDeriv;
import optimizers.MarquardtMinimiser;
import optimizers.MarquardtMinimiserException;

public abstract class MarquardtChiSqFitter
extends MarquardtMinimiser {
    protected int ndata;
    protected double[][] x;
    protected double[] y;
    protected double[] sig;
    protected boolean useHessian = false;

    protected void initData(double[][] dArray, double[] dArray2, int n) throws MarquardtMinimiserException {
        if (dArray2.length != dArray.length) {
            throw new MarquardtMinimiserException("Numbers of dependent and independent values differ in MarquardtFitter.initData");
        }
        this.x = new double[dArray.length + 1][dArray[0].length];
        this.y = new double[dArray2.length + 1];
        this.ndata = this.y.length - 1;
        this.sig = new double[this.ndata + 1];
        for (int i = 0; i < this.ndata; ++i) {
            for (int j = 0; j < this.x[0].length; ++j) {
                this.x[i + 1][j] = dArray[i][j];
            }
            this.y[i + 1] = dArray2[i];
            this.sig[i + 1] = 1.0;
        }
        this.init(n);
    }

    protected abstract double yfit(double[] var1, int var2);

    protected double[] dydas(double[] dArray, int n) {
        return this.dydasNumerical(dArray, n);
    }

    protected double[] dydasNumerical(double[] dArray, final int n) {
        int n2;
        double[] dArray2 = new double[this.ma + 1];
        final double[] dArray3 = new double[dArray.length];
        for (n2 = 1; n2 < dArray.length; ++n2) {
            dArray3[n2] = dArray[n2];
        }
        for (n2 = 1; n2 <= this.ma; ++n2) {
            final int n3 = n2;
            NumDeriv numDeriv = new NumDeriv(){

                @Override
                protected float func(float f) {
                    dArray3[n3] = f;
                    float f2 = (float)MarquardtChiSqFitter.this.yfit(dArray3, n);
                    return f2;
                }
            };
            float[] fArray = new float[1];
            dArray2[n2] = numDeriv.dfridr((float)dArray[n2], dArray[n2] != 0.0 ? 0.1f * (float)dArray[n2] : 0.1f, fArray);
            dArray3[n3] = dArray[n3];
        }
        return dArray2;
    }

    protected double[][] d2yda2s(double[] dArray, int n) {
        return this.d2yda2sNumerical(dArray, n);
    }

    protected double[][] d2yda2sNumerical(double[] dArray, final int n) {
        int n2;
        double[][] dArray2 = new double[this.ma + 1][this.ma + 1];
        final double[] dArray3 = new double[dArray.length];
        for (n2 = 1; n2 < dArray.length; ++n2) {
            dArray3[n2] = dArray[n2];
        }
        for (n2 = 1; n2 <= this.ma; ++n2) {
            for (int i = n2; i <= this.ma; ++i) {
                final int n3 = n2;
                final int n4 = i;
                NumDeriv numDeriv = new NumDeriv(){

                    @Override
                    protected float func(float f) {
                        dArray3[n3] = f;
                        double[] dArray = MarquardtChiSqFitter.this.dydas(dArray3, n);
                        return (float)dArray[n4];
                    }
                };
                float[] fArray = new float[1];
                double d = numDeriv.dfridr((float)dArray[i], dArray[i] != 0.0 ? 0.1f * (float)dArray[i] : 0.1f, fArray);
                dArray2[i][n2] = d;
                dArray2[n2][i] = d;
                dArray3[n3] = dArray[n3];
            }
        }
        return dArray2;
    }

    @Override
    protected double fObj(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        double d = 0.0;
        for (n = 1; n <= this.ma; ++n) {
            for (int i = 1; i <= this.ma; ++i) {
                dArray3[n][i] = 0.0;
            }
            dArray2[n] = 0.0;
        }
        for (n = 1; n <= this.ndata; ++n) {
            double d2 = this.yfit(dArray, n);
            double[] dArray4 = this.dydas(dArray, n);
            double[][] dArray5 = null;
            if (this.useHessian) {
                dArray5 = this.d2yda2s(dArray, n);
            }
            double d3 = 1.0 / (this.sig[n] * this.sig[n]);
            double d4 = this.y[n] - d2;
            int n2 = 1;
            while (n2 <= this.ma) {
                double d5 = 2.0 * dArray4[n2] * d3;
                for (int i = 1; i <= n2; ++i) {
                    double[] dArray6 = dArray3[i];
                    int n3 = n2;
                    dArray6[n3] = dArray6[n3] + d5 * dArray4[i];
                    if (!this.useHessian) continue;
                    double[] dArray7 = dArray3[i];
                    int n4 = n2;
                    dArray7[n4] = dArray7[n4] + 2.0 * dArray5[i][n2] * d4 * d3;
                }
                int n5 = n2++;
                dArray2[n5] = dArray2[n5] - d4 * d5;
            }
            d += d4 * d4 * d3;
        }
        for (n = 2; n <= this.ma; ++n) {
            for (int i = 1; i < n; ++i) {
                dArray3[n][i] = dArray3[i][n];
            }
        }
        return d;
    }

    public void setSig(int n, double d) {
        if (n > 0 && n < this.sig.length) {
            this.sig[n] = d;
        }
    }

    public double getChiSq() {
        return this.getFObjVal();
    }

    public double getResidual() {
        double d = 0.0;
        for (int i = 1; i <= this.ndata; ++i) {
            double d2 = this.yfit(this.a, i);
            d += (d2 - this.y[i]) * (d2 - this.y[i]);
        }
        return d /= (double)this.ndata;
    }

    public double[] getResiduals() {
        double[] dArray = new double[this.ndata];
        for (int i = 1; i <= this.ndata; ++i) {
            double d = this.yfit(this.a, i);
            dArray[i - 1] = Math.abs(d - this.y[i]);
        }
        return dArray;
    }

    public double getRelativeResidual() {
        double d = 0.0;
        for (int i = 1; i <= this.ndata; ++i) {
            double d2 = this.yfit(this.a, i);
            d += (d2 - this.y[i]) * (d2 - this.y[i]) / (this.y[i] * this.y[i]);
        }
        return d /= (double)this.ndata;
    }
}

