/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import optimizers.MarquardtMinimiserException;
import optimizers.MarquardtMinimiserNonConvergenceException;

public abstract class MarquardtMinimiser {
    protected double alamda;
    protected double fObjVal;
    protected double ofObjVal;
    private static double CONVERGETHRESH = 1.0E-8;
    private static int MAXITER = -1;
    protected int ma;
    protected boolean[] ia;
    protected double[] a;

    public static void setCONVERGETHRESH(double d) {
        CONVERGETHRESH = d;
    }

    public static void setMAXITER(int n) {
        MAXITER = n;
    }

    public static double getCONVERGETHRESH() {
        return CONVERGETHRESH;
    }

    protected abstract double fObj(double[] var1, double[] var2, double[][] var3);

    protected void init(int n) {
        this.ma = n;
        this.ia = new boolean[this.ma + 1];
        this.a = new double[this.ma + 1];
        for (int i = 1; i <= this.ma; ++i) {
            this.ia[i] = true;
            this.a[i] = 0.0;
        }
    }

    public void setInitParams(double[] dArray) throws MarquardtMinimiserException {
        if (dArray.length != this.a.length - 1) {
            throw new MarquardtMinimiserException("Wrong number of parameters in initializing array.  Got " + dArray.length + " expected " + (this.a.length - 1) + ".");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.a[i + 1] = dArray[i];
        }
    }

    public void minimise() throws MarquardtMinimiserException {
        double d;
        double[][] dArray = new double[this.ma + 1][this.ma + 1];
        double[][] dArray2 = new double[this.ma + 1][this.ma + 1];
        double[] dArray3 = new double[this.ma + 1];
        double[] dArray4 = new double[this.ma + 1];
        double[] dArray5 = new double[this.ma + 1];
        int n = 0;
        for (int i = 1; i <= this.ma; ++i) {
            if (!this.ia[i]) continue;
            ++n;
        }
        double[][] dArray6 = new double[n + 1][2];
        this.alamda = 0.001;
        this.mrqcof(this.a, dArray2, dArray4);
        this.ofObjVal = this.fObjVal;
        for (int i = 1; i <= this.ma; ++i) {
            dArray3[i] = this.a[i];
        }
        double[] dArray7 = new double[this.ma + 1];
        double[][] dArray8 = new double[this.ma + 1][this.ma + 1];
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            double d2 = this.mrqmin(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, n);
            d = 1.0E30;
            if (this.alamda > d) {
                throw new MarquardtMinimiserException("alamda exceeds " + d + ". Giving up.");
            }
            double[] dArray9 = new double[this.ma + 1];
            double[][] dArray10 = new double[this.ma + 1][this.ma + 1];
            bl = d2 <= 0.0 && d2 > -CONVERGETHRESH || ++n2 >= MAXITER && MAXITER > 0;
        }
        double[] dArray11 = new double[this.ma + 1];
        double[][] dArray12 = new double[this.ma + 1][this.ma + 1];
        d = this.fObj(this.a, dArray11, dArray12);
        if (n2 >= MAXITER && MAXITER > 0) {
            throw new MarquardtMinimiserNonConvergenceException("Exceeded maximum number of iterations: " + MAXITER);
        }
    }

    public double[] getParameters() {
        double[] dArray = new double[this.a.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.a[i];
        }
        return dArray;
    }

    public double getFObjVal() {
        return this.fObjVal;
    }

    public void setConvergence(double d) {
        MarquardtMinimiser.setCONVERGETHRESH(d);
    }

    private double mrqmin(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[][] dArray6, int n) throws MarquardtMinimiserException {
        int n2;
        int n3;
        for (n3 = 1; n3 <= n; ++n3) {
            for (n2 = 1; n2 <= n; ++n2) {
                dArray[n3][n2] = dArray2[n3][n2];
            }
            dArray[n3][n3] = dArray2[n3][n3] * (1.0 + this.alamda);
            dArray6[n3][1] = dArray4[n3];
        }
        MarquardtMinimiser.gaussj(dArray, n, dArray6, 1);
        for (n3 = 1; n3 <= n; ++n3) {
            dArray5[n3] = dArray6[n3][1];
        }
        if (this.alamda == 0.0) {
            MarquardtMinimiser.covsrt(dArray, this.ma, this.ia, n);
            return 0.0;
        }
        n3 = 0;
        for (n2 = 1; n2 <= this.ma; ++n2) {
            if (!this.ia[n2]) continue;
            dArray3[n2] = this.a[n2] + dArray5[++n3];
        }
        this.mrqcof(dArray3, dArray, dArray5);
        double d = this.fObjVal - this.ofObjVal;
        if (this.fObjVal < this.ofObjVal) {
            int n4;
            this.alamda *= 0.1;
            this.ofObjVal = this.fObjVal;
            for (n4 = 1; n4 <= n; ++n4) {
                for (int i = 1; i <= n; ++i) {
                    dArray2[n4][i] = dArray[n4][i];
                }
                dArray4[n4] = dArray5[n4];
            }
            for (n4 = 1; n4 <= this.ma; ++n4) {
                this.a[n4] = dArray3[n4];
            }
        } else {
            this.alamda *= 10.0;
            this.fObjVal = this.ofObjVal;
        }
        return d;
    }

    protected void mrqcof(double[] dArray, double[][] dArray2, double[] dArray3) throws MarquardtMinimiserException {
        int n = 0;
        for (int i = 1; i <= this.ma; ++i) {
            if (!this.ia[i]) continue;
            ++n;
        }
        double[] dArray4 = new double[this.ma + 1];
        double[][] dArray5 = new double[this.ma + 1][this.ma + 1];
        this.fObjVal = this.fObj(dArray, dArray4, dArray5);
        if (Double.isNaN(this.fObjVal) || Double.isInfinite(this.fObjVal)) {
            throw new MarquardtMinimiserException("Infinite objective function in mrqcof.");
        }
        int n2 = 0;
        for (int i = 1; i <= this.ma; ++i) {
            if (!this.ia[i]) continue;
            ++n2;
            int n3 = 0;
            for (int j = 1; j <= this.ma; ++j) {
                if (!this.ia[j]) continue;
                dArray2[n2][++n3] = dArray5[i][j] / 2.0;
            }
            dArray3[n2] = -dArray4[i] / 2.0;
        }
    }

    private static void gaussj(double[][] dArray, int n, double[][] dArray2, int n2) throws MarquardtMinimiserException {
        int n3;
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        int[] nArray3 = new int[n + 1];
        int n4 = 0;
        int n5 = 0;
        for (n3 = 1; n3 <= n; ++n3) {
            nArray3[n3] = 0;
        }
        for (n3 = 1; n3 <= n; ++n3) {
            int n6;
            double d = 0.0;
            for (n6 = 1; n6 <= n; ++n6) {
                if (nArray3[n6] == 1) continue;
                for (int i = 1; i <= n; ++i) {
                    if (nArray3[i] == 0) {
                        if (!(Math.abs(dArray[n6][i]) >= d)) continue;
                        d = Math.abs(dArray[n6][i]);
                        n4 = n6;
                        n5 = i;
                        continue;
                    }
                    if (nArray3[i] <= 1) continue;
                    throw new MarquardtMinimiserException("Singular Matrix in gaussj - 1");
                }
            }
            int n7 = n5;
            nArray3[n7] = nArray3[n7] + 1;
            if (n4 != n5) {
                for (n6 = 1; n6 <= n; ++n6) {
                    double d2 = dArray[n4][n6];
                    dArray[n4][n6] = dArray[n5][n6];
                    dArray[n5][n6] = d2;
                }
                for (n6 = 1; n6 <= n2; ++n6) {
                    double d3 = dArray2[n4][n6];
                    dArray2[n4][n6] = dArray2[n5][n6];
                    dArray2[n5][n6] = d3;
                }
            }
            nArray2[n3] = n4;
            nArray[n3] = n5;
            if (dArray[n5][n5] == 0.0) {
                throw new MarquardtMinimiserException("Singular Matrix in gaussj - 2  ");
            }
            double d4 = 1.0 / dArray[n5][n5];
            dArray[n5][n5] = 1.0;
            int n8 = 1;
            while (n8 <= n) {
                double[] dArray3 = dArray[n5];
                int n9 = n8++;
                dArray3[n9] = dArray3[n9] * d4;
            }
            n8 = 1;
            while (n8 <= n2) {
                double[] dArray4 = dArray2[n5];
                int n10 = n8++;
                dArray4[n10] = dArray4[n10] * d4;
            }
            for (n8 = 1; n8 <= n; ++n8) {
                int n11;
                if (n8 == n5) continue;
                double d5 = dArray[n8][n5];
                dArray[n8][n5] = 0.0;
                for (n11 = 1; n11 <= n; ++n11) {
                    double[] dArray5 = dArray[n8];
                    int n12 = n11;
                    dArray5[n12] = dArray5[n12] - dArray[n5][n11] * d5;
                }
                for (n11 = 1; n11 <= n2; ++n11) {
                    double[] dArray6 = dArray2[n8];
                    int n13 = n11;
                    dArray6[n13] = dArray6[n13] - dArray2[n5][n11] * d5;
                }
            }
        }
        for (n3 = n; n3 >= 1; --n3) {
            if (nArray2[n3] == nArray[n3]) continue;
            for (int i = 1; i <= n; ++i) {
                double d = dArray[i][nArray2[n3]];
                dArray[i][nArray2[n3]] = dArray[i][nArray[n3]];
                dArray[i][nArray[n3]] = d;
            }
        }
    }

    private static void covsrt(double[][] dArray, int n, boolean[] blArray, int n2) {
        int n3;
        int n4;
        for (n4 = n2 + 1; n4 <= n; ++n4) {
            for (n3 = 1; n3 <= n4; ++n3) {
                dArray[n3][n4] = 0.0;
                dArray[n4][n3] = 0.0;
            }
        }
        n4 = n2;
        for (n3 = n; n3 >= 1; --n3) {
            double d;
            int n5;
            if (!blArray[n3]) continue;
            for (n5 = 1; n5 <= n; ++n5) {
                d = dArray[n5][n4];
                dArray[n5][n4] = dArray[n5][n3];
                dArray[n5][n3] = d;
            }
            for (n5 = 1; n5 <= n; ++n5) {
                d = dArray[n4][n5];
                dArray[n4][n5] = dArray[n3][n5];
                dArray[n3][n5] = d;
            }
            --n4;
        }
    }
}

