/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import fitters.Codec;
import fitters.Perturbation;
import imaging.DW_Scheme;
import java.util.Random;
import java.util.logging.Logger;
import models.ParametricModel;
import optimizers.Minimizer;
import optimizers.MinimizerException;

public abstract class MultiRunMinimizer
implements Minimizer {
    private static Logger logger = Logger.getLogger("optimizers.MultiRunMinimizer");
    private double[] initOptParams;
    protected Perturbation perturbation;
    private Random r;
    private int numRepeats;
    protected Minimizer minimizer;
    private double[][] concatRes;
    private static double FAILRATE = 0.3;

    public MultiRunMinimizer() {
    }

    public MultiRunMinimizer(DW_Scheme dW_Scheme, ParametricModel parametricModel, Codec codec, Perturbation perturbation, int n, int n2) throws MinimizerException {
        this.init(codec, perturbation, n, n2);
        this.makeMinimizer(dW_Scheme, parametricModel, codec);
    }

    protected void init(Codec codec, Perturbation perturbation, int n, int n2) {
        this.initOptParams = new double[codec.getNumOptParams()];
        this.perturbation = perturbation;
        this.r = new Random(n2);
        this.numRepeats = n;
    }

    protected abstract void makeMinimizer(DW_Scheme var1, ParametricModel var2, Codec var3) throws MinimizerException;

    public void setPerturbation(Perturbation perturbation) {
        this.perturbation = perturbation;
    }

    @Override
    public void setInitParams(double[] dArray) throws MinimizerException {
        for (int i = 0; i < this.initOptParams.length; ++i) {
            this.initOptParams[i] = dArray[i];
        }
    }

    @Override
    public void setMeasurements(double[] dArray) throws MinimizerException {
        this.minimizer.setMeasurements(dArray);
    }

    @Override
    public void minimise() throws MinimizerException {
        int n = 0;
        int n2 = 0;
        while (n < this.numRepeats) {
            int n3;
            int n4;
            double[] dArray = this.perturbation.perturb(this.initOptParams, this.initOptParams, this.r);
            this.minimizer.setInitParams(dArray);
            try {
                this.minimizer.minimise();
                double[][] dArray2 = this.minimizer.getSolutions();
                if (n == 0) {
                    this.concatRes = new double[dArray2.length * this.numRepeats][dArray2[0].length];
                }
                for (n4 = 0; n4 < dArray2.length; ++n4) {
                    for (n3 = 0; n3 < dArray2[0].length; ++n3) {
                        this.concatRes[n * dArray2.length + n4][n3] = dArray2[n4][n3];
                    }
                }
                ++n;
            }
            catch (Exception exception) {
                ++n2;
            }
            if (!((double)n2 > (double)this.numRepeats * FAILRATE)) continue;
            logger.warning("Aborting fitting, more than " + (int)(FAILRATE * 100.0) + " percent of the fittings failed");
            int n5 = this.minimizer.getNumParameters();
            if (n == 0) {
                this.concatRes = new double[this.numRepeats][n5];
            }
            for (n4 = n; n4 < this.numRepeats; ++n4) {
                this.concatRes[n4][0] = 4.0;
                for (n3 = 1; n3 < n5; ++n3) {
                    this.concatRes[n4][n3] = 0.0;
                }
            }
            return;
        }
    }

    @Override
    public double[][] getSolutions() {
        return this.concatRes;
    }

    @Override
    public int getNumSolutions() {
        return this.numRepeats;
    }

    @Override
    public int getNumParameters() {
        return this.minimizer.getNumParameters();
    }

    public static double[] getBestSolution(double[][] dArray) {
        int n = 0;
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n2 = dArray[0].length - 1;
        for (int i = 0; i < dArray.length; ++i) {
            if (d > dArray[i][n2]) {
                d = dArray[i][n2];
                n = i;
            }
            if (!(d2 < dArray[i][n2])) continue;
            d2 = dArray[i][n2];
        }
        return dArray[n];
    }
}

