/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import imaging.SimulableScheme;
import java.util.logging.Logger;
import simulation.dynamics.StepAmenderFactory;
import simulation.dynamics.StepGeneratorFactory;
import simulation.geometry.elements.CylinderFactory;
import simulation.geometry.substrates.SubstrateFactory;
import simulation.measurement.ScanFactory;
import simulation.measurement.StatisticsModuleFactory;
import tools.CL_Initializer;

public class SimulationParams {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static boolean sim_separate_runs = false;
    public static int sim_inflamm_increments = 10;
    public static int sim_N_walkers = 10000;
    public static int sim_tmax = 100000;
    public static double sim_p = 0.0;
    public static int sim_initial = 1;
    public static SubstrateFactory.SubstrateType sim_geomType = SubstrateFactory.SubstrateType.CYL_1_FIXED;
    public static double sim_L = 20.0;
    public static double sim_l = 1.0;
    public static int sim_stripethickness = 3;
    public static double sim_p_perc = 0.5;
    public static double sim_voxelSize = 10.0;
    public static StepGeneratorFactory.StepType sim_stepType = StepGeneratorFactory.StepType.FIXEDLENGTH;
    public static boolean sim_delta_set = false;
    public static double sim_delta;
    public static boolean sim_DELTA_set;
    public static double sim_DELTA;
    public static boolean sim_G_set;
    public static double sim_G;
    public static double sim_surfaceDiffusivity;
    public static double[] sim_T2;
    public static CylinderFactory.CylType cylinderType;
    public static int sim_cyl_pack;
    public static int sim_cyl_dist_size;
    public static double sim_cyl_min_r;
    public static double sim_cyl_max_r;
    public static double sim_cyl_r;
    public static double sim_cyl_R;
    public static double sim_cyl_r1;
    public static double sim_cyl_D1;
    public static double sim_cyl_D2;
    public static double sim_cAngle;
    public static int sim_num_cylinders;
    public static int sim_num_facets;
    public static String sim_plyfile;
    public static double sim_voxelSizeFrac;
    public static String sim_statsfile;
    public static StatisticsModuleFactory.StatsModuleType sim_StatsModType;
    public static int sim_spatial_grid_size;
    public static boolean sim_drawCrossSection;
    public static String crossSectionFig;
    public static int sim_crossSectionImageSize;
    public static StepAmenderFactory.AmenderType sim_amender_type;
    public static double sim_p_stick;
    public static double sim_p_unstick;
    public static String sim_postproStatsFname;
    public static ScanFactory.ScanType scanType;
    public static final int SPIKE = 0;
    public static final int UNIFORM = 1;
    public static final int SPECIAL = 2;
    public static final int INTRACELLULAR = 3;
    public static final int EXTRACELLULAR = 4;
    public static final int NOCOMPS = 0;
    public static final int EXTRAONLY = 1;
    public static final int INTRAONLY = 2;
    public static final int ALLCOMPS = 3;
    private final int N_walkers;
    private final int tmax;
    private final double dt;
    private final StepGeneratorFactory.StepType stepType;
    private double[] stepParams;
    private final double voxelSize;
    private final double p;
    private final int initial;
    private final SubstrateFactory.SubstrateType geometryType;
    public static String trajFile;
    public int buffsize = 0x100000;
    public static double duration;
    public static boolean trajectories;
    public static boolean substrateInfo;
    public static int sim_onlyRun;
    public static int sim_compartmentSignal;

    public SimulationParams(int n, int n2, double d, int n3, SubstrateFactory.SubstrateType substrateType, StepGeneratorFactory.StepType stepType, double d2, SimulableScheme simulableScheme) {
        this.N_walkers = n;
        this.tmax = n2;
        this.p = d;
        this.geometryType = substrateType;
        this.stepType = stepType;
        this.voxelSize = d2;
        double d3 = simulableScheme.getDuration();
        this.dt = d3 / (double)n2;
        trajectories = false;
        this.initial = n3;
    }

    public SimulationParams(int n, int n2, double d, int n3, SubstrateFactory.SubstrateType substrateType, StepGeneratorFactory.StepType stepType, double d2, double d3) {
        this.N_walkers = n;
        this.tmax = n2;
        this.p = d;
        this.geometryType = substrateType;
        this.stepType = stepType;
        this.voxelSize = d2;
        this.dt = d3 / (double)n2;
        duration = d3;
        trajectories = true;
        this.initial = n3;
    }

    public double getDt() {
        return this.dt;
    }

    public int getN_walkers() {
        return this.N_walkers;
    }

    public int getTmax() {
        return this.tmax;
    }

    public static void main(String[] stringArray) {
    }

    public double getP() {
        return this.p;
    }

    public SubstrateFactory.SubstrateType getGeometryType() {
        return this.geometryType;
    }

    public int getInitialConditions() {
        return this.initial;
    }

    public double[] getStepParams() {
        return this.stepParams;
    }

    public void setStepParams(double[] dArray) {
        this.stepParams = dArray;
    }

    public StepGeneratorFactory.StepType getStepType() {
        return this.stepType;
    }

    public double getVoxelSize() {
        return this.voxelSize;
    }

    static {
        sim_DELTA_set = false;
        sim_G_set = false;
        sim_surfaceDiffusivity = 2.02E-10;
        sim_T2 = new double[]{0.5, 0.09};
        cylinderType = CylinderFactory.CylType.BASIC;
        sim_cyl_pack = 2;
        sim_cyl_dist_size = 20;
        sim_cyl_min_r = 0.0;
        sim_cyl_max_r = 2.0E-5;
        sim_cyl_r = 1.0E-5;
        sim_cyl_R = 3.0E-5;
        sim_cyl_r1 = sim_cyl_r / 2.0;
        sim_cyl_D1 = CL_Initializer.DIFF_CONST;
        sim_cyl_D2 = CL_Initializer.DIFF_CONST;
        sim_cAngle = 1.5707963267948966;
        sim_num_cylinders = 20;
        sim_num_facets = 0;
        sim_plyfile = null;
        sim_voxelSizeFrac = 0.75;
        sim_statsfile = null;
        sim_StatsModType = StatisticsModuleFactory.StatsModuleType.MS_DISP;
        sim_spatial_grid_size = 10;
        sim_drawCrossSection = false;
        crossSectionFig = "crossSec.gray";
        sim_crossSectionImageSize = 500;
        sim_amender_type = StepAmenderFactory.AmenderType.ELESTIC_REFLECTOR;
        sim_p_stick = 0.75;
        sim_p_unstick = 0.0;
        sim_postproStatsFname = new String("postProcessingStats.bdouble");
        scanType = ScanFactory.ScanType.PGSE_SCAN;
        trajFile = null;
        trajectories = false;
        substrateInfo = false;
        sim_onlyRun = -1;
        sim_compartmentSignal = 0;
    }
}

