/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.dynamics.StepGenerator;
import simulation.dynamics.StepGeneratorFactory;
import simulation.dynamics.Walker;
import simulation.geometry.elements.Cylinder;
import simulation.geometry.substrates.StickyCylinderSubstrate;
import simulation.geometry.substrates.Substrate;
import tools.CL_Initializer;

public class CylindricalSurfaceStepGenerator
implements StepGenerator {
    private final int D = 3;
    private final double len;
    private Cylinder cylinder;
    private final Substrate substrate;
    private final MTRandom stepTwister = new MTRandom(CL_Initializer.seed + 1273);

    public CylindricalSurfaceStepGenerator(double d) {
        this.len = d;
        this.substrate = null;
    }

    public CylindricalSurfaceStepGenerator(SimulationParams simulationParams) {
        this.len = simulationParams.getStepParams()[1];
        this.substrate = null;
    }

    public CylindricalSurfaceStepGenerator(SimulationParams simulationParams, StickyCylinderSubstrate stickyCylinderSubstrate) {
        this.len = simulationParams.getStepParams()[1];
        this.substrate = stickyCylinderSubstrate;
        this.cylinder = stickyCylinderSubstrate.getCylinders()[0];
    }

    public CylindricalSurfaceStepGenerator(Substrate substrate) {
        this.len = SimulationParams.sim_surfaceDiffusivity;
        this.substrate = substrate;
    }

    @Override
    public double getBorder() {
        return this.len;
    }

    @Override
    public double[] getStep(Walker walker) {
        double d = this.stepTwister.nextDouble() * 2.0 * Math.PI;
        double d2 = this.len * Math.cos(d);
        double d3 = this.len * Math.sin(d);
        double d4 = d3 / this.cylinder.getRadius();
        double d5 = 1.0;
        if (this.stepTwister.nextBoolean()) {
            d5 = -1.0;
        }
        double d6 = d5 * d4;
        double d7 = this.cylinder.getRadius() * (Math.cos(d6) - 1.0);
        double d8 = this.cylinder.getRadius() * Math.sin(d6);
        double[] dArray = new double[3];
        walker.substrate.getSubstrateCoords(walker.r, new double[]{0.0, 0.0, 0.0}, dArray);
        double[] dArray2 = new double[3];
        this.getSurfaceCoords(dArray, dArray2, this.cylinder);
        double d9 = Math.cos(dArray2[1]);
        double d10 = Math.sin(dArray2[1]);
        return new double[]{d7 * d9 - d8 * d10, d7 * d10 + d8 * d9, d2};
    }

    private final void getSurfaceCoords(double[] dArray, double[] dArray2, Cylinder cylinder) {
        double[] dArray3 = cylinder.getPosition();
        double[] dArray4 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = dArray[i] - dArray3[i];
        }
        dArray2[0] = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1]);
        dArray2[1] = Math.atan2(dArray4[1], dArray4[0]);
        dArray2[2] = dArray4[2];
    }

    public void setCylinder(Cylinder cylinder) {
        this.cylinder = cylinder;
    }

    @Override
    public StepGeneratorFactory.StepType getType() {
        return StepGeneratorFactory.StepType.CYLINDRICAL;
    }

    public static void main(String[] stringArray) {
    }
}

