/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.util.logging.Logger;
import simulation.dynamics.ElasticReflector;
import simulation.dynamics.StepAmender;
import simulation.dynamics.StickAndDiffuse;
import simulation.geometry.substrates.StickyCylinderSubstrate;
import simulation.geometry.substrates.Substrate;

public class StepAmenderFactory {
    private static final Logger logger = Logger.getLogger("simulation.dynamics.StepAmenderFactory");

    public static final StepAmender getStepAmender(AmenderType amenderType, Substrate substrate) {
        if (amenderType == AmenderType.ELESTIC_REFLECTOR) {
            return new ElasticReflector(substrate);
        }
        if (amenderType == AmenderType.STICK_AND_DIFFUSE) {
            if (substrate instanceof StickyCylinderSubstrate) {
                return new StickAndDiffuse(substrate);
            }
            logger.warning("Sticky and diffuse step amender is not implemented for non-cylinders. returning elastic reflector.");
            return new ElasticReflector(substrate);
        }
        logger.warning("Unknown step amender type " + (Object)((Object)amenderType) + " returning elastic reflector");
        return new ElasticReflector(substrate);
    }

    public static enum AmenderType {
        ELESTIC_REFLECTOR,
        STICK_AND_DIFFUSE;

    }
}

