/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.util.logging.Logger;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.dynamics.ElasticReflector;
import simulation.dynamics.StickyWalker;
import simulation.dynamics.Walker;
import simulation.geometry.substrates.StickyCylinderSubstrate;
import simulation.geometry.substrates.Substrate;
import tools.CL_Initializer;

public class StickAndDiffuse
extends ElasticReflector {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final double p_stick = SimulationParams.sim_p_stick;
    private final double p_unstick = SimulationParams.sim_p_unstick;
    private final MTRandom surfaceTwister = new MTRandom(CL_Initializer.seed + 475620);
    private final StickyCylinderSubstrate substrate;

    public StickAndDiffuse(Substrate substrate) {
        super(substrate);
        this.substrate = (StickyCylinderSubstrate)substrate;
        this.logger.info("cylindrical surface stick and diffuse step amender constructed");
        this.logger.info("p_stick = " + this.p_stick + " p_unstick = " + this.p_unstick);
    }

    @Override
    public void amendStep(Walker walker, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double d, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, double d2, int n) {
        block10: {
            block9: {
                double d3;
                if (!((StickyWalker)walker).free) break block9;
                super.amendStep(walker, dArray, dArray2, dArray3, dArray4, dArray5, d, dArray6, dArray7, dArray8, dArray9, d2, n);
                if (this.substrate.intersectsBoundary || !((d3 = this.surfaceTwister.nextDouble()) < this.p_stick)) break block10;
                ((StickyWalker)walker).wasExtracellular = !this.substrate.intracellular(walker);
                ((StickyWalker)walker).free = false;
                ++((StickyWalker)walker).numSticks;
                ((StickyWalker)walker).lastStickTime = d2;
                for (int i = 0; i < 3; ++i) {
                    dArray7[i] = 0.0;
                    dArray8[i] = 0.0;
                }
                break block10;
            }
            for (int i = 0; i < 3; ++i) {
                dArray6[i] = 0.0;
                dArray7[i] = dArray3[i];
                dArray8[i] = dArray3[i];
            }
            double d4 = this.surfaceTwister.nextDouble();
            if (d4 < this.p_unstick) {
                int n2;
                ((StickyWalker)walker).free = true;
                ((StickyWalker)walker).totalTimeStuck += d2 - ((StickyWalker)walker).lastStickTime;
                double[] dArray10 = new double[3];
                double[] dArray11 = new double[3];
                double[] dArray12 = this.substrate.cylinder[0].getPosition();
                double d5 = this.substrate.cylinder[0].getRadius();
                double[] dArray13 = new double[3];
                for (int i = 0; i < 3; ++i) {
                    dArray13[i] = dArray[i] - dArray12[i];
                }
                double[] dArray14 = new double[]{Math.sqrt(dArray13[0] * dArray13[0] + dArray13[1] * dArray13[1]), Math.atan2(dArray13[1], dArray13[0])};
                double d6 = d / 10.0;
                dArray10[0] = -d6 * Math.cos(dArray14[1]);
                dArray10[1] = -d6 * Math.sin(dArray14[1]);
                dArray10[2] = 0.0;
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray11[n2] = -dArray10[n2];
                }
                if (((StickyWalker)walker).wasExtracellular) {
                    for (n2 = 0; n2 < 3; ++n2) {
                        dArray7[n2] = dArray11[n2];
                        dArray8[n2] = dArray10[n2];
                    }
                } else {
                    for (n2 = 0; n2 < 3; ++n2) {
                        dArray7[n2] = dArray10[n2];
                        dArray8[n2] = dArray11[n2];
                    }
                }
            }
        }
    }
}

