/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import simulation.dynamics.StepGenerator;
import simulation.geometry.substrates.Substrate;
import simulation.measurement.SyntheticScan;

public class Walker {
    private static Logger logger = Logger.getLogger("simulation.Walker");
    int D;
    public double[] r0;
    public double[] r = null;
    public double[] step;
    private final StepGenerator stepGen;
    protected final Substrate substrate;
    private final SyntheticScan scan;
    protected final DataOutputStream trajWriter;
    public final double[] dPhi;
    private final double[] M;
    private double tLast = 0.0;

    public Walker(double[] dArray, StepGenerator stepGenerator, Substrate substrate, SyntheticScan syntheticScan, DataOutputStream dataOutputStream) {
        int n;
        if (dArray.length != 3) {
            logger.severe("dimension mismatch in Walker initialisation");
            throw new RuntimeException("Initial coordinates passed to Walker constructoris not of same length (" + dArray.length + ") as simualtion dimensionality " + 3);
        }
        this.D = dArray.length;
        this.r0 = new double[this.D];
        this.r = new double[this.D];
        this.stepGen = stepGenerator;
        this.substrate = substrate;
        this.scan = syntheticScan;
        this.trajWriter = dataOutputStream;
        if (syntheticScan != null) {
            n = syntheticScan.getNumMeasurements();
            this.dPhi = new double[n];
            this.M = new double[n];
            for (int i = 0; i < n; ++i) {
                this.dPhi[i] = 0.0;
                this.M[i] = 0.0;
            }
        } else {
            this.dPhi = null;
            this.M = null;
        }
        for (n = 0; n < this.D; ++n) {
            this.r0[n] = dArray[n];
            this.r[n] = dArray[n];
        }
    }

    public Walker(double[] dArray) {
        this(dArray, null, null, null, null);
        logger.warning("walker intantiated without step generator, substrate or scan.\nfull simulation update NOT POSSIBLE.");
    }

    public Walker(double[] dArray, Substrate substrate) {
        this(dArray, null, substrate, null, null);
    }

    private final double mapToCircle(double d) {
        double d2 = Math.floor(d / (Math.PI * 2));
        double d3 = Math.abs(d - d2 * 2.0 * Math.PI);
        return d3;
    }

    public void update(double d, int n, int n2) {
        int n3;
        if (this.trajWriter != null) {
            try {
                this.trajWriter.writeDouble(d);
                this.trajWriter.writeInt(n2);
                for (n3 = 0; n3 < this.D; ++n3) {
                    this.trajWriter.writeDouble(this.r[n3]);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (this.scan != null) {
            n3 = 0;
            while (n3 < this.dPhi.length) {
                int n4 = n3;
                this.dPhi[n4] = this.dPhi[n4] + this.scan.getPhaseShift(this, d, n3, this.tLast);
                this.dPhi[n3] = this.mapToCircle(this.dPhi[n3]);
                int n5 = n3++;
                this.M[n5] = this.M[n5] + this.substrate.getLogMagnetisationChange(this, d, this.tLast);
            }
            this.tLast = d;
        }
        this.step = this.stepGen.getStep(this);
        this.substrate.amend(this, this.step, d, n2);
        this.makeStep(this.step);
    }

    public final double getPhaseShift(int n) {
        return this.dPhi[n];
    }

    public final double getLogMagnetisation(int n) {
        return this.M[n];
    }

    public void makeStep(double[] dArray) {
        for (int i = 0; i < this.D; ++i) {
            int n = i;
            this.r[n] = this.r[n] + dArray[i];
        }
    }

    public void testReplacePositionVector(double[] dArray) {
        this.r = dArray;
    }

    public double[] getDisplacement() {
        double[] dArray = new double[this.D];
        for (int i = 0; i < this.D; ++i) {
            dArray[i] = this.r[i] - this.r0[i];
        }
        return dArray;
    }

    public String toString() {
        int n;
        String string = new String();
        string = string + "r0= (";
        for (n = 0; n < this.D; ++n) {
            string = string + "" + this.r0[n];
            if (n >= this.D - 1) continue;
            string = string + ", ";
        }
        string = string + "\n";
        string = string + "r= (";
        for (n = 0; n < this.D; ++n) {
            string = string + "" + this.r[n];
            if (n >= this.D - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        int n = 3;
        double[] dArray = new double[]{0.5, 0.5, 0.5};
        Walker walker = new Walker(dArray);
        System.err.println("created walker: " + walker);
    }
}

