/*
 * Decompiled with CFR 0.152.
 */
package simulation.measurement;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import misc.LoggedException;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.measurement.StatisticsModule;
import tools.CL_Initializer;

public class MSdispStatsModule
extends StatisticsModule {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int D = 3;

    public MSdispStatsModule(Walker[] walkerArray) {
        super(walkerArray);
        this.Ns = 6;
        this.stats = new double[this.Ns];
    }

    @Override
    public double[] getRuntimeStats(double d) {
        int n;
        for (n = 0; n < this.Ns; ++n) {
            this.stats[n] = 0.0;
        }
        for (n = 0; n < this.walker.length; ++n) {
            int n2;
            for (n2 = 0; n2 < 3; ++n2) {
                int n3 = n2;
                this.stats[n3] = this.stats[n3] + (this.walker[n].r[n2] - this.walker[n].r0[n2]) * (this.walker[n].r[n2] - this.walker[n].r0[n2]);
            }
            for (n2 = 3; n2 < 6; ++n2) {
                int n4 = n2;
                this.stats[n4] = this.stats[n4] + (this.walker[n].r[n2 - 3] - this.walker[n].r0[n2 - 3]) * (this.walker[n].r[n2 - 3] - this.walker[n].r0[n2 - 3]) * (this.walker[n].r[n2 - 3] - this.walker[n].r0[n2 - 3]) * (this.walker[n].r[n2 - 3] - this.walker[n].r0[n2 - 3]);
            }
        }
        n = 0;
        while (n < 3) {
            int n5 = n++;
            this.stats[n5] = this.stats[n5] / (double)this.walker.length;
        }
        n = 3;
        while (n < 6) {
            int n6 = n;
            this.stats[n6] = this.stats[n6] / ((double)this.walker.length * this.stats[n - 3] * this.stats[n - 3]);
            int n7 = n++;
            this.stats[n7] = this.stats[n7] - 3.0;
        }
        return this.stats;
    }

    @Override
    public double[] getPostSimulationStats() {
        return null;
    }

    public static void main(String[] stringArray) {
        String string = " ";
        CL_Initializer.CL_init(stringArray);
        if (SimulationParams.sim_statsfile == null) {
            throw new LoggedException("no stats file specified");
        }
        double[] dArray = new double[7];
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(SimulationParams.sim_statsfile));
            String string2 = new String(SimulationParams.sim_statsfile.substring(0, SimulationParams.sim_statsfile.indexOf(46)) + ".dat");
            FileWriter fileWriter = new FileWriter(string2);
            while (true) {
                int n;
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = dataInputStream.readDouble();
                }
                fileWriter.write(dArray[0] + string);
                System.out.print(dArray[0] + string);
                for (n = 1; n < 7; ++n) {
                    fileWriter.write(dArray[n] + string);
                    System.out.print(dArray[n] + string);
                }
                fileWriter.write("\n");
                System.out.println();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        System.err.println("done.");
    }
}

