/*
 * Decompiled with CFR 0.152.
 */
package simulation.measurement;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import simulation.SimulationParams;
import simulation.dynamics.StickyWalker;
import simulation.dynamics.Walker;
import simulation.measurement.StatisticsModule;

public class StickyStatsModule
extends StatisticsModule {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final int[] stickyStats = new int[2];
    private final int windowWidth = 100;
    private final double equilibrationThreshold = 0.1;

    public StickyStatsModule(Walker[] walkerArray) {
        super(walkerArray);
        this.Ns = 5;
        this.stats = new double[this.Ns];
        SimulationParams.sim_postproStatsFname = new String("postproStats_" + SimulationParams.sim_p_stick + "_" + SimulationParams.sim_p_unstick);
    }

    @Override
    public double[] getRuntimeStats(double d) {
        int n;
        for (n = 0; n < this.Ns; ++n) {
            this.stats[n] = 0.0;
        }
        for (n = 0; n < this.walker.length; ++n) {
            for (int i = 0; i < 3; ++i) {
                int n2 = i;
                this.stats[n2] = this.stats[n2] + (this.walker[n].r[i] - this.walker[n].r0[i]) * (this.walker[n].r[i] - this.walker[n].r0[i]);
            }
        }
        n = 0;
        while (n < 3) {
            int n3 = n++;
            this.stats[n3] = this.stats[n3] / ((double)(2 * this.walker.length) * d);
        }
        int[] nArray = this.getStickyStats();
        if (nArray[0] != 0 && nArray[1] != 0) {
            this.stats[3] = nArray[0];
            this.stats[4] = nArray[1];
        }
        return this.stats;
    }

    private int[] getStickyStats() {
        if (this.walker[0] instanceof StickyWalker) {
            int n;
            for (n = 0; n < this.stickyStats.length; ++n) {
                this.stickyStats[n] = 0;
            }
            for (n = 0; n < this.walker.length; ++n) {
                if (((StickyWalker)this.walker[n]).free) {
                    this.stickyStats[0] = this.stickyStats[0] + 1;
                    continue;
                }
                this.stickyStats[1] = this.stickyStats[1] + 1;
            }
        }
        return this.stickyStats;
    }

    public void parseBinaryStatsFile(String string) {
        String string2;
        if (string.endsWith(".bdouble")) {
            string2 = string.substring(0, string.length() - 8);
        } else {
            string2 = new String(string);
            string = string + ".bdouble";
        }
        int n = 6;
        this.logger.info("parsing " + string);
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            FileWriter fileWriter = new FileWriter(string2 + ".csv");
            while (dataInputStream.available() > 0) {
                for (int i = 0; i < n; ++i) {
                    double d = dataInputStream.readDouble();
                    char c = ',';
                    if (i == n - 1) {
                        c = '\n';
                    }
                    fileWriter.write("" + d + c);
                }
            }
            dataInputStream.close();
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        System.err.println("done.");
    }

    private double[] getEquilibrationTime() {
        String string;
        String string2 = SimulationParams.sim_statsfile;
        if (string2.endsWith(".bdouble")) {
            string = string2.substring(0, string2.length() - 8);
        } else {
            string = new String(string2);
            string2 = string2 + ".bdouble";
        }
        this.logger.info("seeking equilibration time. window width is 100");
        this.logger.info("parsing sticky stats file '" + string2 + "'");
        this.logger.info("file name root is '" + string + "'");
        double[] dArray = new double[100];
        double[] dArray2 = new double[100];
        int n = 0;
        int n2 = this.Ns + 1;
        double[] dArray3 = new double[n2];
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        try {
            double d3 = 0.0;
            double d4 = 0.0;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string2));
            while (dataInputStream.available() > 0) {
                int n3;
                double d5;
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    double d6;
                    dArray3[n4] = d6 = dataInputStream.readDouble();
                }
                dArray[n % dArray.length] = dArray3[5];
                dArray2[n % dArray2.length] = dArray3[0];
                if (++n == 100) {
                    d3 = 0.0;
                    for (n4 = 0; n4 < 100; ++n4) {
                        d3 += dArray[n4];
                    }
                    d3 /= 100.0;
                }
                if (n <= 100) continue;
                d4 = 0.0;
                for (n4 = 0; n4 < 100; ++n4) {
                    d4 += dArray[n4];
                }
                double d7 = Math.abs((d4 /= 100.0) - d3);
                if (d7 < 0.1) {
                    d5 = Double.MAX_VALUE;
                    for (n3 = 0; n3 < 100; ++n3) {
                        if (!(dArray2[n3] < d5)) continue;
                        d5 = dArray2[n3];
                    }
                    return new double[]{d5, d4};
                }
                if (d7 < d) {
                    d = d7;
                    d5 = Double.MAX_VALUE;
                    for (n3 = 0; n3 < 100; ++n3) {
                        if (!(dArray2[n3] < d5)) continue;
                        d5 = dArray2[n3];
                    }
                    d2 = d5;
                }
                d3 = d4;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.logger.warning("equilibrium not reached in sticky stats file " + string2 + " lowest grad= " + d + " at " + d2);
        return null;
    }

    @Override
    public double[] getPostSimulationStats() {
        double[] dArray = new double[3];
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.walker.length; ++i) {
            StickyWalker stickyWalker = (StickyWalker)this.walker[i];
            if (stickyWalker.free) {
                d += stickyWalker.totalTimeStuck / (double)stickyWalker.numSticks;
                ++n;
                continue;
            }
            stickyWalker.totalTimeStuck += SimulationParams.duration - stickyWalker.lastStickTime;
            d += stickyWalker.totalTimeStuck / (double)stickyWalker.numSticks;
        }
        double[] dArray2 = this.getEquilibrationTime();
        dArray[0] = d /= (double)this.walker.length;
        if (dArray2 != null) {
            dArray[1] = dArray2[0];
            dArray[2] = dArray2[1];
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        SimulationParams.sim_statsfile = new String("allstats_0.3_0.1.bdouble");
        StickyStatsModule stickyStatsModule = new StickyStatsModule(null);
        stickyStatsModule.parseBinaryStatsFile(SimulationParams.sim_statsfile);
        double[] dArray = stickyStatsModule.getEquilibrationTime();
        System.err.println("Output from equilibration stats:");
        for (int i = 0; i < dArray.length; ++i) {
            System.err.println("\t" + dArray[i]);
        }
    }
}

