/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import mesd.SphDeconvKernels;
import misc.LoggedException;
import sphfunc.SphericalFunction;

public class MaxEntProfile
extends SphericalFunction {
    private double[] lambda;
    private double[] kernelParams;
    private static double[][] reconDirs;
    private static int noParams;

    public static void setReconDirs(double[][] dArray) {
        reconDirs = dArray;
        noParams = reconDirs.length + 1;
    }

    public static double[][] getLambdaDirs() {
        return reconDirs;
    }

    public static int getNumParams() {
        return noParams;
    }

    public MaxEntProfile(double[] dArray, double[] dArray2) {
        int n;
        this.kernelParams = new double[dArray2.length];
        for (n = 0; n < dArray2.length; ++n) {
            this.kernelParams[n] = dArray2[n];
        }
        this.lambda = new double[dArray.length - 2];
        if (this.lambda.length != noParams) {
            throw new LoggedException("Number of lambdas provided is " + this.lambda.length + ".  Expected " + noParams + ".");
        }
        for (n = 0; n < this.lambda.length; ++n) {
            this.lambda[n] = dArray[n + 2];
        }
    }

    @Override
    public double getRadius(double d, double d2, double d3) {
        double d4 = this.lambda[0];
        for (int i = 1; i < this.lambda.length; ++i) {
            double[] dArray = reconDirs[i - 1];
            double[] dArray2 = new double[]{d, d2, d3};
            d4 += this.lambda[i] * SphDeconvKernels.kernel(dArray, dArray2, this.kernelParams);
        }
        return Math.exp(d4);
    }

    public static int numLambdas() {
        return reconDirs.length + 1;
    }
}

