/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class LEFilterInputStream
extends FilterInputStream
implements DataInput {
    public LEFilterInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    @Override
    public char readChar() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n == -1 || n2 == -1) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        LEFilterInputStream lEFilterInputStream = this;
        synchronized (lEFilterInputStream) {
            n4 = this.in.read();
            n3 = this.in.read();
            n2 = this.in.read();
            n = this.in.read();
        }
        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    @Override
    public long readLong() throws IOException {
        long l = this.in.read();
        long l2 = this.in.read();
        long l3 = this.in.read();
        long l4 = this.in.read();
        long l5 = this.in.read();
        long l6 = this.in.read();
        long l7 = this.in.read();
        long l8 = this.in.read();
        if (l4 == -1L || l3 == -1L || l2 == -1L || l == -1L || l8 == -1L || l7 == -1L || l6 == -1L || l5 == -1L) {
            throw new EOFException();
        }
        return (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + l;
    }

    @Override
    public String readUTF() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        int n3 = (n << 8) + n2;
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6;
            int n7 = this.readUnsignedByte();
            int n8 = n7 >> 4;
            if (n8 < 8) {
                ++n4;
                cArray[n5++] = (char)n7;
                continue;
            }
            if (n8 == 12 || n8 == 13) {
                if ((n4 += 2) > n3) {
                    throw new UTFDataFormatException();
                }
                n6 = this.readUnsignedByte();
                if ((n6 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n5++] = (char)((n7 & 0x1F) << 6 | n6 & 0x3F);
                continue;
            }
            if (n8 == 14) {
                if ((n4 += 3) > n3) {
                    throw new UTFDataFormatException();
                }
                n6 = this.readUnsignedByte();
                int n9 = this.readUnsignedByte();
                if ((n6 & 0xC0) != 128 || (n9 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n5++] = (char)((n7 & 0xF) << 12 | (n6 & 0x3F) << 6 | n9 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n5);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        for (int i = 0; i < n; i += (int)this.skip(n - i)) {
        }
        return n;
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.in.read(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.in.read(byArray, n, n2);
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException("Can't use this deprecated method");
    }
}

