/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import data.VoxelOrderDataSource;
import numerics.Vector3D;
import tractography.PD_TractographyImage;

public class BallStickTractographyImage
extends PD_TractographyImage {
    public BallStickTractographyImage(Vector3D[][][][] vector3DArray, int[][][] nArray, double[] dArray) {
        super(vector3DArray, dArray, 1);
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    this.numPDs[i][j][k] = nArray[i][j][k];
                }
            }
        }
        this.computeIsotropicMask();
    }

    public BallStickTractographyImage(VoxelOrderDataSource voxelOrderDataSource, int[] nArray, double[] dArray) {
        super(nArray, dArray, 1);
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    double[] dArray2 = voxelOrderDataSource.nextVoxel();
                    this.numPDs[k][j][i] = dArray2[0] < 0.0 ? 0 : 1;
                    this.vectors[k][j][i] = new Vector3D[]{new Vector3D(dArray2[4], dArray2[5], dArray2[6])};
                }
            }
        }
        this.computeIsotropicMask();
    }

    protected BallStickTractographyImage(BallStickTractographyImage ballStickTractographyImage) {
        super(ballStickTractographyImage);
    }

    public static final BallStickTractographyImage getBallStickTractographyImage(String string, String string2, double[][][] dArray, double d, int[] nArray, double[] dArray2) {
        int n = 7;
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n, string2);
        BallStickTractographyImage ballStickTractographyImage = new BallStickTractographyImage(voxelOrderDataSource, nArray, dArray2);
        if (dArray != null) {
            ballStickTractographyImage.computeIsotropicMask(dArray, d);
        }
        return ballStickTractographyImage;
    }
}

